//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Ip.cpp: implementation of the Ip class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "Ip.h"
#include "defines.h" 

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif
/*
struct Ip2Country {
	char * ipFrom ;
	char * ipTo ;
	char * registry ;
	char * assigned ;
	char * cntry1 ;
	char * cntry2 ;
	char * fullCountry ;

	Ip2Country(char * ipF, char * ipT, char * reg, char * assi, char *cnt1, char * cnt2, char * full){
		ipFrom = ipF;
		ipTo = ipT ;
		registry = reg ;
		assigned = assi ;
		cntry1 = cnt1 ;
		cntry2 = cnt2 ;
		fullCountry = full ;
	}
} ;*/




//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Ip::Ip (CString adr)
{
	BYTE i1 = 0, i2 = 0, i3 = 0, i4 = 0;
	UINT port = 0 ;
	sscanf (STR_BUFFER(adr), "%d.%d.%d.%d:%d", &i1, &i2, &i3, &i4, &port) ;
	this->port = port ;
	this->ip.Format ("%d.%d.%d.%d",i1,i2,i3,i4) ;
	this->ipTotal = adr ;

	ipb[0] = i4 ;
	ipb[1] = i3 ;
	ipb[2] = i2 ;
	ipb[3] = i1 ;
}

//adresse IP sous la form b1.b2.b3.b4:port
Ip::Ip (BYTE b1, BYTE b2, BYTE b3, BYTE b4, UINT port)
{
	this->ip.Format ("%d.%d.%d.%d", b1, b2, b3, b4) ;
	this->port = port ;
	this->ipTotal.Format ("%s:%d", ip, port) ;
	ipb[0] = b4 ;
	ipb[1] = b3 ;
	ipb[2] = b2 ;
	ipb[3] = b1 ;
}


Ip::~Ip()
{

}

CString Ip::getIp ()
{
	return (this->ip) ;
}

// indique si cette ip est correcte
bool Ip::estCorrect (CString adr)
{
	bool retour = true ;

	BYTE i1 = 0, i2 = 0, i3 = 0, i4 = 0;
	UINT port = 0 ;
	sscanf (STR_BUFFER(adr), "%d.%d.%d.%d:%d", &i1, &i2, &i3, &i4, &port) ;
	adr.ReleaseBuffer() ;

	if (i4 == 0)		retour = false ;

	return (retour) ;
}

UINT Ip::getPort ()
{
	return (this->port) ;
}

// renvoie l'ip sous la forme ip:port
CString Ip::getIpTotal ()
{
	return (this->ipTotal) ;
}

BYTE * Ip::getBytes() {
	return (ipb) ;
}