//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
//	Fichier	|	Ini.h														 //
///////////////////////////////////////////////////////////////////////////////
//	Role	|	Cette classe permet de sauvegarder les options dans un		 //
//			|	fichier puis de les restaurer au prochain demarrage			 //
///////////////////////////////////////////////////////////////////////////////

#ifndef _INI_H
#define _INI_H

#include "Exception.h"

class Ini
{
public:
	// constructeur
	// ouvre le fichier ini en lecture
	// leve une exception si le fichier n'a pas pu etre ouvert
	Ini (CString fichier) throw (Exception) ;
	~Ini () ;

	// operations de lecture dans le fichier ini
	// retourne la valeur en face de nom dans le fichier ini
	// retourne defaut si le nom n'existe pas
	int readInt (CString nom, int defaut) ;
	CString readString (CString nom, CString defaut) ;
	float readFloat (CString nom, float defaut) ;
	DWORD readColor (CString nom, DWORD defaut) ;
	bool readBool (CString nom, bool defaut) ;

	// positionne le mode d'acces en ecriture et efface le precedant ini
	// leve une exception si le fichier est proteg en ecriture
	void SetWrite () throw (Exception) ;

	// operations d'ecriture
	void write (CString nom, int valeur) ;
	void write (CString nom, CString valeur) ;
	void write (CString nom, float valeur) ;
	void write (CString nom, DWORD valeur) ;
	void write (CString nom, bool valeur) ;

private:
	FILE * file ;
	CString nomFic ;

	// lit une ligne du fichier
	// separe le nom et la valeur recuperee
	void readLine (char * nom, char * valeur) ;

} ;

#endif
