//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "ini.h"

// fournit les composante rouge, vert, bleu a partir de la couleur
/*#define BLUE(rgb)		((rgb) >> 16)
#define GREEN(rgb)		(((rgb) % 0xFFFF) >> 8)
#define RED(rgb)		((rgb) % 0xFF)*/

// constructeur
// ouvre le fichier ini en lecture
Ini::Ini (CString fichier)
{
	this->file = fopen (fichier, "r") ;
	if (!this->file)
	{
		// le fichier n'existe pas, on tente de le creer
		this->file = fopen (fichier, "w") ;
		if (!this->file)
		{
			throw (Exception (CString ("Erreur de creation du fichier ") + fichier)) ;
		}
		fclose (file) ;
		// la creation a reussi, on l'ouvre en lecture
		fopen (fichier, "r") ;
		if (!file)
		{
			throw (Exception (CString ("Erreur d'ouverture du fichier ") + fichier)) ;
		}
	}
	this->nomFic = fichier ;
	
}

Ini::~Ini ()
{
	fclose (this->file) ;
}

// positionne le mode d'acces en ecriture et efface le precedant ini
void Ini::SetWrite ()
{
	this->file = fopen (this->nomFic, "w") ;
	if (!this->file)
	{
		throw (Exception (CString ("Erreur d'ouverture en ecriture du fichier ") + this->nomFic)) ;
	}
}

// operations de lecture dans le fichier ini
// retourne la valeur en face de nom dans le fichier ini
// retourne defaut si le nom n'existe pas
int Ini::readInt (CString nom, int defaut)
{
	CString param ;
	param.Format ("%d",defaut) ;
	CString retour = this->readString(nom, param) ;
	int ret = atoi(retour.GetBuffer(retour.GetLength()));
	retour.ReleaseBuffer() ;
	return (ret) ;
}

float Ini::readFloat (CString nom, float defaut)
{
	CString param ;
	param.Format ("%f",defaut) ;
	CString retour = this->readString(nom, param) ;
	float ret = atof(retour.GetBuffer(retour.GetLength()));
	retour.ReleaseBuffer() ;
	return (ret) ;
}

DWORD Ini::readColor (CString nom, DWORD defaut)
{
	CString param ;
	param.Format ("(%d,%d,%d)",GetRValue(defaut), GetGValue(defaut), GetBValue(defaut)) ;
	CString retour = this->readString(nom, param) ;
	UINT red, green, blue ;
	sscanf (retour.GetBuffer(0), "(%d,%d,%d)", &red, &green, &blue) ;
	DWORD ret = RGB(red, green, blue) ;
	retour.ReleaseBuffer() ;
	return (ret) ;
}

bool Ini::readBool (CString nom, bool defaut)
{
	return ((bool)this->readInt (nom, (int)defaut)) ;
}

CString Ini::readString (CString nom, CString defaut)
{
	CString retour = defaut ;

	char nomC[128] ;
	char val[128] ;
	memset (nomC, 0, sizeof(nomC)) ;
	memset (val, 0, sizeof(nomC)) ;

	fseek (this->file, 0, SEEK_SET) ;
	while (!feof(file))
	{
		this->readLine (nomC, val) ;
		if (strcmp (nomC, nom) == 0)
		{
			retour = CString (val) ;
		}
	}
	return (retour) ;
}


// operations d'ecriture
void Ini::write (CString nom, int valeur)
{
	CString param ;
	param.Format ("%d", valeur) ;
	this->write (nom, param) ;
}

void Ini::write (CString nom, CString valeur)
{
	fprintf (file, "%s", nom.GetBuffer(nom.GetLength())) ;
	fprintf (file, "=") ;
	fprintf (file, "%s\n", valeur.GetBuffer(valeur.GetLength())) ;

	nom.ReleaseBuffer () ;
	valeur.ReleaseBuffer () ;
}

void Ini::write (CString nom, float valeur)
{
	CString param ;
	param.Format ("%f",valeur) ;
	this->write (nom, param) ;
}

void Ini::write (CString nom, DWORD valeur)
{
	CString param ;
	param.Format ("(%d,%d,%d)",GetRValue(valeur), GetGValue(valeur), GetBValue(valeur)) ;
	this->write (nom, param) ;
}

void Ini::write (CString nom, bool valeur)
{
	this->write (nom, (int)valeur) ;
}

// lit une ligne du fichier
// separe le nom et la valeur recuperee
void Ini::readLine (char * nom, char * valeur)
{
	// format de la ligne : "nom=valeur"
	int i = 0 ;
	
	// lecture du nom
	do
	{
		fread (&nom[i++], 1, 1, file) ;
	} while (!feof(this->file) && nom[i - 1] != '=') ;
	nom[i - 1] = '\0' ;

	// lecture de la valeur
	i = 0 ;
	do
	{
		valeur[i++] = fgetc (this->file) ;
	} while (!feof(this->file) && valeur[i - 1] != 0x0a) ;
	valeur[i - 1] = '\0' ;
	

}