//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#if !defined(AFX_INFOSSERVEURDLG_H__66A1FAB4_95E4_47C9_824A_F7980CD44D2D__INCLUDED_)
#define AFX_INFOSSERVEURDLG_H__66A1FAB4_95E4_47C9_824A_F7980CD44D2D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// InfosServeurDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// InfosServeurDlg dialog

#include "Server.h"
#include "ResizableLib/ResizableDialog.h"
#include "ListCtrl.h"
#include "PlayerListCtrl.h"
#include "Observer.h"
#include <vector>
#include "Joueur.h"
#include "CountryImage.h"

using namespace std ;



class InfosServeurDlg : public CResizableDialog, public Observer
{
private:
	Server * serveur ;
	vector<CStatic *>	m_states ;
	vector<CString>		m_selectedPlayers ;
	
	void afficherInfos () ;

	CMenu m_contextPlayers ;
	CMenu m_contextServeur ;

	void initStates () ;
	void drawState (CStatic * state) ;
	// Construction
public:
	InfosServeurDlg(CWnd* pParent = NULL);   // standard constructor
	void afficher (Server * server) ;

	// appelle la fonction lorsque l'objet a ete modifie
	virtual void OnChange (Objet * obj, UINT msg, void * param1,void * param2) ;



// Dialog Data
	//{{AFX_DATA(InfosServeurDlg)
	enum { IDD = IDD_INFOS_SERVER };
	CEdit	m_infoPlayer;
	CEdit	m_ping;
	CEdit	m_cntName;
	CountryImage	m_cnt;
	CEdit	m_name;
	CStatic	m_restrict;
	CStatic	m_pb;
	CStatic	m_np;
	CStatic	m_ml;
	CStatic	m_ff;
	CStatic	m_balanced;
	CStatic	m_ef;
	CStatic	m_al;
	CEdit	m_mapName;
	CTabCtrl	m_tab;
	CSpinButtonCtrl	m_addSubTime;
	CEdit	m_tempsRefresh;
	CButton	m_autoRefresh;
	ListCtrl	m_variables;
	PlayerListCtrl	m_players;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(InfosServeurDlg)
	public:
	virtual int DoModal(Server * serveur);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(InfosServeurDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMove(int x, int y);
	afx_msg void OnClose();
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnAutoRefresh();
	afx_msg void OnChangeTempsRefresh();
	afx_msg void OnDeltaposAddSubRefr(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnClickPlayers(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnRclickPlayers(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclkPlayers(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclkVariables(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnRclickVariables(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	afx_msg void OnAddPlayer();
	afx_msg void OnAddFav();
	afx_msg void OnRemoveFav();
	afx_msg void OnJoin();
	afx_msg void OnRefresh();

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_INFOSSERVEURDLG_H__66A1FAB4_95E4_47C9_824A_F7980CD44D2D__INCLUDED_)
