//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// InfosServeurDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "InfosServeurDlg.h"
#include "ClientMaster.h"
#include "ETBuddiesDlg.h"


#define HEADER_NOM_VAR			"Name of var"
#define HEADER_VALUE_VAR		"Value"

#define ATTENTE_REFRESH			(MAIN_PREF->getTempsRefreshServer() * 1000)

#define TITRE_FENETRE			"Statistics for %s [%s]"

#define HAUTEUR_FENETRE(nbLignes)	(((nbLignes) * 12) + 100)

#define TAB_PLAYERS					0
#define TAB_VAR						1

#define ALIGN_STATE_LEFT			22
#define ALIGN_STATE_TOP				83		
#define STATE_WIDTH					16		

#define WM_ADD_FRIEND		(WM_USER + 1)
#define WM_REFRESH			(WM_USER + 2)
#define WM_JOIN				(WM_USER + 3)
#define WM_ADD_FAV			(WM_USER + 4) 
#define WM_REMOVE_FAV		(WM_USER + 5)
	


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// InfosServeurDlg dialog


InfosServeurDlg::InfosServeurDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(InfosServeurDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(InfosServeurDlg)
	//}}AFX_DATA_INIT
	this->serveur = NULL ;
	this->Create (IDD, pParent) ;
	
}


void InfosServeurDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(InfosServeurDlg)
	DDX_Control(pDX, IDC_PLAYER_INFOS, m_infoPlayer);
	DDX_Control(pDX, IDC_PING, m_ping);
	DDX_Control(pDX, IDC_CNT_NAME, m_cntName);
	DDX_Control(pDX, IDC_CNT, m_cnt);
	DDX_Control(pDX, IDC_NAME, m_name);
	DDX_Control(pDX, IDC_RESTRICT, m_restrict);
	DDX_Control(pDX, IDC_PB, m_pb);
	DDX_Control(pDX, IDC_NP, m_np);
	DDX_Control(pDX, IDC_ML, m_ml);
	DDX_Control(pDX, IDC_FF, m_ff);
	DDX_Control(pDX, IDC_BALANCED, m_balanced);
	DDX_Control(pDX, IDC_EF, m_ef);
	DDX_Control(pDX, IDC_AL, m_al);
	DDX_Control(pDX, IDC_MAP, m_mapName);
	DDX_Control(pDX, IDC_TAB, m_tab);
	DDX_Control(pDX, IDC_ADD_SUB_REFR, m_addSubTime);
	DDX_Control(pDX, IDC_TEMPS_REFRESH, m_tempsRefresh);
	DDX_Control(pDX, IDC_AUTO_REFRESH, m_autoRefresh);
	DDX_Control(pDX, IDC_VARIABLES, m_variables);
	DDX_Control(pDX, IDC_PLAYERS, m_players);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(InfosServeurDlg, CResizableDialog)
	//{{AFX_MSG_MAP(InfosServeurDlg)
	ON_WM_SIZE()
	ON_WM_MOVE()
	ON_WM_CLOSE()
	ON_WM_KEYUP()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_AUTO_REFRESH, OnAutoRefresh)
	ON_EN_CHANGE(IDC_TEMPS_REFRESH, OnChangeTempsRefresh)
	ON_NOTIFY(UDN_DELTAPOS, IDC_ADD_SUB_REFR, OnDeltaposAddSubRefr)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, OnSelchangeTab)
	ON_NOTIFY(NM_CLICK, IDC_PLAYERS, OnClickPlayers)
	ON_NOTIFY(NM_RCLICK, IDC_PLAYERS, OnRclickPlayers)
	ON_NOTIFY(NM_DBLCLK, IDC_PLAYERS, OnDblclkPlayers)
	ON_NOTIFY(NM_DBLCLK, IDC_VARIABLES, OnDblclkVariables)
	ON_NOTIFY(NM_RCLICK, IDC_VARIABLES, OnRclickVariables)
	//}}AFX_MSG_MAP
	ON_COMMAND(WM_ADD_FRIEND, OnAddPlayer)
	ON_COMMAND(WM_ADD_FAV, OnAddFav)
	ON_COMMAND(WM_REMOVE_FAV, OnRemoveFav)
	ON_COMMAND(WM_JOIN, OnJoin)
	ON_COMMAND(WM_REFRESH, OnRefresh)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// InfosServeurDlg message handlers

int InfosServeurDlg::DoModal(Server * serveur) 
{
	// TODO: Add your specialized code here and/or call the base class
//	if (!serveur) {
		return (IDCANCEL) ;
//	}

	this->serveur = serveur ;
	return CResizableDialog::DoModal();
}

void InfosServeurDlg::afficher (Server * server) {
	MAIN_DLG->getListeBud()->getClientMaitre()->ajouterObserver(this) ;
	this->initStates() ;
	this->serveur = server ;
	this->ShowWindow (SW_SHOW) ;
	this->afficherInfos() ;
	this->SetFocus() ;
		
}

void InfosServeurDlg::afficherInfos ()
{
	this->m_variables.DeleteAllItems () ;
	this->initStates() ;
	if (!this->serveur)		return ;

	CString titre ;
	titre.Format (TITRE_FENETRE, this->serveur->getNom(), this->serveur->getIp()->getIpTotal()) ;
	this->SetWindowText (titre) ;

	UINT id = 0 ;

	m_players.afficheServeur(serveur) ;


	/****************************************************
	* Affichage de toutes les variables du serveur		*
	****************************************************/
	map<CString, CString> * variables = this->serveur->getVariables() ;
	FOR_MAP_IND(CString, CString, (*variables), j)
	{
		this->m_variables.InsertItem (id, j->first);
		this->m_variables.SetItemText(id, 1, j->second) ;
		id++;

	}

	/****************************************************
	* Affichage du status		*
	****************************************************/
	this->m_mapName.SetWindowText (this->serveur->getNomMap()) ;
	CString nom ;
	nom.Format ("%s[%s]", serveur->getNom(), serveur->getIp()->getIpTotal()) ;
	this->m_name.SetWindowText (nom) ;
	
	if (serveur->estPlein() || serveur->estVide()) 		this->drawState(&m_ef) ;
	if (serveur->getIntVariable (VAR_NEED_PASS) > 0) 	this->drawState(&m_np) ;
	if (serveur->getIntVariable (VAR_RESTRICT) > 0) 	this->drawState(&m_restrict) ;
	if (serveur->getIntVariable (VAR_PB) > 0) 			this->drawState(&m_pb) ;
	if (serveur->getIntVariable (VAR_MAX_LIVES) > 0) 	this->drawState(&m_ml) ;
	if (serveur->getIntVariable (VAR_FF) > 0) 			this->drawState(&m_ff) ;
	if (serveur->getIntVariable (VAR_BALANCED) > 0) 	this->drawState(&m_balanced) ;
	if (serveur->getIntVariable (VAR_ANTI_LAG) > 0) 	this->drawState(&m_al) ;


	m_cnt.setServer(serveur) ;
	m_cnt.Invalidate() ;

	m_cntName.SetWindowText(serveur->getCountry() ? serveur->getCountry()->fullCountry : "Unknown") ;
	CString ping ;
	ping.Format("Ping: %d ms", serveur->getPing()) ;
	m_ping.SetWindowText(ping) ;
	
	CString players ;
	UINT priv = serveur->getPrivateClients() ;
	if (priv > 0) {
		players.Format("Players: %d/%d (+%d)", serveur->getNbJoueurs(), serveur->getMaxPublicJoueurs(), priv) ;
	}
	else {
		players.Format("Players: %d/%d", serveur->getNbJoueurs(), serveur->getMaxPublicJoueurs()) ;
	}
	m_infoPlayer.SetWindowText(players) ;
	

	
	



	
		

		
}

BOOL InfosServeurDlg::OnInitDialog() 
{
	CResizableDialog::OnInitDialog();

	this->m_players.initControl () ;
	this->m_variables.initControl () ;


	
	// TODO: Add extra initialization here
	AddAnchor (IDC_PLAYERS,			TOP_LEFT,	BOTTOM_RIGHT) ;
	AddAnchor (IDC_VARIABLES,		TOP_LEFT,	BOTTOM_RIGHT) ;
	AddAnchor (IDC_TAB,				TOP_LEFT,	TOP_RIGHT) ;
	AddAnchor (IDC_STATUS_GRID,		TOP_LEFT,	TOP_RIGHT) ;
	AddAnchor (IDC_REFRESH_GRID,	TOP_RIGHT,	TOP_RIGHT) ;
	AddAnchor (IDC_NAME,			TOP_LEFT,	TOP_RIGHT) ;
	AddAnchor (IDC_MAP,				TOP_LEFT,	TOP_RIGHT) ;
	AddAnchor (IDC_CNT_NAME,		TOP_LEFT,	TOP_RIGHT) ;
	AddAnchor (IDC_AUTO_REFRESH,	TOP_RIGHT,	TOP_RIGHT) ;
	AddAnchor (IDC_TEMPS_REFRESH,	TOP_RIGHT,	TOP_RIGHT) ;
	AddAnchor (IDC_ADD_SUB_REFR,	TOP_RIGHT,	TOP_RIGHT) ;
	AddAnchor (IDC_PING_GRID,		TOP_RIGHT,	TOP_RIGHT) ;
	AddAnchor (IDC_PING,			TOP_RIGHT,	TOP_RIGHT) ;
	AddAnchor (IDC_PLAYER_INFOS,	TOP_RIGHT,	TOP_RIGHT) ;


	this->m_variables.InsertColumn (0,	HEADER_NOM_VAR,		LVCFMT_LEFT, 200) ;
	this->m_variables.InsertColumn (1,	HEADER_VALUE_VAR,	LVCFMT_LEFT, 200) ;


	this->afficherInfos () ;

	EnableSaveRestore (_T("InfosServeur")) ;

	this->m_autoRefresh.SetCheck (MAIN_PREF->getAutoRefresh()) ;
	SetDlgItemInt (IDC_TEMPS_REFRESH, MAIN_PREF->getTempsRefreshServer()) ;
	this->OnAutoRefresh () ;

	this->SetTimer(0, ATTENTE_REFRESH, NULL) ;

	this->m_tab.InsertItem (TAB_PLAYERS,	"Players") ;
	this->m_tab.InsertItem (TAB_VAR,		"Variables") ;
	
	m_contextPlayers.CreatePopupMenu() ;
	m_contextPlayers.InsertMenu (0, MF_BYPOSITION|MF_STRING, WM_JOIN,			"Join this server") ;
	m_contextPlayers.InsertMenu (1, MF_BYPOSITION|MF_STRING, WM_ADD_FRIEND,		"Add this player") ;
	m_contextPlayers.InsertMenu (2, MF_BYPOSITION|MF_STRING, WM_REFRESH,		"Refresh this server") ;
	m_contextPlayers.InsertMenu (3, MF_BYPOSITION|MF_STRING, WM_ADD_FAV,		"Add to favorites") ;
	m_contextPlayers.InsertMenu (4, MF_BYPOSITION|MF_STRING, WM_REMOVE_FAV,		"Remove from favorites") ;
	m_contextPlayers.SetDefaultItem (WM_JOIN) ;

	m_contextServeur.CreatePopupMenu() ;
	m_contextServeur.InsertMenu (0, MF_BYPOSITION|MF_STRING, WM_JOIN,			"Join this server") ;
	m_contextServeur.InsertMenu (1, MF_BYPOSITION|MF_STRING, WM_REFRESH,		"Refresh this server") ;
	m_contextServeur.InsertMenu (2, MF_BYPOSITION|MF_STRING, WM_ADD_FAV,		"Add to favorites") ;
	m_contextServeur.InsertMenu (3, MF_BYPOSITION|MF_STRING, WM_REMOVE_FAV,		"Remove from favorites") ;
	m_contextServeur.SetDefaultItem (WM_JOIN) ;


	return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void InfosServeurDlg::OnSize(UINT nType, int cx, int cy) 
{
	CResizableDialog::OnSize(nType, cx, cy);
	this->ArrangeLayout() ;
	this->m_players.Invalidate() ;
	this->m_variables.Invalidate() ;
	// TODO: Add your message handler code here
	
}


void InfosServeurDlg::OnMove(int x, int y) 
{
	CResizableDialog::OnMove(x, y);
	this->m_players.Invalidate() ;
	this->m_variables.Invalidate() ;
	// TODO: Add your message handler code here
	
}

void InfosServeurDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	this->ShowWindow (SW_HIDE) ;
	//CResizableDialog::OnClose();
}


// appelle la fonction lorsque l'objet a ete modifie
/*virtual*/ void InfosServeurDlg::OnChange (Objet * obj, UINT msg, void * param1,void * param2)
{
	if (msg == ClientMaster::ON_REFRESH_UN_SERVER && param1 == this->serveur) {
		this->afficherInfos() ;
	}
	else if (msg == ClientMaster::ON_SERVER_DELETE) {
		this->serveur = NULL ;
		this->ShowWindow (SW_HIDE) ;
		//this->afficherInfos() ;
	}
}

void InfosServeurDlg::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	if (!this->serveur)		return ;
	switch (nChar) {
	case VK_F5:
		this->serveur->rafraichir() ;
		break ;
	}
	CResizableDialog::OnKeyUp(nChar, nRepCnt, nFlags);
}

void InfosServeurDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	if (this->serveur && this->IsWindowVisible() && this->m_autoRefresh.GetCheck()) {
		this->serveur->rafraichir() ;
	}
	CResizableDialog::OnTimer(nIDEvent);
}

void InfosServeurDlg::OnAutoRefresh() {
	// TODO: Add your control notification handler code here
	bool autoRefresh = (this->m_autoRefresh.GetCheck() != 0) ;
	this->m_tempsRefresh.EnableWindow	(autoRefresh) ;
	this->m_addSubTime.EnableWindow		(autoRefresh) ;
	MAIN_PREF->setAutoRefresh (autoRefresh) ;
}

void InfosServeurDlg::OnChangeTempsRefresh() 
{
	
	int temps = GetDlgItemInt (IDC_TEMPS_REFRESH, NULL, FALSE) ;
	if (temps == 0) {
		this->m_autoRefresh.SetCheck(FALSE) ;
		SetDlgItemInt (IDC_TEMPS_REFRESH, MAIN_PREF->getTempsRefreshServer()) ;
		this->OnAutoRefresh() ;
		this->KillTimer (0) ;
	}
	else
	{
		try
		{
			MAIN_PREF->setTempsRefreshServer (temps) ;
			this->KillTimer (0) ;
			this->SetTimer (0, ATTENTE_REFRESH, NULL) ;
		}
		CATCH_EXCEPTION;
	}
}

/* add or remove 1 second for refresh */
void InfosServeurDlg::OnDeltaposAddSubRefr(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here
	int temps = GetDlgItemInt(IDC_TEMPS_REFRESH) - pNMUpDown->iDelta ;
	if (temps > 0) {
		SetDlgItemInt (IDC_TEMPS_REFRESH, temps, FALSE) ;
	}
	*pResult = 0;
}

void InfosServeurDlg::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	switch (m_tab.GetCurSel())
	{
	case TAB_PLAYERS:
		m_players.ShowWindow (SW_SHOW) ;
		m_variables.ShowWindow (SW_HIDE) ;
		break;
	case TAB_VAR:
		m_players.ShowWindow (SW_HIDE) ;
		m_variables.ShowWindow (SW_SHOW) ;
		break;
	}

	*pResult = 0;
}


void InfosServeurDlg::drawState (CStatic * state)
{
	state->SetWindowPos (NULL, ALIGN_STATE_LEFT + m_states.size()*STATE_WIDTH,  ALIGN_STATE_TOP,0,0,SWP_NOSIZE|SWP_NOZORDER) ;
	state->ShowWindow (SW_SHOW) ;
	this->m_states.push_back (state) ;

}

void InfosServeurDlg::initStates ()
{
	m_states.clear() ;
}

void InfosServeurDlg::OnClickPlayers(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	

	*pResult = 0;
}

void InfosServeurDlg::OnRclickPlayers(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_selectedPlayers.clear() ;
	POSITION pos = m_players.GetFirstSelectedItemPosition();
	while (pos)
	{
		int nItem = m_players.GetNextSelectedItem(pos);
		Joueur * selection = (Joueur*)m_players.GetItemData (nItem) ;
		m_selectedPlayers.push_back(selection->getNom()) ;
	}


	CPoint pt ;
	GetCursorPos(&pt) ;
	bool isFav = MAIN_DLG->getFavorites()->isFavorite(serveur) ;
	UINT state = isFav ? MF_GRAYED : MF_ENABLED ;
	UINT state2 = isFav ? MF_ENABLED : MF_GRAYED ;
	UINT addPlayer = m_selectedPlayers.size() > 0 ? MF_ENABLED: MF_GRAYED ;
	
	m_contextPlayers.EnableMenuItem (WM_ADD_FAV,		state|MF_BYCOMMAND);
	m_contextPlayers.EnableMenuItem (WM_REMOVE_FAV,		state2|MF_BYCOMMAND);
	m_contextPlayers.EnableMenuItem (WM_ADD_FRIEND,		addPlayer|MF_BYCOMMAND);
	m_contextPlayers.TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pt.x, pt.y, this);  
	

	*pResult = 0;
}

void InfosServeurDlg::OnAddPlayer()
{
	FOR_VECTOR(CString, m_selectedPlayers) {
		try {
			MAIN_DLG->getListeBud()->ajouterBuddie(new Buddie(*i)) ;
		}
		catch (Exception e) {
			MessageBox(e.getMessage(), "Can't add this friend", MB_OK|MB_ICONERROR) ;
		}
	}
}

void InfosServeurDlg::OnAddFav(){
	MAIN_DLG->getFavorites()->addServer(serveur) ;
	if (serveur)	serveur->rafraichir() ;
}

void InfosServeurDlg::OnRemoveFav(){
	MAIN_DLG->getFavorites()->removeServer(serveur) ;
	if (serveur)	serveur->rafraichir() ;
}

void InfosServeurDlg::OnJoin(){
	MAIN_DLG->connection(serveur->getIp()) ;
}

void InfosServeurDlg::OnRefresh(){
	if (serveur) {
		serveur->rafraichir() ;
	}
}

void InfosServeurDlg::OnDblclkPlayers(NMHDR* pNMHDR, LRESULT* pResult) {
	OnJoin() ;
	*pResult = 0;
}

void InfosServeurDlg::OnDblclkVariables(NMHDR* pNMHDR, LRESULT* pResult) {
	OnJoin() ;
	*pResult = 0;
}

void InfosServeurDlg::OnRclickVariables(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CPoint pt ;
	GetCursorPos(&pt) ;
	bool isFav = MAIN_DLG->getFavorites()->isFavorite(serveur) ;
	UINT state = isFav ? MF_GRAYED : MF_ENABLED ;
	UINT state2 = isFav ? MF_ENABLED : MF_GRAYED ;
	
	m_contextServeur.EnableMenuItem (WM_ADD_FAV,		state|MF_BYCOMMAND);
	m_contextServeur.EnableMenuItem (WM_REMOVE_FAV,		state2|MF_BYCOMMAND);
	m_contextServeur.TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pt.x, pt.y, this);  
	*pResult = 0;
}
