//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
//	Fichier	|	Image.h														 //
///////////////////////////////////////////////////////////////////////////////
//	Role	|	Cette classe permet l'ouverture et l'affichage d'une image	 //
///////////////////////////////////////////////////////////////////////////////

#ifndef _IMAGE_H
#define _IMAGE_H

#include "Exception.h"
#include "Objet.h"

#define HIMETRIC_INCH		2540

class Partie
{
public:
	UINT pos ;
	CRect coordonnees ;
	Partie (UINT pos, CRect coor) {this->pos = pos; this->coordonnees = coor;}
} ;


class Image : public Objet // derive de la classe Objet pour l'utilisation des observer
{
private:
	
	
protected:
	// retourne vrai si le point est dans cette image
	BOOL inRect (CPoint point) ;

	CRect * rect ;

	CRect getCoord (UINT pos, Partie * liste, UINT fin) ;

public:
	static CString NOM_CLASSE ;
	// message indiquant que l'image a besoin d'etre redessinee
	// lorsque ce message est envoy, met dans param1 un pointeur de CRect contenant la position de l'image
	static UINT ON_REDRAW ;

	// constructeurs
	Image (CString nom) throw (Exception) ;
	Image (UINT id, CString type) throw (Exception) ;
	//Image () ;

	~Image () ;

	// charge l'image a partir du fichier nom
	// leve une exception si l'image ne peut etre charge
	void LoadImage (CString nom) throw (Exception) ;

	// charge l'image a partir de la ressource id
	// leve une Exception si l'image ne peut etre charge
	// type = le nom de la categorie dans laquelle se trouve l'image dans l'editeur de ressources (ex "DATA", "Bitmap",...)
	void LoadImage (UINT id, CString type) throw (Exception) ;

	// affiche l'image sur le CDC a la position (x,y)
	// leve une Exception en cas d'erreur d'affichage
	virtual void afficher (CDC * dc, int x = 0, int y = 0) throw (Exception) ;

	// affiche l'image sur le CDC a la position (x,y)
	// et au dimensions cx, cy
	// leve une Exception en cas d'erreur d'affichage
	virtual void afficher (CDC * dc, int x, int y, int cx, int cy) throw (Exception) ;

	// affiche le morceau d'image contenu dans rect
	virtual void afficher (CDC * dc, CRect src, int x, int y, int cx, int cy) throw (Exception) ;
	virtual void afficher (CDC * dc, CRect src, int x, int y) throw (Exception) ;

	// retourne la taille de l'image
	virtual CPoint getSize (CDC * dc) ;

	// retourne la derniere position et taille de l'image
	// retourne NULL si elle n'a pas encore ete affiche
	CRect * getRectIm () ;

	// indique a l'image que l'utilisateur a clique a cette position
	// retourne TRUE si la souris se trouve sur l'image
	virtual BOOL OnLButtonDown (CPoint pSouris) ;

	// indique a l'image que l'utilisateur a clique a cette position
	// retourne TRUE si la souris se trouve sur l'image
	virtual BOOL OnLButtonUp (CPoint pSouris) ;

	// indique a l'image que l'utilisateur a boug la souris
	// retourne TRUE si la souris se trouve sur l'image
	virtual BOOL OnMouseMove (CPoint pSouris) ;

	// indique a l'image que l'utilisateur a double-clique a cette position
	// retourne TRUE si la souris se trouve sur l'image
	virtual BOOL OnLButtonDblClk (CPoint pSouris) ;

	virtual BOOL OnRButtonUp (CPoint pSouris) ;

	// retourne les dimensions et positions de l'image affiche en dernier
	// retourne NULL si l'image n'a pas ete affichee
	CRect * getRect () {return (this->rect);}

private:
	// charge le buffer de taille size octets
	bool chargerBuffer (BYTE * buffer, int size) ;

	// image proprement dite
	IPicture * image ;



} ;

#endif