//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "image.h"
#include "defines.h"
#include "ressource.h"

/*static*/ CString Image::NOM_CLASSE = "Image" ;

// message indiquant que l'image a besoin d'etre redessinee
// lorsque ce message est envoy, met dans param1 un pointeur de CRect contenant la position de l'image
/*static*/ UINT Image::ON_REDRAW = 4 ;

// constructeurs
Image::Image (CString nom) throw (Exception) : Objet (NOM_CLASSE)
{
	this->image = NULL ;
	this->rect = NULL ;
	this->LoadImage(nom) ;
}

Image::Image (UINT id, CString type) throw (Exception) : Objet (NOM_CLASSE)
{
	this->image = NULL ;
	this->rect = NULL ;
	this->LoadImage(id, type) ;
}
/*
Image::Image () : Objet ("Image")
{
this->image = NULL ;
}*/

Image::~Image ()
{
	if (this->image)
	{
		this->image->Release() ;
		if (this->rect)		delete (this->rect) ;
		this->rect = NULL ;
		this->image = NULL ;
	}
}

// charge l'image a partir du fichier nom
// leve une Exception si l'image ne peut etre charge
void Image::LoadImage (CString nom) throw (Exception)
{
	if (this->image)
	{
		this->image->Release() ;
	}
	
	if (this->rect)		delete (this->rect) ;
	this->rect = NULL ;
	
	CFile file;
	CFileException e;
	
	if (file.Open(nom, CFile::modeRead | CFile::typeBinary, &e))
	{
		BYTE* pBuff = new BYTE[file.GetLength()];
		if (file.Read(pBuff, file.GetLength()) > 0)
		{
			if (!this->chargerBuffer (pBuff, file.GetLength()))
			{
				throw (Exception (CString("Impossible de charger l'image ") + nom)) ;
			}
		}
		else
		{
			throw (Exception (CString("Impossible de lire le fichier ") + nom)) ;
		}
		delete [] pBuff;
	}
	else
	{
		throw (Exception (CString("Impossible d'ouvrir le fichier ") + nom)) ;
	}
	//this->notifierObs () ;
}

// charge l'image a partir de la ressource id
// leve une Exception si l'image ne peut etre charge
void Image::LoadImage (UINT id, CString type) throw (Exception)
{
	
	HGLOBAL		hGlobal = NULL;
	int			nSize   = 0;
	

	// si l'image existe deja, on la libere
	if(this->image != NULL) 
	{
		this->image->Release () ;
		this->image = NULL ;
	}


	// chargement de la nouvelle image
	hGlobal = Ressource::chargerResource (id, type, &nSize) ;	
	if(!this->chargerBuffer((BYTE*)hGlobal, nSize))
	{
		throw (Exception (CString("Impossible de charger l'image"))) ;
	}
	Ressource::libererResource (hGlobal) ;	
		
}

// affiche l'image sur le CDC a la position (x,y)
// leve une Exception en cas d'erreur d'affichage
void Image::afficher (CDC * dc, int x /*= 0*/, int y /*= 0*/) throw (Exception)
{
	
	CSize taille = this->getSize (dc) ;

	/*long largeur ;
	long hauteur ;
	
	this->image->get_Width(&largeur);
	this->image->get_Height(&hauteur);
	
	int l = MulDiv(largeur,	dc->GetDeviceCaps(LOGPIXELSX), HIMETRIC_INCH);
	int h = MulDiv(hauteur,	dc->GetDeviceCaps(LOGPIXELSY), HIMETRIC_INCH);*/
	
	this->afficher(dc,CRect(0, 0, taille.cx, taille.cy), x, y);
	
}

// affiche l'image sur le CDC a la position (x,y)
// et au dimensions cx, cy
// leve une Exception en cas d'erreur d'affichage
void Image::afficher (CDC * dc, int x, int y, int cx, int cy) throw (Exception)
{
	
	CSize taille = this->getSize (dc) ;
/*	long largeur, hauteur ;		// largeur et hauteur de l'image
	this->image->get_Width(&largeur);
	this->image->get_Height(&hauteur);

	int l = MulDiv(largeur,	dc->GetDeviceCaps(LOGPIXELSX), HIMETRIC_INCH);
	int h = MulDiv(hauteur,	dc->GetDeviceCaps(LOGPIXELSY), HIMETRIC_INCH);*/

	this->afficher (dc, CRect(0, 0, taille.cx, taille.cy), x, y, cx, cy) ;
	
/*	if (!this->rect)	this->rect = new CRect () ;
	this->rect->left = x ;
	this->rect->right = x + cx ;
	this->rect->top = y ;
	this->rect->bottom = y + cy ;
	
	if (this->image->Render(dc->m_hDC, x, y, cx, cy, 0, hauteur, largeur, -hauteur, NULL) != S_OK)
	{
		throw (Exception ("Impossible d'afficher l'image")) ;
	}*/
}

// charge le buffer de taille size octets
bool Image::chargerBuffer (BYTE * buffer, int size)
{	
	bool retour = false ;
	HGLOBAL hGlobal = GlobalAlloc(GMEM_MOVEABLE, size);
	void* pData = GlobalLock(hGlobal);
	memcpy(pData, buffer, size);
	GlobalUnlock(hGlobal);
	
	IStream* pStream = NULL;
	
	if (CreateStreamOnHGlobal(hGlobal, TRUE, &pStream) == S_OK)
	{
		HRESULT hr;
		if ((hr = OleLoadPicture(pStream, size, FALSE, IID_IPicture, (LPVOID *)&this->image)) == S_OK)
		{
			retour = true ;
		}
		
		pStream->Release();
	}
	return (retour) ;
}


// retourne la taille de l'image
CPoint Image::getSize (CDC * dc)
{
	long largeur ;
	long hauteur ;
	
	this->image->get_Width(&largeur);
	this->image->get_Height(&hauteur);
	
	int l = MulDiv(largeur,	dc->GetDeviceCaps(LOGPIXELSX), HIMETRIC_INCH);
	int h = MulDiv(hauteur,	dc->GetDeviceCaps(LOGPIXELSY), HIMETRIC_INCH);
	
	return (CPoint (l, h)) ;
}

// retourne la derniere position et taille de l'image
// retourne NULL si elle n'a pas encore ete affiche
CRect * Image::getRectIm () {
	return (this->rect) ;
}

// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL Image::OnLButtonDown (CPoint pSouris) {
	return (this->inRect (pSouris)) ;
}


// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL Image::OnLButtonUp (CPoint pSouris) {
	return (this->inRect (pSouris)) ;
}

/*virtual*/ BOOL Image::OnRButtonUp (CPoint pSouris) {
	return (this->inRect (pSouris)) ;
}


// indique a l'image que l'utilisateur a boug la souris
// retourne TRUE si la souris se trouve sur l'image
/*virtual*/ BOOL Image::OnMouseMove (CPoint pSouris)
{
	return (this->inRect (pSouris)) ;
}

// indique a l'image que l'utilisateur a double-clique a cette position
// retourne TRUE si la souris se trouve sur l'image
/*virtual*/ BOOL Image::OnLButtonDblClk (CPoint pSouris)
{
	return (this->inRect (pSouris)) ;
}


// retourne vrai si le point est dans cette image
BOOL Image::inRect (CPoint point)
{
	if (!this->rect || !INP(point,*this->rect))
	{
		return FALSE ;
	}
	return (TRUE) ;
}

// affiche le morceau d'image contenu dans rect
/*virtual*/ void Image::afficher (CDC * dc, CRect src, int x, int y, int cx, int cy) throw (Exception)
{
	if (!this->image)
	{
		throw (Exception ("L'image n'a pas ete ouverte")) ;
	}

	if (cx <= 0)		cx = 1 ;
	if (cy <= 0)		cy = 1 ;

	if (!this->rect)	this->rect = new CRect () ;
	this->rect->left = x ;
	this->rect->right = x + cx ;
	this->rect->top = y ;
	this->rect->bottom = y + cy ;

	CSize s = this->getSize (dc) ;

	CRect r  ;
	r.left = MulDiv (src.left, HIMETRIC_INCH, dc->GetDeviceCaps(LOGPIXELSX)) ;
	r.right = MulDiv (src.right, HIMETRIC_INCH, dc->GetDeviceCaps(LOGPIXELSX)) ;
	r.top = MulDiv (s.cy - src.top, HIMETRIC_INCH, dc->GetDeviceCaps(LOGPIXELSY)) ;
	r.bottom = MulDiv (s.cy - src.bottom, HIMETRIC_INCH, dc->GetDeviceCaps(LOGPIXELSY)) ;
	
	HRESULT retour = this->image->Render(dc->m_hDC, x, y, cx, cy, r.left, r.top , r.Width(), r.Height(), NULL) ;
	if (retour != S_OK)
	{
		CString erreur = "Impossible d'afficher l'image : " ;
		switch (retour)
		{
		case E_FAIL:		erreur += "E_FAIL" ;break;
		case E_INVALIDARG:	erreur += "E_INVALIDARG"; break;
		case E_OUTOFMEMORY: erreur += "E_OUTOFMEMORY" ; break ;
		case E_POINTER:		erreur += "E_POINTER" ; break ;
		default:			erreur += "Erreur inconnue" ; break;
		}
		throw (Exception (CString (erreur))) ;
	}
}

/*virtual*/ void Image::afficher (CDC * dc, CRect src, int x, int y) throw (Exception)
{
	this->afficher (dc, src, x, y, src.Width(), src.Height()) ;
}

CRect Image::getCoord (UINT pos, Partie * liste, UINT fin)
{
	CRect retour ;
	int i = 0 ;
	while (liste[i].pos != fin && liste[i].pos != pos)	i++;

	if (liste[i].pos != fin)
	{
		retour = liste[i].coordonnees ;
	}

	return (retour) ;

}