//this file is part of ETBuddies
//Copyright (C)2004-2005 Jos ( josb_31@hotmail.com / http://www.etbuddies.tk )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// FindServersDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "FindServersDlg.h"
#include "Server.h" 
#include <map>
#include <set>
#include <vector>
#include "Filter.h"
#include "AddRelationDlg.h"

using namespace std ;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif









/////////////////////////////////////////////////////////////////////////////
// FindServersDlg dialog



FindServersDlg::FindServersDlg(CWnd* pParent /*=NULL*/)
	: CDialog(FindServersDlg::IDD, pParent)
{
	m_pMaster = NULL ;
	m_edit = false ;
	m_filtres = NULL ;
	//{{AFX_DATA_INIT(FindServersDlg)
	//}}AFX_DATA_INIT
}


void FindServersDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(FindServersDlg)
	DDX_Control(pDX, IDC_CHECK_VERSION, m_checkVersion);
	DDX_Control(pDX, IDC_CHECK_MOD, m_checkMod);
	DDX_Control(pDX, IDC_CHECK_MAP, m_checkMap);
	DDX_Control(pDX, IDC_CHECK_GT, m_checkGT);
	DDX_Control(pDX, IDC_CHECK_COUNTRY, m_checkCountry);
	DDX_Control(pDX, IDC_COUNTRY, m_country);
	DDX_Control(pDX, IDC_MAX_XP, m_maxXp);
	DDX_Control(pDX, IDC_MIN_XP, m_minXp);
	DDX_Control(pDX, IDC_PARAMS, m_params);
	DDX_Control(pDX, IDC_MOD, m_mod);
	DDX_Control(pDX, IDC_SERVER_NAME, m_serverName);
	DDX_Control(pDX, IDC_VERSION, m_version);
	DDX_Control(pDX, IDC_MIN_PING, m_minPing);
	DDX_Control(pDX, IDC_MAX_PING, m_maxPing);
	DDX_Control(pDX, IDC_MAP, m_map);
	DDX_Control(pDX, IDC_GAME_TYPE, m_gameType);
	DDX_Control(pDX, IDC_FILTER_NAME, m_filterName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(FindServersDlg, CDialog)
	//{{AFX_MSG_MAP(FindServersDlg)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	ON_BN_CLICKED(IDC_CHECK_MAP, OnCheckMap)
	ON_BN_CLICKED(IDC_CHECK_GT, OnCheckGt)
	ON_BN_CLICKED(IDC_CHECK_MOD, OnCheckMod)
	ON_BN_CLICKED(IDC_CHECK_VERSION, OnCheckVersion)
	ON_BN_CLICKED(IDC_CHECK_COUNTRY, OnCheckCountry)
	ON_CBN_SELCHANGE(IDC_MAP, OnSelchangeMap)
	ON_CBN_SELCHANGE(IDC_GAME_TYPE, OnSelchangeGameType)
	ON_CBN_SELCHANGE(IDC_COUNTRY, OnSelchangeCountry)
	ON_CBN_SELCHANGE(IDC_MOD, OnSelchangeMod)
	ON_CBN_SELCHANGE(IDC_VERSION, OnSelchangeVersion)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// FindServersDlg message handlers

BOOL FindServersDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	initDialog() ;
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void FindServersDlg::setMaster(ClientMaster * maitre) {
	m_pMaster = maitre ;
}


void FindServersDlg::initDialog() {
	if (m_pMaster != NULL) 
	{
		CString nomFiltre ;

		int num = 1 ;
		
		if (m_filtres != NULL) 
		{	
			do {
				nomFiltre.Format("Filter #%d", num) ;
				num++ ;
			}
			while (m_filtres->getFilters()->getFilter(nomFiltre) != NULL) ;
		}
		
		m_filterName.SetWindowText(nomFiltre) ;
		m_serverName.SetWindowText("") ;

		
		m_version.initVersions() ;
		m_gameType.init() ;
		
		m_map.initMap(m_pMaster) ;
		m_mod.initMod(m_pMaster) ;
		m_params.initList(m_pMaster) ;

		m_minPing.SetWindowText("0") ;
		m_maxPing.SetWindowText("999") ;

		m_minXp.SetWindowText("-1") ;
		m_maxXp.SetWindowText("-1") ;

		m_country.init() ;

	/*	m_map.EnableWindow(m_checkMap.GetCheck()) ;
		m_gameType.EnableWindow(m_checkGT.GetCheck()) ;
		m_mod.EnableWindow(m_checkMod.GetCheck()) ;
		m_version.EnableWindow(m_checkVersion.GetCheck()) ;
		m_country.EnableWindow(m_checkCountry.GetCheck()) ;*/

		if (m_edit)		update() ;
		
	}
}

void FindServersDlg::OnAdd() 
{
	// TODO: Add your control notification handler code here
	AddRelationDlg dlg ;
	dlg.setMaster(m_pMaster) ;
	if (dlg.DoModal() == IDOK) {
		m_params.addRelation(dlg.getRelation()) ;
		m_params.update() ;
	}
}

void FindServersDlg::OnRemove() 
{
	// TODO: Add your control notification handler code here

	POSITION pos = m_params.GetFirstSelectedItemPosition();
	
	while (pos)
	{
		int nItem = m_params.GetNextSelectedItem(pos);
		m_params.removeRelation(nItem) ;
	}
	m_params.update() ;
	
}


Filter FindServersDlg::getFilter() {
	return (toAdd) ;
}

void FindServersDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	toAdd.m_gameType = m_gameType.getType() ;
	m_filterName.GetWindowText(toAdd.m_nom) ;
	m_serverName.GetWindowText(toAdd.m_nomServeur) ;
	toAdd.m_relations = m_params.getListe().copie() ;
	toAdd.m_version = m_version.getVersion() ;
	toAdd.m_nomMap = m_map.getMap() ;
	toAdd.m_mod = m_mod.getMod() ;
	toAdd.m_minPing = GetDlgItemInt(IDC_MIN_PING,	NULL, FALSE) ;
	toAdd.m_maxPing = GetDlgItemInt(IDC_MAX_PING,	NULL, FALSE) ;
	toAdd.m_minXp = GetDlgItemInt(IDC_MIN_XP,		NULL, TRUE) ;
	toAdd.m_maxXp = GetDlgItemInt(IDC_MAX_XP,		NULL, TRUE) ;
	toAdd.m_country = m_country.getSel() ? m_country.getSel()->cntry : "" ;

	toAdd.m_enabledFilters.enableCountry = m_checkCountry.GetCheck() ;
	toAdd.m_enabledFilters.enableNomMap = m_checkMap.GetCheck() ;
	toAdd.m_enabledFilters.enableNomMod = m_checkMod.GetCheck() ;
	toAdd.m_enabledFilters.enableVersion = m_checkVersion.GetCheck() ;
	toAdd.m_enabledFilters.enableGameType = m_checkGT.GetCheck() ;


	if (!m_edit) {
		try {
			m_filtres->getFilters()->addFilter(toAdd) ;
			m_filtres->update() ;
			
		}
		catch (Exception e) {
			MessageBox(e.getMessage(), "Can't add the filter", MB_OK | MB_ICONERROR) ;
			return;
			//f.m_relations.removeAll() ;
		}
	}

	CDialog::OnOK();

	
}

void FindServersDlg::update() {
	m_filterName.SetWindowText(toAdd.m_nom) ;
	m_serverName.SetWindowText(toAdd.m_nomServeur) ;
	m_version.setVersion(toAdd.m_version) ;
	m_map.setMap(toAdd.m_nomMap) ;
	m_mod.setMod(toAdd.m_mod) ;
	m_gameType.setType(toAdd.m_gameType) ;
	m_country.setSel(toAdd.m_country) ;
	SetDlgItemInt(IDC_MIN_PING, toAdd.m_minPing,	FALSE) ;
	SetDlgItemInt(IDC_MAX_PING, toAdd.m_maxPing,	FALSE) ;
	SetDlgItemInt(IDC_MIN_XP,	toAdd.m_minXp,		TRUE) ;
	SetDlgItemInt(IDC_MAX_XP,	toAdd.m_maxXp,		TRUE) ;

	m_checkMap.SetCheck(toAdd.m_enabledFilters.enableNomMap) ;
	m_checkMod.SetCheck(toAdd.m_enabledFilters.enableNomMod) ;
	m_checkVersion.SetCheck(toAdd.m_enabledFilters.enableVersion) ;
	m_checkGT.SetCheck(toAdd.m_enabledFilters.enableGameType) ;
	m_checkCountry.SetCheck(toAdd.m_enabledFilters.enableCountry) ;

	
	
	Relations rel = toAdd.m_relations.getRelations() ;
	Relations::iterator i ;
	for (i = rel.begin() ; i != rel.end() ; i++) {
		m_params.addRelation(*i) ;
	}
	m_params.update() ;
}


void FindServersDlg::initFiltre(Filter f) {
	toAdd = f ;
}

int FindServersDlg::DoModal(FilterListBox * filters, bool edit) 
{
	// TODO: Add your specialized code here and/or call the base class
	m_edit = edit ;
	m_filtres = filters ;
	return CDialog::DoModal();
}

void FindServersDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	if (!m_edit) {
		toAdd.m_relations.removeAll() ;
	}
	CDialog::OnCancel();
}



void FindServersDlg::OnCheckMap() {
//	m_map.EnableWindow(m_checkMap.GetCheck()) ;
	m_map.SetCurSel(m_checkMap.GetCheck() ? 0 : -1) ;
}

void FindServersDlg::OnCheckGt() {
//	m_gameType.EnableWindow(m_checkGT.GetCheck()) ;
	m_gameType.SetCurSel(m_checkGT.GetCheck() ? 0 : -1) ;
}

void FindServersDlg::OnCheckMod() {
//	m_mod.EnableWindow(m_checkMod.GetCheck()) ;
	m_mod.SetCurSel(m_checkMod.GetCheck() ? 0 : -1) ;
}

void FindServersDlg::OnCheckVersion() {
//	m_version.EnableWindow(m_checkVersion.GetCheck()) ;
	m_version.SetCurSel(m_checkVersion.GetCheck() ? 0 : -1) ;
}

void FindServersDlg::OnCheckCountry() {
//	m_country.EnableWindow(m_checkCountry.GetCheck()) ;
	m_country.SetCurSel(m_checkCountry.GetCheck() ? 0 : -1) ;
}

void FindServersDlg::OnSelchangeMap() {
	int sel = m_map.GetCurSel() ;
	m_checkMap.SetCheck(sel != -1) ;
}

void FindServersDlg::OnSelchangeGameType() {
	int sel = m_gameType.GetCurSel() ;
	m_checkGT.SetCheck(sel != -1) ;
	
}

void FindServersDlg::OnSelchangeCountry() 
{
	int sel = m_country.GetCurSel() ;
	m_checkCountry.SetCheck(sel != -1) ;
}

void FindServersDlg::OnSelchangeMod() 
{
	int sel = m_mod.GetCurSel() ;
	m_checkMod.SetCheck(sel != -1) ;
}

void FindServersDlg::OnSelchangeVersion() 
{
	int sel = m_version.GetCurSel() ;
	m_checkVersion.SetCheck(sel != -1) ;
}
