#if !defined(AFX_FILTERLISTCTRL_H__68142C91_5E2F_4BA4_B7F2_017064F78A1B__INCLUDED_)
#define AFX_FILTERLISTCTRL_H__68142C91_5E2F_4BA4_B7F2_017064F78A1B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// FilterListCtrl.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// FilterListCtrl window
#include "ListCtrl.h"
#include <vector>
#include "ClientMaster.h"
#include "Fichier.h"

using namespace std ;



class Relation {
	CString m_param ;
	int m_type ;
	CString m_value ;
	
public:
	Relation(CString param, int type, CString value) 
		: m_param(param), m_type(type), m_value(value) 
	{
	}
	Relation() : m_param(""), m_type(0), m_value("")  {
	}

	Relation(Relation & autre)  : m_param(autre.m_param), m_type(autre.m_type), m_value(autre.m_value)
	{

	}
	
	CString getParam() {
		return (m_param);
	}
	
	char getType() {
		if (m_type < 0)			return ('<') ;
		else if (m_type == 0)	return ('=') ;
		else					return ('>') ;
	}

	int getIType() {
		return (m_type) ;
	}
	
	CString getValue() {
		return (m_value) ;
	}

	void saveRelation(Fichier * f) throw (Exception) {
		f->WriteString ("Relation") ;
		f->WriteString(m_param) ;
		f->Write(&m_type, 1, sizeof(m_type)) ;
		f->WriteString(m_value) ;
	}

	Relation * loadRelation (Fichier * f) throw (Exception) {
		CString verif = f->ReadString() ;
		if (verif.Compare("Relation") != 0) {
			THROW_E("Filter file corrupted!") ;
		}	


		m_param = f->ReadString() ;
		f->Read(&m_type, 1, sizeof(m_type)) ;
		m_value = f->ReadString() ;

		return (this) ;
	}



};

typedef vector<Relation*> Relations ;


class ListeRelations {
	
private:
	Relations m_relations ;
public:
	ListeRelations() {}
	/*~ListeRelations() {
		removeAll() ;
	}*/
	void addRelation(Relation * r) {
		m_relations.push_back(r) ;
	}

	void removeRelation(Relation * r) {
		Relations::iterator i ;
		bool trouve = false ;
		

		for (i = m_relations.begin() ; !trouve && i != m_relations.end() ; i++) 
		{
			if ((*i) == r) {
				m_relations.erase(i) ;
				trouve = true ;
			}

			if (trouve)		delete(r) ;
		}

	}

	void removeAll() {
		EFFACER_LISTE(Relation, m_relations);
	}

	Relations getRelations() {
		return (m_relations) ;
	}

	ListeRelations copie() {
		Relations::iterator i ;
		ListeRelations retour ;

		for (i = m_relations.begin() ; i != m_relations.end() ; i++) {
			retour.addRelation(new Relation(**i)) ;
		}

		return (retour) ;
	}
};



class FilterListCtrl : public ListCtrl
{
private:
	ClientMaster * m_pMaster ;
	ListeRelations m_relations ;
// Construction
public:
	FilterListCtrl();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(FilterListCtrl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~FilterListCtrl();
	void initList(ClientMaster * master) ;
	void addRelation (Relation * r) ;
	void removeRelation(int index) ;
	void update() ;
	ListeRelations getListe() {return(m_relations);}


	// Generated message map functions
protected:
	//{{AFX_MSG(FilterListCtrl)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FILTERLISTCTRL_H__68142C91_5E2F_4BA4_B7F2_017064F78A1B__INCLUDED_)
