//this file is part of ETBuddies
//Copyright (C)2004-2005 Jos ( josb_31@hotmail.com / http://www.etbuddies.tk )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// FilterListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "FilterListCtrl.h"
#include "Filter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif




/////////////////////////////////////////////////////////////////////////////
// FilterListCtrl

FilterListCtrl::FilterListCtrl()
{
}

FilterListCtrl::~FilterListCtrl()
{
//	m_relations.removeAll() ;
}


BEGIN_MESSAGE_MAP(FilterListCtrl, ListCtrl)
	//{{AFX_MSG_MAP(FilterListCtrl)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// FilterListCtrl message handlers
void FilterListCtrl::initList(ClientMaster * master) {

	initControl() ;
	m_pMaster = master ;
	InsertColumn(0, "Param",	LVCFMT_LEFT, 110) ;
	InsertColumn(1, "Relation",	LVCFMT_LEFT, 25) ;
	InsertColumn(2, "Value",	LVCFMT_LEFT, 110) ;


}

void FilterListCtrl::addRelation(Relation * r) {
	m_relations.addRelation(r) ;
	
}

void FilterListCtrl::removeRelation(int index) {
	m_relations.removeRelation((Relation*)GetItemData(index)) ;
}

void FilterListCtrl::update() {
	DeleteAllItems() ;
	Relations rel = m_relations.getRelations() ;
	Relations::iterator i ;

	for (i = rel.begin() ; i != rel.end() ; i++) {
		int index = GetItemCount() ;

		InsertItem(index,		(*i)->getParam()) ;
		SetItemText(index, 1,	CString((*i)->getType())) ;
		SetItemText(index, 2,	(*i)->getValue()) ;
		SetItemData(index, (DWORD)*i) ;
	}
}