#if !defined(AFX_FILTERLISTBOX_H__960B8542_CCDF_4655_AC90_79B6FC65425F__INCLUDED_)
#define AFX_FILTERLISTBOX_H__960B8542_CCDF_4655_AC90_79B6FC65425F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// FilterListBox.h : header file

#include "Filter.h"
#include <vector>

using namespace std ;
//

typedef vector<Filter> ListeFiltres ;
class FilterList {
	ListeFiltres m_filtres ;

public:
	FilterList() {}

	void addFilter(Filter f) throw (Exception) {
		if (getFilter(f.m_nom) != NULL) {
			THROW_E("A filter with that name allready exists") ;
		}
		m_filtres.push_back(f) ;
	}

	void removeFilter(CString nom) {
		ListeFiltres::iterator i ;
		bool trouve = false ; 

		for (i = m_filtres.begin() ; !trouve && i != m_filtres.end() ; i++) {
			if (i->m_nom.CompareNoCase(nom) == 0) {
				trouve = true ;
				i->m_relations.removeAll() ;
				m_filtres.erase(i) ;
			}
		}
	}

	Filter * getFilter (CString nom) {
		ListeFiltres::iterator i ;
		Filter * retour = NULL ;
		

		for (i = m_filtres.begin() ; i != m_filtres.end() ; i++) {
			if (i->m_nom.CompareNoCase(nom) == 0) {
				retour = i ;
			}
		}

		return (retour) ;
	}

	void modifyFilter (CString nom, Filter nouveau) throw(Exception) {
		Filter * f = getFilter(nom) ;
		if (f == NULL)			addFilter(nouveau) ;
		else {
			if (nouveau.m_nom.CompareNoCase(nom) != 0 && getFilter(nouveau.m_nom) != NULL) {
				THROW_E("A filter with that name allready exists") ;
			}
			
			f->init(nouveau) ;
		}

	}

	ListeFiltres * getAll() {
		return (&m_filtres) ;
	}

	void removeAll() {
		ListeFiltres::iterator i ;
		for (i = m_filtres.begin() ; i != m_filtres.end() ; i++) {
			i->m_relations.removeAll() ;
		}
		m_filtres.clear() ;
	}

	void saveFiltres(Fichier * f) throw (Exception) {
		f->WriteString("Filters") ;

		int nb = m_filtres.size() ;
		f->Write(&nb, 1, sizeof(nb)) ;


		ListeFiltres::iterator i ;
		for (i = m_filtres.begin() ; i != m_filtres.end() ; i++) {
			i->saveFilter(f) ;
		}
	}

	void loadFiltres(Fichier * f) throw (Exception) {
		CString verif = f->ReadString() ;
		if (verif.Compare("Filters") != 0) {
			THROW_E("Filter file corrupted!") ;
		}	

		int nb = 0 ;
		f->Read(&nb, 1, sizeof(nb)) ;


		for (int i = 0 ; i < nb ; i++) {
			Filter fil ;
			fil.loadFilter(f) ;
			addFilter(fil) ;
		}
	}

} ;

/////////////////////////////////////////////////////////////////////////////
// FilterListBox window

class FilterListBox : public CCheckListBox
{
	FilterList m_filtres ;

	void save() ;
// Construction
public:
	FilterListBox();
	void update() ;

// Attributes
public:

// Operations
public:
	FilterList * getFilters() {return (&m_filtres);}
	void OnCheckchange() ;
	void removeSelection() ;
	void clear() ;
	Filter * getSelection(int start = 0) ;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(FilterListBox)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~FilterListBox();

	// Generated message map functions
protected:
	//{{AFX_MSG(FilterListBox)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FILTERLISTBOX_H__960B8542_CCDF_4655_AC90_79B6FC65425F__INCLUDED_)
