//this file is part of ETBuddies
//Copyright (C)2004-2005 Jos ( josb_31@hotmail.com / http://www.etbuddies.tk )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// FilterListBox.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "FilterListBox.h"
#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static char filters[] = "Filters.dat" ;

/////////////////////////////////////////////////////////////////////////////
// FilterListBox

FilterListBox::FilterListBox()
{
	try {
		Fichier f(filters) ;
		m_filtres.loadFiltres(&f) ;
	} 
	catch (Exception e) {}
}

FilterListBox::~FilterListBox()
{
	
	save() ;
	m_filtres.removeAll() ;

}


BEGIN_MESSAGE_MAP(FilterListBox, CCheckListBox)
	//{{AFX_MSG_MAP(FilterListBox)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// FilterListBox message handlers
void FilterListBox::update() {
	ResetContent() ;

	ListeFiltres * filtres = m_filtres.getAll() ;
	ListeFiltres::iterator i ;

	for (i = filtres->begin() ; i != filtres->end() ; i++) {
		int index = AddString(i->m_nom) ;
		if (index != LB_ERR) {
			SetCheck(index, i->m_enabled) ;
		}
	}

	save() ;
}


void FilterListBox::OnCheckchange() {
	int nbFiltres = GetCount() ;

	for (int i = 0 ; i < nbFiltres ; i++) {
		CString nom ;
		GetText(i, nom) ;
		Filter * f = m_filtres.getFilter(nom) ;

		if (f != NULL)		f->m_enabled = GetCheck(i) > 0 ;
	}

	update() ;
	
}

void FilterListBox::save() {
	try {
		Fichier f(filters, Fichier::MODE_WRITE | Fichier::TYPE_BINARY) ;
		m_filtres.saveFiltres(&f) ;
	} 
	CATCH_LOG
}


void FilterListBox::removeSelection() {
	int nbSelections = GetSelCount() ;
	int * indexSel = new int[nbSelections] ;
	GetSelItems(nbSelections, indexSel) ;
	
	for (int i = 0 ; i < nbSelections ; i++) {
		CString nom ;
		GetText(indexSel[i], nom) ;
		m_filtres.removeFilter(nom) ;
	}
	update() ;

	delete (indexSel) ;
	
}

void FilterListBox::clear() {
	m_filtres.removeAll() ;
	update() ;
}

Filter * FilterListBox::getSelection(int start /*= 0*/) {
	int nbSelections = GetSelCount() ;
	int * indexSel = new int[nbSelections] ;
	GetSelItems(nbSelections, indexSel) ;
	Filter * retour ;
	bool trouve = false ;
	
	for (int i = 0 ; !trouve && i < nbSelections ; i++) {
		CString nom ;
		GetText(indexSel[i], nom) ;
		if (i >= start)	{
			retour = m_filtres.getFilter(nom) ;
			trouve = true ;
		}
	}

	delete [] indexSel ;

	return (retour) ;
}