// Filter.h: interface for the Filter class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FILTER_H__A6EE7CE6_8802_41DF_880A_CE8FC02A4658__INCLUDED_)
#define AFX_FILTER_H__A6EE7CE6_8802_41DF_880A_CE8FC02A4658__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "FilterListCtrl.h"
#include "Server.h"

struct State {
	BYTE version:3 ;
	BYTE enableNomMap:1 ;
	BYTE enableNomMod:1 ;
	BYTE enableVersion:1 ;
	BYTE enableGameType:1 ;
	BYTE enableCountry:1 ;
	BYTE reserved2[3] ;
} ;

class Filter  
{
public:
	Filter();
	virtual ~Filter();

	CString		m_nom ;
	CString		m_nomServeur ;
	CString		m_nomMap ;
	UINT		m_minPing ;
	UINT		m_maxPing ;
	int			m_minXp ;
	int			m_maxXp ;
	CString		m_mod ;
	CString		m_version ;
	UINT		m_gameType ;
	bool		m_enabled ;
	State		m_enabledFilters ;
	CString		m_country ;

	/* Reserved for future use */
	int		m_reserved[15] ;
	CString	m_sreserved[15] ;
	

	ListeRelations m_relations ;
	bool matchFiltre (Server * serveur) ;

	void init(Filter f) ;

	void saveFilter(Fichier * f) throw (Exception) ;
	void loadFilter(Fichier * f) throw (Exception) ; 

//	void operator=(Filter & autre) ;

};

#endif // !defined(AFX_FILTER_H__A6EE7CE6_8802_41DF_880A_CE8FC02A4658__INCLUDED_)
