// Filter.cpp: implementation of the Filter class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "Filter.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#include "TexteColore.h"

Filter::Filter()
{
	m_enabled = true ;
	m_gameType = -1 ;
	m_minPing = 0 ;
	m_maxPing = 999 ;
	m_minXp = -1 ;
	m_maxXp = -1 ;
	memset(m_reserved, 0, sizeof(m_reserved)) ;
	memset(&m_enabledFilters, 0, sizeof(m_enabledFilters)) ;
	m_enabledFilters.version = 1 ;
}

Filter::~Filter()
{

}

bool Filter::matchFiltre (Server * serveur) {
	bool retour = true ;

	if (m_enabled) {
		if (serveur->getPing() < m_minPing || serveur->getPing() > m_maxPing) {
			retour = false ;
		}
		else if (m_nomServeur.Compare("") != 0) {
			CString nomServ = serveur->getNom() ;
			CString nomServ2 = m_nomServeur ;
			nomServ.MakeLower() ;
			nomServ2.MakeLower() ;
			if (nomServ.Find(nomServ2) == -1) {
				retour = false ;
			}
		}
		else if (m_enabledFilters.enableGameType && serveur->getIntVariable("g_gametype") != m_gameType) {
			retour = false ;
		}
		else if (m_enabledFilters.enableNomMod && serveur->getVariable("gamename").CompareNoCase(m_mod) != 0) {
			retour = false ;
		}
		else if (m_enabledFilters.enableVersion && serveur->getVariable("protocol").Compare(m_version) != 0) {
			retour = false ;
		}
		else if (m_enabledFilters.enableNomMap && serveur->getVariable("mapname").CompareNoCase(m_nomMap) != 0) {
			retour = false ;
		}
		else if (m_enabledFilters.enableCountry && (serveur->getCountry() && serveur->getCountry()->cntry != m_country) || !serveur->getCountry()) {
			retour = false ;
		}
		else if (m_minXp >= 0 && serveur->getXpSum() < m_minXp) {
			retour = false ;
		}
		else if (m_maxXp >= 0 && serveur->getXpSum() > m_maxXp) {
			retour = false ;
		}
		else {
			Relations liste = m_relations.getRelations() ;
			Relations::iterator i ;

			for (i = liste.begin() ; i != liste.end() ; i++) {
				int compare = serveur->getVariable((*i)->getParam()).CompareNoCase((*i)->getValue()) ;

				if (compare < 0 && (*i)->getIType() >= 0)			retour = false ;
				else if (compare == 0 && (*i)->getIType() != 0)	retour = false ;
				else if (compare > 0 && (*i)->getIType() <= 0)		retour = false ;
			}
		}
	}

	return (retour) ;
}

void Filter::init(Filter f) {
	(*this) = f ;
}


void Filter::saveFilter(Fichier * f) throw (Exception) {
	f->WriteString("Filter") ;
	f->Write(&m_enabled, 1, sizeof(m_enabled)) ;
	f->WriteString(m_nom) ;
	f->WriteString(m_nomServeur) ;
	f->Write(&m_gameType, 1, sizeof(m_gameType)) ;
	f->Write(&m_minPing, 1, sizeof(m_minPing)) ;
	f->Write(&m_maxPing, 1, sizeof(m_maxPing)) ;
	f->WriteString(m_mod) ;
	f->WriteString(m_nomMap) ;
	f->WriteString(m_version) ;
	f->Write(&m_minXp, 1, sizeof(m_minXp)) ;
	f->Write(&m_maxXp, 1, sizeof(m_maxXp)) ;
	f->Write(&m_enabledFilters, 1, sizeof(m_enabledFilters)) ;

	for (int j = 0 ; j < TAILLE_LISTE(m_reserved) ; j++) {
		f->Write(&m_reserved[j], 1, sizeof(m_reserved[j])) ;
	}

	f->WriteString(m_country) ;
	for (j = 0 ; j < TAILLE_LISTE(m_sreserved) ; j++) {
		f->WriteString(m_sreserved[j]) ;
	}

	Relations rel = m_relations.getRelations() ;
	Relations::iterator i ;
	int nb = rel.size() ;
	f->Write(&nb, 1, sizeof(nb)) ;
	for (i = rel.begin() ; i != rel.end() ; i++) {
		(*i)->saveRelation(f) ;
	}
	
}

void Filter::loadFilter(Fichier * f) throw (Exception) {

	CString verif = f->ReadString() ;
	if (verif.Compare("Filter") != 0) {
		THROW_E("Filter file corrupted!") ;
	}
	
	f->Read(&m_enabled, 1, sizeof(m_enabled)) ;
	m_nom = f->ReadString() ;
	m_nomServeur = f->ReadString() ;
	f->Read(&m_gameType, 1, sizeof(m_gameType)) ;
	f->Read(&m_minPing, 1, sizeof(m_minPing)) ;
	f->Read(&m_maxPing, 1, sizeof(m_maxPing)) ;
	m_mod = f->ReadString() ;
	m_nomMap = f->ReadString() ;
	m_version = f->ReadString() ;
	f->Read(&m_minXp, 1, sizeof(m_minXp)) ;
	f->Read(&m_maxXp, 1, sizeof(m_maxXp)) ;
	f->Read(&m_enabledFilters, 1, sizeof(m_enabledFilters)) ;

	for (int i = 0 ; i < TAILLE_LISTE(m_reserved) ; i++) {
		f->Read(&m_reserved[i], 1, sizeof(m_reserved[i])) ;
	}

	m_country = f->ReadString() ;
	for (int j = 0 ; j < TAILLE_LISTE(m_sreserved) ; j++) {
		m_sreserved[j] = f->ReadString() ;
	}

	m_relations.removeAll() ;

	int nb = 0 ;
	f->Read(&nb, 1, sizeof(nb)) ;
	for (i = 0 ; i < nb ; i++) {
		Relation * r = new Relation() ;
		r->loadRelation(f) ;
		m_relations.addRelation(r) ;
	}

	/* import old filters */
	if (m_enabledFilters.version == 0) {
		m_enabledFilters.version = 1 ;
		m_enabledFilters.enableNomMod	= m_mod.Compare("") == 0 ? 0 : 1 ; 
		m_enabledFilters.enableNomMap	= m_nomMap.Compare("") == 0 ? 0 : 1 ;
		m_enabledFilters.enableVersion	= m_version.Compare("") == 0 ? 0 : 1 ;
		m_enabledFilters.enableGameType = m_gameType == -1 ? 0 : 1 ;
	}
}
/*
void Filter::operator=(Filter & autre) {
	m_country = autre.m_country ;
	m_enabled = autre.m_enabled ;
	memcpy (&m_enabledFilters, &autre.m_enabledFilters, sizeof(m_enabledFilters)) ;
	m_gameType = autre.m_gameType ;
	m_maxPing = autre.m_maxPing ;
	m_minPing = autre.m_minPing ;
	m_maxXp = autre.m_maxXp ;
	m_minXp = autre.m_minXp ;
	m_mod = autre.m_mod ;
	m_nom = autre.m_nom ;
	m_nomMap = autre.m_nomMap ;
	m_nomServeur = autre.m_nomServeur ;
	m_relations = autre.m_relations ;
	m_version = autre.m_version ;

}*/