//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
//	Fichier	|	Fichier.h													 //
///////////////////////////////////////////////////////////////////////////////
//	Role	|	Cette classe permet d'utiliser des fichiers					 //
///////////////////////////////////////////////////////////////////////////////

#ifndef _FICHIER_H
#define _FICHIER_H

#include "stdexcpt.h"
#include "Exception.h"

class Fichier
{
private:
	FILE * file ;
	bool estOuvert ;
	int mode ;
	CString nom ;

	// verifie que le fichier est ouvert
	// leve une exception s'il n'est pas ouvert
	void verifierOuvert () throw (Exception) ;

public:
	// mode d'acces du fichier
	static int MODE_READ ;
	static int MODE_WRITE ;
	static int MODE_RW ;		// = MODE_READ|MODE_WRITE
	static int MODE_APPEND ;
	static int TYPE_TEXT ;
	static int TYPE_BINARY ;

	// parametres de Seek()
	static int SEEK_BEGIN ;
	static int SEEK_FIN ;
	static int SEEK_CURRENT ;

	// ouvre le fichier de nom nom
	// utilise le mode d'ouverture fourni
	// le mode d'ouverture peut etre un des modes MODE_* et TYPE_*
	Fichier (CString nom, int mode = TYPE_BINARY | MODE_READ) throw (Exception) ;

	~Fichier () ;

	// lit dans le fichier nbElt * tailleElt octets
	// renvoie le nombre d'octets lus
	// leve une exception si le mode d'ouverture n'est pas MODE_READ
	// leve une exception si on est a la fin du fichier
	int Read (void * buffer, int nbElt = 1, int tailleElt = 4) ;

	CString ReadString() ;

	// ecrit dans le fichier nbElt * tailleElt octets de buffer
	// renvoie le nombre d'octets ecrits
	// leve une exception si le mode d'ouverture n'est pas MODE_WRITE
	int Write (void * buffer, int nbElt = 1, int tailleElt = 4) ;

	void WriteString(CString str) ;


	// flush le fichier
	// leve un exception si le flush a echou
	void Flush () throw (exception) ;

	// indique si on est en fin de fichier
	// si la fonction retourne 0, on est en fin de fichier
	int isEof () ;

	// positionne le fichier a la position pos a partir de origine
	// origine peut etre SEEK_BEGIN, SEEK_END, SEEK_CURRENT
	// leve une exception si le Seek a echou
	void Seek (long pos, int origine) throw (Exception) ;

	// retourne la position courante dans le fichier
	// leve une exception en cas d'erreur
	long GetPos () throw (Exception) ;

	// met la position courante a pos
	// leve une exception en cas d'erreur
	void SetPos (fpos_t pos) throw (Exception) ;

	// remet le fichier au debut
	void Rewind () ;

	// ferme le fichier
	void Close () ;

	// renvoie le nom du fichier ouvert
	CString getNom () {return (this->nom);}

	FILE * getFile ()	{return (this->file);}
} ;

#endif