//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "fichier.h"

// mode d'acces du fichier
/*static*/ int Fichier::MODE_READ = 0x01 ;
/*static*/ int Fichier::MODE_WRITE = 0x02 ;
/*static*/ int Fichier::MODE_RW = MODE_READ|MODE_WRITE ;
/*static*/ int Fichier::MODE_APPEND = 0x04|MODE_WRITE ;
/*static*/ int Fichier::TYPE_TEXT = 0x08 ;
/*static*/ int Fichier::TYPE_BINARY = 0x10 ;

// parametres de Seek()
/*static*/ int Fichier::SEEK_BEGIN = 1 ;
/*static*/ int Fichier::SEEK_FIN = 2 ;
/*static*/ int Fichier::SEEK_CURRENT = 3 ;

// ouvre le fichier de nom nom
// utilise le mode d'ouverture fourni
// le mode d'ouverture peut etre un des modes MODE_* et TYPE_*
Fichier::Fichier (CString nom, int mode)
{
	this->estOuvert = false ;

	char mod [5] ;
	memset (mod, 0, sizeof(mod));
	int pos = 1 ;
	if ((mode & MODE_RW) == MODE_RW)
	{
		mod[0] = 'w' ;
		mod[1] = '+' ;
		pos = 2 ;
	}
	else if (mode & MODE_READ)
	{
		mod[0] = 'r' ;
	}
	else if (mode & MODE_WRITE)
	{
		mod[0] = 'w' ;
	}
	else if ((mode & MODE_APPEND) == MODE_APPEND)
	{
		mod[0] = 'a' ;
	}
	else
	{
		mod[0] = 'r' ;
		//throw (exception ("Mode d'ouverture du fichier incorrect")) ;
	}

	if (mode & TYPE_TEXT)
	{
		mod[pos] = 't' ;
	}
	else
	{
		mod[pos] = 'b' ;
	}

	mod[pos+1] = '\0' ;

	this->mode = mode ;
	this->file = fopen (nom.GetBuffer(nom.GetLength()), mod) ;
	nom.ReleaseBuffer() ;

	if (!this->file)
	{
		throw (Exception (CString ("Impossible d'ouvrir le fichier ") + nom)) ;
	}
	this->estOuvert = true ;
	this->nom = nom ;
}

Fichier::~Fichier ()
{
	this->Close() ;
}

void Fichier::Close()
{
	if (this->estOuvert)
	{
		fclose (this->file) ;
		this->estOuvert = false ;
	}
}

// lit dans le fichier nbElt * tailleElt octets
// renvoie le nombre d'octets lus
// leve une exception si le mode d'ouverture n'est pas MODE_READ
// leve une exception si on est a la fin du fichier
int Fichier::Read (void * buffer, int nbElt, int tailleElt)
{
	this->verifierOuvert() ;
	if (!(this->mode & MODE_READ))
	{
		throw (Exception ("Impossible de lire : fichier ouvert en ecriture")) ;
	}
	if (this->isEof())
	{
		throw (Exception ("Impossible de lire apres la fin du fichier")) ;
	}
	return (fread (buffer, tailleElt, nbElt, this->file)) ;
}

CString Fichier::ReadString() {
	int lg = 0 ;
	Read (&lg, 1, sizeof(lg)) ;

	char * buffer = new char[lg] ;
	Read(buffer, 1, lg) ;
	CString retour = buffer ;

	delete [] buffer ;
	return (retour) ;
}

// ecrit dans le fichier nbElt * tailleElt octets de buffer
// renvoie le nombre d'octets ecrits
// leve une exception si le mode d'ouverture n'est pas MODE_WRITE ou MODE_APPEND
int Fichier::Write (void * buffer, int nbElt, int tailleElt)
{
	this->verifierOuvert() ;
	if (!(this->mode & MODE_WRITE))
	{
		throw (Exception ("Impossible d'ecrire : fichier ouvert en lecture")) ;
	}
	return (fwrite (buffer, tailleElt, nbElt, this->file)) ;
}


void Fichier::WriteString(CString str) {
	int lg = str.GetLength() + 1;
	Write (&lg, 1, sizeof(lg)) ;
	Write(str.GetBuffer(lg), 1, lg) ;
}

// flush le fichier
// leve un exception si le flush a echou
void Fichier::Flush () throw (Exception)
{
	this->verifierOuvert() ;
	if (fflush (this->file) != 0)
	{
		throw (Exception ("Erreur lors du flush")) ;
	}
}

// indique si on est en fin de fichier
// si la fonction retourne 0, on est en fin de fichier
int Fichier::isEof ()
{
	this->verifierOuvert() ;
	return (feof(this->file)) ;
}

// positionne le fichier a la position pos a partir de origine
// origine peut etre SEEK_BEGIN, SEEK_FIN, SEEK_CURRENT
// leve une exception si le Seek a echou
void Fichier::Seek (long pos, int origine) throw (Exception)
{
	this->verifierOuvert() ;
	int ori ;
	if (origine == SEEK_BEGIN)
	{
		ori = SEEK_SET ;
	}
	else if (origine == SEEK_FIN)
	{
		ori = SEEK_END ;
	}
	else
	{
		ori = SEEK_CUR ;
	}
	if (fseek (this->file, pos, ori) != 0)
	{
		throw (Exception ("Erreur lors du seek")) ;
	}
}

// retourne la position courante dans le fichier
// leve une exception en cas d'erreur
long Fichier::GetPos () throw (Exception)
{
	this->verifierOuvert() ;
	return (ftell (this->file)) ;
}

// met la position courante a pos
// leve une exception en cas d'erreur
void Fichier::SetPos (fpos_t pos) throw (Exception)
{
	this->verifierOuvert() ;
	if (fsetpos (this->file, &pos) != 0)
	{
		throw (Exception ("Erreur lors du SetPos")) ;
	}	
}

// remet le fichier au debut
void Fichier::Rewind ()
{
	this->verifierOuvert() ;
	rewind (file) ;
}

// verifie que le fichier est ouvert
// leve une exception s'il n'est pas ouvert
void Fichier::verifierOuvert () throw (Exception)
{
	if (!this->estOuvert)
	{
		throw (Exception ("Le fichier n'est pas ouvert")) ;
	}
}