//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Favorites.h: interface for the Favorites class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FAVORITES_H__99E7F154_88D2_4288_967E_0CE32A23FD93__INCLUDED_)
#define AFX_FAVORITES_H__99E7F154_88D2_4288_967E_0CE32A23FD93__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Objet.h"
#include <vector>
#include "Server.h"
#include "ListeBuddies.h"

using namespace std ;

class Favorites : public Objet  
{
private:
	/* list of favorites servers */
	vector<CString> m_favoris ;
	CString m_nomFichier ;
public:

	static CString NOM_CLASSE ;

	Favorites();
	virtual ~Favorites();

	/* add a server to the list */
	void addServer (Server * server) ;
	void addServer (CString ipServer) ;

	/* indicate if this server is in favorites */
	bool isFavorite (Server * server) ;
	bool isFavorite (CString ipServer) ;

	/* return all favorite servers */
	vector<CString> * getFavorites () {return (&this->m_favoris);}

	/* remove this server from list if exist */
	void removeServer (Server * server) ;
	void removeServer (CString ipServer) ;

	/* add all favorites server to server list */
	void updateMaster (ListeBuddies * liste) ;

	virtual void serialize (Fichier * f) throw (Exception) ;
	static Objet * getFromFile (Fichier * f) throw (Exception) ;

	void saveFavorites() throw (Exception) ;
	static Favorites * loadFavorites(CString nomFichier) throw (Exception) ;

	void setNomFichier(CString nomFichier) {m_nomFichier = nomFichier;}

};

#endif // !defined(AFX_FAVORITES_H__99E7F154_88D2_4288_967E_0CE32A23FD93__INCLUDED_)
