//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Favorites.cpp: implementation of the Favorites class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "Favorites.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif




/*static*/ CString Favorites::NOM_CLASSE = "Favorites" ;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Favorites::Favorites() : Objet(NOM_CLASSE) {
}

Favorites::~Favorites()
{

}



/* add a server to the list */
void Favorites::addServer (Server * server)
{
	ASSERT(server) ;
	if (server != NULL) {
		this->addServer (server->getIp()->getIpTotal()) ;
	}
}

void Favorites::addServer (CString ipServer)
{
	if (!isFavorite(ipServer)) {
		this->m_favoris.push_back(ipServer) ;
		try {
			saveFavorites() ;
		}
		catch (Exception e) {}
	}
}

/* indicate if this server is in favorites */
bool Favorites::isFavorite (Server * server)
{
	ASSERT(server);
	return (this->isFavorite(server->getIp()->getIpTotal())) ;
}

bool Favorites::isFavorite (CString ipServer) 
{
	bool trouve = false ;

	FOR_VECTOR_COND(CString,this->m_favoris,!trouve)
	{
		if (strcmp (STR_BUFFER(*i), STR_BUFFER(ipServer)) == 0) {
			trouve = true ;
		}
	}

	return (trouve) ;
}

/* remove this server from list if exist */
void Favorites::removeServer (Server * server) 
{
	ASSERT(server) ;
	if (server) {
		this->removeServer (server->getIp()->getIpTotal()) ;
	}
}

void Favorites::removeServer (CString ipServer)
{
	bool trouve = false ;

	FOR_VECTOR_COND(CString,this->m_favoris,!trouve)
	{
		if ((*i) == ipServer) {
			trouve = true ;
			this->m_favoris.erase (i) ;
			try {
				saveFavorites() ;
			}
			catch (Exception e) {}
		}
	}
}

/*virtual*/ void Favorites::serialize (Fichier * f) throw (Exception)
{
	Objet::serialize(f) ;

	int nbElem = this->m_favoris.size() ;
	/* write number of favorites */
	f->Write (&nbElem, 1, sizeof (int)) ;

	FOR_VECTOR(CString, this->m_favoris)
	{
		/* write every favorites IPs */
		int taille = i->GetLength() + 1 ;
		f->Write (&taille, 1, sizeof(int)) ;
		f->Write (STR_BUFFER((*i)), sizeof(char), taille) ;
		i->ReleaseBuffer() ;
	}

}

/*static*/ Objet * Favorites::getFromFile (Fichier * f) throw (Exception)
{
	// verification de la validite du fichier
	delete (Objet::getFromFile(f, NOM_CLASSE)) ;

	Favorites * retour = new Favorites() ;

	int nbElem = 0 ;
	/* read number of favorites */
	f->Read (&nbElem, 1, sizeof (int)) ;
	if (nbElem < 0)		FICHIER_CORROMPU(f) ;

	CString ip ;
	int taille ;
	char * ipv ;


	/* reads ip adress of every favorite */
	for (int i = 0 ; i < nbElem ; i++) 
	{
		f->Read (&taille, 1, sizeof(int)) ;
		if (taille <= 0)		FICHIER_CORROMPU(f);
		
		// lecture du nom
		ipv = new char [taille] ;
		f->Read (ipv, taille, sizeof (char)) ;
		ip = ipv ;
		delete (ipv) ;

		retour->addServer (ip) ;
	}

	return (retour) ;

}

/* add all favorites server to server list */
void Favorites::updateMaster (ListeBuddies * liste)
{
	vector<CString> * fav = this->getFavorites () ;
	ClientMaster * master = liste->getClientMaitre() ;

	FOR_VECTOR_IND(CString,(*fav),k) {
		master->ajouterServeur (new Server (new Ip(*k), master)) ;
	}
}

void Favorites::saveFavorites() throw (Exception)
{
	if (m_nomFichier != "") {
		Fichier f (m_nomFichier, Fichier::MODE_WRITE) ;
		serialize (&f) ;
	}
}

/*static*/ Favorites * Favorites::loadFavorites(CString nomFichier) throw (Exception)
{
	Favorites * retour ;
	Fichier f (nomFichier, Fichier::MODE_READ) ;
	retour = (Favorites*)Favorites::getFromFile(&f) ;
	retour->setNomFichier(nomFichier) ;

	return (retour) ;
}