//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ETBuddiesDlg.h : header file
//


#if !defined(AFX_ETBUDDIESDLG_H__1E75A6FB_CB91_460B_9365_76E0AEA9A7E3__INCLUDED_)
#define AFX_ETBUDDIESDLG_H__1E75A6FB_CB91_460B_9365_76E0AEA9A7E3__INCLUDED_

#include "ListeBuddies.h"
#include "Observer.h"
#include "Preferences.h"
#include "skin.h"
#include "defines.h"
#include "ClientMasterWolf.h"
#include "log.h"
#include "ToolTip.h"
#include "InfosServeurDlg.h"
#include "MainTreeCtrl.h"
#include "Favorites.h"
#include "ServerListDlg.h"
#include "JoueursDlg.h"
#include "ConnectIpDlg.h"
#include "AddServerDlg.h"
#include "Ip2Country.h"
#include "PasswordFile.h"
#include "StartPrograms.h"


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define NB_ICONES				4

typedef DWORD (WINAPI *PSLWA)(HWND, DWORD, BYTE, DWORD) ;

#define LOG


DECLARE_INTERFACE_(ITaskbarList,IUnknown)
{
STDMETHOD(QueryInterface)(THIS_ REFIID riid,LPVOID* ppvObj) PURE;
STDMETHOD_(ULONG,AddRef)(THIS) PURE;
STDMETHOD_(ULONG,Release)(THIS) PURE;
STDMETHOD(ActiveTab)(HWND) PURE;
STDMETHOD(AddTab)(HWND) PURE;
STDMETHOD(DeleteTab)(HWND) PURE;
STDMETHOD(HrInit)(HWND) PURE;
};
//alias
typedef ITaskbarList *LPITaskbarList;



/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// CETBuddiesDlg dialog

class CETBuddiesDlg : public CResizableDialog, Observer
{
private:
	Ip2Country m_ip2country ;
	ListeBuddies * liste ;

	MainTreeCtrl * listeCtrl ;

//	CString installPath ;

	CBitmap * menu[NB_ICONES] ;
	Ip * m_pTempIp ;

//	CToolTipCtrl * toolTip ;

	// preferences de l'application
	Preferences * pref ;

	CMenu * popup_menu ;			/* menu selection skin */
	CMenu * transparence ;			/* menu selection transparence */
	CMenu * mainMenu ;				/* menu principal */
	CMenu * mainMenuPopup ;			/* menu principal cre en popup */
	CMenu * infoJoueur ;			/* menu donnes complementaires joueurs */
	CMenu m_menuBuddy ;				/* context menu s'affichant sur les buddies */
	CMenu m_defaultMenu ;

	ToolTip * toolTipJoueur ;

	/* Server informations and list of servers dialogs */
	InfosServeurDlg *	m_pInfosDlg ;
	ServerListDlg *		m_pServerDlg ;
	JoueursDlg *		m_pJoueurDlg ;
	AddServerDlg		m_addServer ;

	ConnectIpDlg *		m_pConnectDlg ;

	CFont * font ;


	CString m_strToolTip ;

	LPITaskbarList m_pTaskbar;

#ifdef LOG
	Log * log ;
#endif

	// barre de progression de la recherche
	CProgressCtrl * progresseRech ;


	Skin * skin ;

	bool init ;
	// indique si le skin doit etre affich
	bool afficherSkin ;
	// nombre de skins
	UINT nbSkins ;

	PSLWA pSetLayeredWindowAttributes ;
	BOOL initialized ;

	/* favorites servers */
	Favorites * m_pFavoris ;

	PasswordFile * m_pPasswords ;
	StartPrograms * m_pStartPrograms ;

	/* selected buddy and player */
	Buddie * m_pSelBuddy ;
	Joueur * m_pSelJoueur ;

//	ClientMasterWolf * testConnec ;



	// affiche ou cache les controls
	void afficherControls (bool afficher = true) ;

	void MakeWindowTransparent(BYTE factor = 255) throw (Exception) ;

	void setSkin (int idSkin) throw (Exception) ;
	void setTransparence (BYTE trans) ;

	

	void initTimerRefresh () ;

	// messages envoys par le menu principal
	void OnOptions () ;
	void OnAbout () ;
	void OnConnectIp () ;
	void OnInfosServer() ;

	// met a jour les menus en grisant les choix invalides
	void MAJMenu () ;

	void UpdateToolTips () ;

	void ajouterMenu (UINT nPosition, UINT nFlags, UINT nIDNewItem = 0, LPCTSTR lpszNewItem = NULL) ;

	void UpdateTrayMenu() ;

protected:
	CToolTipCtrl * toolTip ;



// Construction
public:
	CETBuddiesDlg(CWnd* pParent = NULL);	// standard constructor
	~CETBuddiesDlg () ;

	virtual void OnChange (Objet * obj, UINT msg, void * param1, void * param2) ;
	Preferences * getPref () {return (this->pref);}
	ListeBuddies * getListeBud () ;

	void Suppr () ;

	// renvoie le repertoire d'installation de Enemy Territory
//	CString getInstallPath () {return (this->installPath);}

	virtual void OnTrayMouseMove(CPoint pt);


	void OnSuppr() ;
	void OnViewServers() ;


	// connection a ce server
	void connection (Ip * ip) throw (Exception) ;

	Ip2Country * getIp2Country() {return (&m_ip2country);}

	/* return favorites servers */
	Favorites * getFavorites () {return (this->m_pFavoris);}
	PasswordFile * getPasswords() {return (m_pPasswords);}
	StartPrograms * getSoftwares() {return (m_pStartPrograms);}

	/* return info dialog */
	InfosServeurDlg *	getInfosDlg ()	
	{
		if (!this->m_pInfosDlg) {
			this->m_pInfosDlg = new InfosServeurDlg() ;
		}
		return (this->m_pInfosDlg);
	}

	ServerListDlg *		getServerDlg () 
	{
		if (!this->m_pServerDlg) {
			this->m_pServerDlg = new ServerListDlg() ;
		}
		return (this->m_pServerDlg);
	}

	JoueursDlg *			getJoueurDlg () 
	{
		if (!this->m_pJoueurDlg) {
			this->m_pJoueurDlg = new JoueursDlg () ;
		}
		return (this->m_pJoueurDlg) ;
	}

	ConnectIpDlg *			getConnectIpDlg()
	{
		if (!this->m_pConnectDlg) {
			this->m_pConnectDlg = new ConnectIpDlg () ;
		}
		return (this->m_pConnectDlg) ;
	}

	/* Indicate this buddy was selected before showing buddy's context menu */
	void selectBuddy (Buddie * buddy) {m_pSelBuddy = buddy;}
	Buddie * getSelectedBuddy () {return (m_pSelBuddy);}
	

	/* Indicate this player was selected before showing player's context menu */
	void selectPlayer (Joueur * joueur) {m_pSelJoueur = joueur ;}
	Joueur * getSelectedPlayer () {return (m_pSelJoueur);}

	/* Update main dialog in order to make it always on top or not */
	void updateStayOnTop () ;

	virtual BOOL ShowWindow (int nCmdShow) ;

	void OnRestore();
	void OnMinimize();



#ifdef LOG
	Log * getLog ()		{return (this->log);}
#endif

// Dialog Data
	//{{AFX_DATA(CETBuddiesDlg)
	enum { IDD = IDD_ETBUDDIES_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CETBuddiesDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual BOOL OnToolTipNotify(UINT id, NMHDR *pNMH, LRESULT *pResult) ;
	//}}AFX_VIRTUAL


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CETBuddiesDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnAdd();
	virtual void OnOK();
	afx_msg void OnConnect();
	afx_msg void OnRefresh();
	afx_msg void OnDblclkBuddies(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRefreshPartiel();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnStopRefresh();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	virtual void OnCancel();
	afx_msg void OnClose();
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnDestroy();
	afx_msg void OnRclickBuddies(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	afx_msg void OnExit();
	DECLARE_MESSAGE_MAP()
		
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ETBUDDIESDLG_H__1E75A6FB_CB91_460B_9365_76E0AEA9A7E3__INCLUDED_)
