//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ETBuddiesDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ETBuddiesDlg.h"
#include "defines.h"
#include "objet.h"
#include "Atlbase.h"
#include <process.h>
#include "AddBudDlg.h"
#include "Lang.h"
#include "BoutonActualiser.h"
#include "BuddyImage.h"
#include "BoutonAdd.h"
#include "BoutonSub.h"
#include "BoutonExit.h"
#include "Server.h"
#include "ClientSlaveWolf.h"
#include "BoutonOptions.h"
#include "BoutonStopRefresh.h"
#include "BoutonFiles.h"
#include "Options.h"
#include "ServerListDlg.h"
#include "ConnectIpDlg.h"
#include "InfosServeurDlg.h"
#include "ETLink.h"


//#define TEST_DD
//#define TEST_CONNEC
//#define TEST_LISTE_SERV



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif




// taille maximum du path de l'installation
/*#define MAX_INSTALL_PATH		1024
#define ET_EXE					"ET.exe"
#define ET_KEY					"SOFTWARE\\Activision\\Wolfenstein - Enemy Territory"*/
#define	FILE_PREF				"Preferences.ini"
//#define ET_NOT_INSTALLED		"Wolfenstein Enemy Territory isn't installed on this computer!\nWould you like to continue anymore ?"
#define FICHIER_FAVORIS			"Favorites.dat"


//taille minimale de la fenetre
#define TAILLE_MIN_X			180
#define TAILLE_MIN_Y			280

#define TOOLTIPON				"%s\nOnline : %s\n%d XP / Ping : %d ms"				// nom , nomServeur, xp, ping


#define ID_TIMER_REFRESH		1
// nb de minutes avant rafraichissement partiel
#define TEMPS_REFRESH			this->pref->getTempsAttenteRefresh()

/****************************************************************
* Informations concernant l'application							*
*****************************************************************/
#define VERSION					"0.25"
#define VERSION_F				atof(VERSION)

#define JOS_E					"josb_31@hotmail.com"
#define LHAMMER_E				"bertrand.massat@caramail.com"
#define WOUF_E					"ugomail@free.fr"
#define TOOMS_E					"nam_tooms@hotmail.com"
#define POPUL_E					"cpopul@hotmail.com"
#define URL_SITE				"http://www.etbuddies.tk"


/****************************************************************
* Informations le menu contextuel								*
*****************************************************************/
#define NO_SKIN_TEXT			"No skin"
#define NO_SKIN					(WM_USER + 0x01)
#define MAX_SKINS				0xFF
#define NO_TRANSPARENCY			(WM_USER + MAX_SKINS + 1)
#define SKIN_DEFAULT			-1
#define SKIN_MENU				"&Skins"
//#define TRANS_MENU				"&Transparence"

/****************************************************************
* Operations sue les menus										*
*****************************************************************/
#define BASE_MENU_ID			(NO_TRANSPARENCY + 0x10)
#define END_MENU_ID				(ADD_SERVER_ID + 1)
#define IN_MENU(id)				((id) >= BASE_MENU_ID && (id) < END_MENU_ID)



enum {	OPTIONS_MENU_ID = BASE_MENU_ID,
		EXIT_MENU_ID,
		ABOUT_MENU_ID,
		VIEW_SERVERS_ID,
		JOIN_MENU_ID,
		REFRESH_MENU_ID,
		ADD_F_MENU_ID,
		REMOVE_MENU_ID,
		INFO_SERVER_ID,
		ADD_SERVER_ID
} ;


/****************************************************************
* Id des menus contenus dans File								*
*****************************************************************/
#define FILES_MENU				"&File"
#define OPTIONS_MENU			"&Options..."
#define EXIT_MENU				"&Exit"
#define ADD_SERVER_MENU			"&Add a server..."

/****************************************************************
* Id des menus contenus dans ?									*
*****************************************************************/
#define HELP_MENU				"&?"
#define ABOUT_MENU				"&About..."

/****************************************************************
* Id des menus contenus dans View								*
*****************************************************************/
#define VIEW_MENU				"&View"
#define VIEW_SERVERS			"&Server list..."

/****************************************************************
* Id des menus contenus dans action								*
*****************************************************************/
#define ACTION_MENU				"&Action"
#define JOIN_MENU				"&Join this player"
#define REFRESH_MENU			"&Refresh server list"
#define ADD_F_MENU				"&Add a friend..."
#define REMOVE_MENU				"R&emove this friend"
#define CONNECT_MENU			"&Connect to IP..."
#define CONNECT_MENU_ID			ID__CONNECTTOIP/*(BASE_MENU_ID + 8)*/
#define INFO_SERVER				"&Show server"



/****************************************************************
* Id du menu infos joueur										*
*****************************************************************/
/*#define JOIN_PLAYER				"Join this player"
#define JOIN_PLAYER_ID			(BASE_MENU_ID + 9)
#define INFO_SERVER				"Server information"
#define INFO_SERVER_ID			(BASE_MENU_ID + 10)
#define JOUEUR_MENU				"Player"*/



#define FIN		-1

static int icones[NB_ICONES+1][2] = {{IDCANCEL,				IDB_EXIT},
									{IDC_ADD,				IDB_ADD},
									{IDC_REFRESH_PARTIEL,	IDB_REFRESH},
									{IDC_STOP_REFRESH,		IDB_STOP_REFRESH},
									{FIN,					FIN}} ;

static UINT controls[] = {IDC_BUDDIES, IDC_ADD, IDC_STOP_REFRESH, IDCANCEL, IDC_PROGRESS_RECHERCHE, IDC_REFRESH_PARTIEL} ;




/****************************************************************************
* Lance l'executable de Enemy Territory avec comme parametres +connect ip	*
* ipv doit etre de type Ip													*
****************************************************************************/
void lanceET (void * ipv)
{
	if (!ipv)	return ;
	Ip * ip = (Ip*)ipv ;

	// recuperation des path
	//CString install = ((CETBuddiesDlg*)AfxGetMainWnd())->getInstallPath() ;
	//CString et = install + "\\" +  ET_EXE ;
	//CString param = "connect " + ip->getIpTotal() ;

	CString et = MAIN_PREF->getETDirectory() ;

	CString install = ".\\" ;
	if (et != "") 
	{
		int i = et.GetLength() - 1 ;
		while (et[i] != '\\')			i--;
		
		install = et.Mid (0, i) ;
	}


	/* close Info server dialog */
	MAIN_DLG->getInfosDlg()->ShowWindow(SW_HIDE);
	MAIN_DLG->OnMinimize() ;

	SetCurrentDirectory (install) ;
	if (MAIN_DLG->getPref()->getDelETkey()) {
		DeleteFile("etmain\\etkey") ;
	}

	/* get ET args */
	vector<CString> args = MAIN_DLG->getPref()->getETArgsList() ;

	/* setting up args */
	CString ips = ip->getIpTotal() ;
	CString pass = MAIN_DLG->getPasswords()->getPassword(ips) ;
	if (pass != "") {
		args.push_back("+seta") ;
		args.push_back("password") ;
		args.push_back(pass) ;
	}

	
	char ** argv = new char * [args.size() + 4] ;
	argv[0] = STR_BUFFER(et) ;
	argv[1] = "+connect" ;
	argv[2] = STR_BUFFER(ips) ;


	for (int i = 3 ; i < args.size() + 3 ; i++) {
		argv[i] = STR_BUFFER(args[i - 3]) ;
	}
	argv[args.size() + 3] = NULL ;


	spawnv (_P_WAIT, et, argv) ;
	// restoration du CurrentDirectory
	SetCurrentDirectory (MAIN_PREF->getRepInstall());

	::SendMessage (AfxGetMainWnd()->m_hWnd, WM_PAINT, 0, 0) ;
	delete [] argv ;
}



CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}


BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CString ver ;
	CString verUp ;

	GetDlgItemText(IDC_VERSION, ver) ;
	verUp.Format ("%s %s", ver, VERSION) ;
	SetDlgItemText (IDC_VERSION, verUp) ;

	/* Mise en forme des emails et de l'url du site */
	SetDlgItemText (IDC_JOS,		JOS_E) ;
	SetDlgItemText (IDC_LHAMMER,	LHAMMER_E) ;
	SetDlgItemText (IDC_WOUF,		WOUF_E) ;
	SetDlgItemText (IDC_POPUL,		POPUL_E) ;
	SetDlgItemText (IDC_TOOMS,		TOOMS_E) ;
	SetDlgItemText (IDC_SITE,		URL_SITE) ;

	


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CETBuddiesDlg dialog

CETBuddiesDlg::CETBuddiesDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CETBuddiesDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CETBuddiesDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	memset (this->menu,0, sizeof (this->menu)) ;
	Lang::SetLanguage (Lang::LANGID_FR_FR) ;

	init						= false ;
	skin					= NULL ;
	afficherSkin			= false ;
	nbSkins				= 0 ;
	initialized			= FALSE ;
	progresseRech			= new CProgressCtrl() ;
	font					= new CFont() ;
	font->CreateFont (15,0,0,0,400,0,0,0,0,0,0,0,0,"Arial") ;
//	testConnec			= NULL ;
//	qs					= NULL ;
	
	//********************************************************************
	// initialisation diverses
	//********************************************************************
	pref			= new Preferences (FILE_PREF) ;
	popup_menu	= NULL ;
	transparence	= NULL ;
	mainMenu		= NULL ;
	mainMenuPopup = NULL ;
	infoJoueur	= NULL ;
	toolTipJoueur	= new ToolTip() ;
	toolTip		= new CToolTipCtrl () ;
	m_pInfosDlg	= NULL ;
	m_pServerDlg	= NULL ;
	m_pJoueurDlg	= NULL ;
	m_pTaskbar	= NULL ;
	m_pConnectDlg = NULL ;
	m_pFavoris	= NULL ;
	liste			= NULL ;
	skin			= NULL ;
	m_pPasswords	= NULL ;
	m_pStartPrograms = NULL ;
	m_pTempIp = NULL ;

	try {
		m_ip2country.readDatabase("countries.dat") ;
	}
	catch (Exception e) {
		MessageBox ("\"countries.dat\" is missing or corrupted, please reinstall ETBuddies\nCountry info will be missing") ;
	}

#ifdef LOG
	log = new Log ("debug.log") ;
#endif

	

	/********************************************************
	* Create and initialisate main tree						*
	********************************************************/
	listeCtrl = new MainTreeCtrl ()  ;
	listeCtrl->ajouterObserver(this) ;





	

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

//********************************************************************
// Destructeur : libere la place memoire occupe par les variables
//********************************************************************
CETBuddiesDlg::~CETBuddiesDlg ()
{
	/* save buddies list to disk */
	if (liste)
	{
		try	{
			liste->saveList() ;
		}
		catch (Exception e)	{
			MessageBox (e.getMessage(), "I/O Error", MB_ICONERROR) ;
		}
		
		delete (liste) ;
	}
	if (listeCtrl)		delete (listeCtrl) ;

	for (int i = 0 ; i < NB_ICONES ; i++) {
		if (menu[i])		delete (menu[i]) ;
	}

	delete (pref) ;
	delete (progresseRech) ;
//	delete (toolTip) ;

	if (popup_menu)		delete (popup_menu) ;
	if (skin)				delete (skin) ;
	if (transparence)		delete (transparence) ;
	if (mainMenu)			delete (mainMenu) ;
	if (infoJoueur)		delete (infoJoueur) ;
	if (mainMenuPopup)	delete (mainMenuPopup) ;
	if (toolTip)			delete (toolTip) ;
	delete (toolTipJoueur) ;
	if (m_pInfosDlg)			delete (m_pInfosDlg) ;
	if (m_pServerDlg)			delete (m_pServerDlg) ;
	if (m_pJoueurDlg)			delete (m_pJoueurDlg) ;
	if (m_pConnectDlg)				delete (m_pConnectDlg) ;
	if (m_pTempIp)				delete (m_pTempIp) ;
	

#ifdef LOG
	delete (log) ;
#endif

	delete (font) ;

	/* save favorites to disk */
	if (m_pFavoris) 
	{
		try {
			m_pFavoris->saveFavorites() ;
		}
		catch (Exception e)	{
			MessageBox (e.getMessage(), "Erreur I/O", MB_ICONERROR) ;
		}
		
		delete (m_pFavoris) ;
	}


	if (m_pPasswords) 
	{
		try	{
			m_pPasswords->savePasswords() ;
		}
		catch (Exception e)	{
			MessageBox (e.getMessage(), "Erreur I/O", MB_ICONERROR) ;
		}
		
		delete (m_pPasswords) ;
	}

	if (m_pStartPrograms) {
		try	{
			m_pStartPrograms->saveSoftwares() ;
		}
		catch (Exception e)	{
			MessageBox (e.getMessage(), "Erreur I/O", MB_ICONERROR) ;
		}
		
		delete (m_pStartPrograms) ;
	}
}

void CETBuddiesDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CETBuddiesDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_BUDDIES, *listeCtrl);
	DDX_Control(pDX, IDC_PROGRESS_RECHERCHE, *progresseRech) ;
}



BEGIN_MESSAGE_MAP(CETBuddiesDlg, CResizableDialog)
	//{{AFX_MSG_MAP(CETBuddiesDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_CONNECT, OnConnect)
	ON_BN_CLICKED(IDC_REFRESH, OnRefresh)
	ON_NOTIFY(NM_DBLCLK, IDC_BUDDIES, OnDblclkBuddies)
	ON_WM_SIZE()
	ON_WM_KEYUP()
	ON_WM_RBUTTONUP()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDBLCLK()
	ON_BN_CLICKED(IDC_REFRESH_PARTIEL, OnRefreshPartiel)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_STOP_REFRESH, OnStopRefresh)
	ON_WM_SHOWWINDOW()
	ON_WM_CLOSE()
	ON_WM_MOUSEWHEEL()
	ON_WM_KILLFOCUS()
	ON_WM_DESTROY()
	ON_NOTIFY(NM_RCLICK, IDC_BUDDIES, OnRclickBuddies)
	//}}AFX_MSG_MAP
	ON_NOTIFY_EX_RANGE(TTN_NEEDTEXT,0,0xFFFF,OnToolTipNotify)
	ON_COMMAND(ID__REFRESH_SERVERS, OnRefresh)
	ON_COMMAND(ID__QUIT, OnExit)
	ON_COMMAND(ID__ABOUT, OnAbout)
	ON_COMMAND(ID__PREFERENCES, OnOptions)
	ON_COMMAND(ID__RESTORE, OnRestore)
	ON_COMMAND(ID__MINIMIZE, OnMinimize)
	ON_COMMAND(ID__CONNECTTOIP, OnConnectIp)
	ON_COMMAND(ID__SHOWSERVERLIST, OnViewServers)
END_MESSAGE_MAP()
/////////////////////////////////////////////////////////////////////////////
// CETBuddiesDlg message handlers

void CETBuddiesDlg::ajouterMenu (UINT nPosition, UINT nFlags, UINT nIDNewItem /*= 0*/, LPCTSTR lpszNewItem /*= NULL*/)
{
	if (mainMenu) {
		mainMenu->InsertMenu (nPosition, nFlags, nIDNewItem, lpszNewItem) ;
	}
	if (mainMenuPopup) {
		mainMenuPopup->InsertMenu (nPosition, nFlags, nIDNewItem, lpszNewItem) ;
	}
}

BOOL CETBuddiesDlg::OnInitDialog()
{
	CResizableDialog::OnInitDialog();


	toolTip->Create(this) ;
	

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	//********************************************************************
	// initialisation des buddies
	//********************************************************************
	try	{
		liste = ListeBuddies::loadList() ;
	}
	catch (Exception e)	{
		liste = new ListeBuddies () ;
	}
	liste->ajouterObserver (this) ;
	liste->getClientMaitre()->ajouterObserver (this) ;
	liste->getClientMaitre()->ajouterObserver (listeCtrl) ;
	skin = new Skin(pref,this) ;



	//********************************************************************
	// initialisation du redimensionnement
	//********************************************************************
	SetMinTrackSize (CSize (TAILLE_MIN_X,TAILLE_MIN_Y)) ;

	AddAnchor (IDC_BUDDIES, TOP_LEFT, BOTTOM_RIGHT) ;
	// boutons du bas
	AddAnchor (IDCANCEL, BOTTOM_LEFT) ;
	AddAnchor (IDC_ADD, BOTTOM_LEFT) ;
	AddAnchor (IDC_STOP_REFRESH, BOTTOM_LEFT) ;
	AddAnchor (IDC_PROGRESS_RECHERCHE, BOTTOM_LEFT, BOTTOM_RIGHT) ;
	AddAnchor (IDC_REFRESH_PARTIEL, BOTTOM_LEFT) ;

	

	//********************************************************************
	// initialisation des boutons du bas
	//********************************************************************
	for (int i = 0 ; i < NB_ICONES ; i++)
	{
		menu[i] = new CBitmap () ;
		menu[i]->LoadBitmap (icones[i][1]) ;
		((CButton*)GetDlgItem (icones[i][0]))->SetBitmap (*menu[i]) ;
	}

	
	//********************************************************************
	// initialisation des tooltip
	//********************************************************************
	toolTip->AddTool (GetDlgItem(IDC_STOP_REFRESH), IDS_STOP_REFRESH) ;
	toolTip->AddTool (GetDlgItem(IDCANCEL), IDS_EXIT) ;
	toolTip->AddTool (GetDlgItem(IDC_ADD), IDS_ADD) ;
	toolTip->AddTool (GetDlgItem(IDC_BUDDIES), LPSTR_TEXTCALLBACK) ;
	toolTip->AddTool (GetDlgItem(IDC_REFRESH_PARTIEL), IDS_REFRESH_PARTIEL) ;
	toolTipJoueur->Create (this, TTS_NOPREFIX) ;
	toolTipJoueur->AddTool (listeCtrl) ;
	toolTipJoueur->SendMessage(TTM_SETMAXTIPWIDTH, 0, SHRT_MAX); // recognize \n chars!

	/********************************************************************
	* creation du menu principal										*
	********************************************************************/
	mainMenu = new CMenu () ;
	mainMenu->CreateMenu () ;
	mainMenuPopup = new CMenu() ;
	mainMenuPopup->CreatePopupMenu() ;

	/************************
	* Menu files			*
	************************/
	CMenu files ;
	files.CreatePopupMenu() ;
	files.InsertMenu (-1, MF_BYPOSITION|MF_STRING, ADD_SERVER_ID, ADD_SERVER_MENU) ;
	files.InsertMenu (-1, MF_BYPOSITION|MF_STRING, OPTIONS_MENU_ID, OPTIONS_MENU) ;
	files.InsertMenu (-1, MF_SEPARATOR) ;
	files.InsertMenu (-1, MF_BYPOSITION|MF_STRING, EXIT_MENU_ID, EXIT_MENU) ;
	ajouterMenu (-1, MF_BYPOSITION|MF_POPUP|MF_STRING, (UINT)files.m_hMenu, FILES_MENU) ;
	
	
	/************************
	* Menu action			*
	************************/
	CMenu action ;
	action.CreatePopupMenu () ;
	
	action.InsertMenu (-1, MF_BYPOSITION|MF_STRING, REFRESH_MENU_ID,	REFRESH_MENU) ;
	action.InsertMenu (-1, MF_BYPOSITION|MF_STRING, ADD_F_MENU_ID,		ADD_F_MENU) ;
	action.InsertMenu (-1, MF_BYPOSITION|MF_STRING, REMOVE_MENU_ID,		REMOVE_MENU) ;
	action.InsertMenu (-1, MF_SEPARATOR) ;
	action.InsertMenu (-1, MF_BYPOSITION|MF_STRING, JOIN_MENU_ID,		JOIN_MENU) ;
	action.InsertMenu (-1, MF_BYPOSITION|MF_STRING, INFO_SERVER_ID,		INFO_SERVER) ;
	action.InsertMenu (-1, MF_SEPARATOR) ;
	action.InsertMenu (-1, MF_BYPOSITION|MF_STRING, CONNECT_MENU_ID,	CONNECT_MENU) ;
	ajouterMenu (-1, MF_BYPOSITION|MF_POPUP|MF_STRING, (UINT)action.m_hMenu, ACTION_MENU) ;


	/************************
	* Menu view				*
	************************/
	CMenu view ;
	view.CreatePopupMenu() ;
	view.InsertMenu (-1, MF_BYPOSITION|MF_STRING, VIEW_SERVERS_ID,	VIEW_SERVERS) ;
//	view.InsertMenu (-1, MF_BYPOSITION|MF_STRING, VIEW_FAV_ID,		VIEW_FAV) ;
	ajouterMenu (-1, MF_BYPOSITION|MF_POPUP|MF_STRING, (UINT)view.m_hMenu, VIEW_MENU) ;

	/************************
	* Menu skin				*
	************************/
	popup_menu = new CMenu () ;
	popup_menu->CreatePopupMenu () ;
/*	popup_menu->InsertMenu (0, MF_BYPOSITION|MF_STRING|MF_DISABLED, NULL, "Skins") ;
	popup_menu->InsertMenu (1, MF_SEPARATOR) ;*/
	popup_menu->InsertMenu (0, MF_BYPOSITION|MF_STRING|MF_CHECKED, NO_SKIN, "No skin") ;
	vector<CString> listeSkins = skin->getListeSkins() ;
	i = NO_SKIN + 1 ;
	nbSkins = 0 ;
	FOR_VECTOR_IND(CString,listeSkins,j)
	{
		popup_menu->InsertMenu (-1, MF_BYPOSITION|MF_STRING, i, (*j)) ;
		i++ ;
		nbSkins ++ ;
	}
	//ajouterMenu (-1, MF_BYPOSITION|MF_POPUP|MF_STRING, (UINT)popup_menu->m_hMenu, SKIN_MENU) ;


	/************************
	* Menu transparence		*
	************************/
	transparence = new CMenu () ;
	transparence->CreatePopupMenu () ;
	CString trans ;
	transparence->InsertMenu (-1, MF_BYPOSITION|MF_STRING, NO_TRANSPARENCY, "Visible") ;
	transparence->InsertMenu (-1, MF_SEPARATOR) ;
	for (i = 1 ; i < 10 ; i ++)
	{
		trans.Format ("%d %%", (10 - i) * 10) ;
		transparence->InsertMenu (-1, MF_BYPOSITION|MF_STRING, i + NO_TRANSPARENCY, trans) ;
	}



	
	/********************************************************************
	* initialisation du context menu contenant les infos joueurs		*
	********************************************************************/
	infoJoueur = new CMenu() ;
	infoJoueur->CreatePopupMenu() ;
	infoJoueur->InsertMenu (-1, MF_BYPOSITION|MF_STRING, JOIN_MENU_ID, JOIN_MENU) ;
	infoJoueur->InsertMenu (-1, MF_BYPOSITION|MF_STRING, INFO_SERVER_ID, INFO_SERVER) ;
	infoJoueur->SetDefaultItem (JOIN_MENU_ID) ;
	//ajouterMenu (-1, MF_BYPOSITION|MF_POPUP|MF_STRING, (UINT)infoJoueur->m_hMenu, JOUEUR_MENU) ;



	/************************
	* Menu ?				*
	************************/
	CMenu help ;
	help.CreatePopupMenu () ;
	help.InsertMenu (-1, MF_BYPOSITION|MF_STRING, ABOUT_MENU_ID, ABOUT_MENU) ;
	ajouterMenu (-1, MF_BYPOSITION|MF_POPUP|MF_STRING, (UINT)help.m_hMenu, HELP_MENU) ;


	/************************
	* Context menu Buddy	*
	************************/
	m_menuBuddy.CreatePopupMenu() ;
	m_menuBuddy.InsertMenu (-1, MF_BYPOSITION|MF_STRING, REMOVE_MENU_ID, REMOVE_MENU) ;
//	m_menuBuddy.SetDefaultItem (REMOVE_MENU_ID) ;

	m_defaultMenu.CreatePopupMenu() ;
	m_defaultMenu.InsertMenu (-1, MF_BYPOSITION|MF_STRING, ADD_F_MENU_ID, ADD_F_MENU) ;
	m_defaultMenu.InsertMenu (-1, MF_BYPOSITION|MF_STRING, REFRESH_MENU_ID, REFRESH_MENU) ;
	m_defaultMenu.InsertMenu (-1, MF_BYPOSITION|MF_STRING, VIEW_SERVERS_ID, "View server list...") ;
	m_defaultMenu.InsertMenu (-1, MF_BYPOSITION|MF_STRING, CONNECT_MENU_ID, CONNECT_MENU) ;


	/********************************************************************
	* Association du menu avec le programme								*
	********************************************************************/
	SetMenu (mainMenu) ;
	MAJMenu() ;


	




	/************************************
	* initialisation du Systray			*
	************************************/
/*	TraySetIcon (IDR_MAINFRAME) ;
	TraySetToolTip("ETBuddies");
	TraySetMenu (IDR_SYSTRAY_MENU) ;
	TrayShow () ;*/


	





	/********************************************
	* Initialisation diverses					*
	********************************************/
	init = true ;
	EnableSaveRestore(_T("ETBuddies"));
	try
	{
		setTransparence (pref->getTransparence()) ;
	}
	catch (Exception e)
	{
		MessageBox (e.getMessage(), "Erreur transparence", MB_ICONERROR) ;
	}

	listeCtrl->OnInitDialog (liste) ;

	
	


	progresseRech->SetRange (0, 100) ;

	// chargement des preferences
	try	{
		setSkin (skin->getSkin (pref->getSkin())) ;
	}
	CATCH_EXCEPTION ;
	setTransparence (pref->getTransparence()) ;
//	this->ajouterMenu (-1, MF_BYPOSITION|MF_POPUP|MF_STRING, (UINT)transparence->m_hMenu, TRANS_MENU) ;


	/********************************************
	* Lancement du refresh eventuel				*
	********************************************/
	if (this->pref->getRefreshAtStart()) {
		this->OnRefresh() ;
	}
	
	//SetTimer (ID_TIMER_REFRESH, 500, NULL) ;





	/********************************************
	* Init taskbar								*
	********************************************/
	CoInitialize(0);
	CoCreateInstance(CLSID_TaskbarList,0, 
		CLSCTX_INPROC_SERVER,IID_ITaskbarList,(void**)&m_pTaskbar);
	m_pTaskbar->HrInit(this->m_hWnd);
	if (this->IsIconic()) {
		m_pTaskbar->DeleteTab(m_hWnd);
	}



	

	/********************************************
	* init TopMost								*
	********************************************/
	this->updateStayOnTop () ;

	
	/********************************************
	* init tray icon							*
	********************************************/
	this->TraySetIcon (m_hIcon) ;
	this->TrayShow() ;
	this->TraySetToolTip ("ETBuddies") ;
	this->UpdateTrayMenu() ;


	this->Invalidate(FALSE) ;

	/********************************************************
	* Initialisate favorites								*
	********************************************************/
	try	{
		m_pFavoris = Favorites::loadFavorites(FICHIER_FAVORIS) ;
	}
	catch (Exception e)	{
		m_pFavoris = new Favorites() ;
		m_pFavoris->setNomFichier(FICHIER_FAVORIS) ;
	}	
	this->m_pFavoris->updateMaster (this->liste) ;


	try	{
		this->m_pPasswords = PasswordFile::loadPasswords() ;
	}
	catch (Exception e)	{
		this->m_pPasswords = new PasswordFile() ;
	}

	try {
		this->m_pStartPrograms = StartPrograms::loadSoftwares() ;
	}
	catch (Exception e)	{
		this->m_pStartPrograms = new StartPrograms() ;
	}
	
	if (pref->getStartMinimized()) {
		OnMinimize() ;
	}


	// catch ET://IP/ arguments
	CString ip ;
	bool connect = false ;

	if (__argc > 1) {
		try {
			ETLink test = ETLink(__argv[1]) ;
			ip = test.getIp() ;
			connect = true ;
		}
		catch (Exception e) {}
	}


	if (connect) {
		m_pTempIp = new Ip(ip) ;
		connection(m_pTempIp) ;
	}


	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CETBuddiesDlg::initTimerRefresh ()
{	
	KillTimer (ID_TIMER_REFRESH) ;

	if (TEMPS_REFRESH) {
		SetTimer (ID_TIMER_REFRESH, TEMPS_REFRESH * 60 * 1000, NULL) ;
	}
}
/*
void CETBuddiesDlg::connecter(Ip * ip) {
	lanceET (ip) ;
}*/

void CETBuddiesDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		this->OnAbout() ;
	}
	else
	{
		CResizableDialog::OnSysCommand(nID, lParam);
	}
}

/*virtual*/ void CETBuddiesDlg::OnTrayMouseMove(CPoint pt)
{
//	CResizableDialog::OnTrayMouseMove (pt) ;
//	this->TrayShow() ;
}


/************************************************************
* La fenetre necessite d'etre redessine					*
************************************************************/
void CETBuddiesDlg::OnPaint() 
{
#ifndef	TEST_DD
	if (this->afficherSkin)
	{
		/********************************************************
		* Affichage du skin										*
		********************************************************/
		CDC * cdc = this->GetWindowDC () ;

		
		cdc->SelectObject (font) ;
		
		CRect r ;
		this->GetWindowRect (r);
		ScreenToClient (r) ;
		
		try	{
			this->skin->afficherSkin (cdc, CSize(r.Width(),r.Height()), this->liste) ;
		}
		catch (Exception e)
		{
			/********************************************************
			* Impossible d'afficher le skin -> desactivation		*
			* et affichage du message d'erreur						*
			********************************************************/
			this->setSkin (SKIN_DEFAULT) ;
			MessageBox (e.getMessage(),"Exception") ;	
		}
	}
#else
	if (this->dd && test && afficherSkin)
	{
		try
		{
			CRect r ;
			GetWindowRect (r) ;
			this->dd->afficherImage (test, 0, 0) ;
		}
		catch (Exception e)
		{
			delete (this->dd) ;
			this->dd = NULL ;
			this->test = NULL ;
			MessageBox (e.getMessage(),"",MB_ICONERROR) ;
		}
	}
#endif


	
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);

		
	}
	else
	{
		CResizableDialog::OnPaint();
	}

}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CETBuddiesDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/************************************************************
* Demande d'ajout d'un buddy								*
************************************************************/
void CETBuddiesDlg::OnAdd() 
{
	// TODO: Add your control notification handler code here
	CString nom ;
	AddBudDlg dlg ;
	if (dlg.DoModal () == IDOK)
	{
		
	}
	/*EDIT(IDC_ADDBUD)->GetWindowText (nom) ;
	if (nom.Compare ("") == 0)
	{
		MessageBox ("Veuillez rentrer un nom de buddy","Erreur", MB_ICONERROR) ;
		return ;
	}
	*/
	
}

/************************************************************
* Indique que l'etat d'un objet a chang					*
************************************************************/
/*virtual*/ void CETBuddiesDlg::OnChange (Objet * obj, UINT msg, void * param1, void * param2)
{
	if(::IsWindow (m_hWnd))
	{
		/************************************************************************
		*	Demande de reaffichage												*
		************************************************************************/
		if (msg == Image::ON_REDRAW && obj->getNomClasse() == Image::NOM_CLASSE)
		{
			if (param1)		this->InvalidateRect ((CRect*)param1, FALSE) ;
			else			this->Invalidate (FALSE) ;
		}
		/************************************************************************
		*	Le status de la barre de progression a chang						*
		************************************************************************/
		else if (msg == ListeBuddies::ON_PROGRESS_RECHERCHE && obj->getNomClasse() == ListeBuddies::NOM_CLASSE)
		{
			ListeBuddies * listeBud = (ListeBuddies*)obj ;
			int progress = (*(int*)param1) ;
			
			if (this->afficherSkin)
			{
				//this->Invalidate (FALSE) ;
				ASSERT(this->skin->getProgress()) ;
				UINT oldPos = this->skin->getProgress()->getPos() ;
				if (progress - oldPos > 2 || progress - oldPos < 0) 
				{
					this->skin->getProgress()->setPos (progress < 100 ? progress : 0) ;
				}
			}
			else
			{
				this->progresseRech->SetPos (progress < 100 ? progress : 0) ;
				if (m_pServerDlg && m_pServerDlg->IsWindowVisible()) {
					m_pServerDlg->getProgress()->SetPos(progress < 100 ? progress : 0) ;
				}
			}
		}
		/************************************************************************
		*	Demande de rafraichissement du status des joueurs sans se 			*
		*	connecter aux serveurs (utilise les donnes en memoire)				*
		************************************************************************/
		else if (msg == ListeBuddies::ON_CACHE_REFRESH)
		{
			if (this->afficherSkin)		this->Invalidate(FALSE) ;

			if (this->listeCtrl)		this->listeCtrl->refreshTree () ;

		}
		/************************************************************************
		*	Demande d'actualisation des buddies On/offline						*
		************************************************************************/
		else if (msg == BoutonActualiser::ON_ACTUALISER && obj->getNomClasse() == Image::NOM_CLASSE)
		{
			this->OnRefresh/*Partiel*/ () ;
		}
		/************************************************************************
		*	Demande d'info buddy												*
		************************************************************************/
		else if (msg == BuddyImage::ON_INFO_BUDDY && param1 != NULL)
		{
			if (this->skin /*&& !this->afficheInfoJoueur*/)
			{
			/*	this->afficheInfoJoueur = true ;
				JoueursDlg dlg ;
				dlg.DoModal (this->skin, (Buddie*)param1) ;
				this->afficheInfoJoueur = false ;*/
				this->getJoueurDlg()->afficher(this->skin, (Buddie*)param1) ;
			}
//			this->connection (((Buddie*)param1)->getIp()) ;
		}
		/************************************************************************
		*	Demande de connection												*
		************************************************************************/
		else if (msg == BuddyJoueurImage::ON_CONNECT && param1 != NULL)
		{
			this->connection (((Server*)param1)->getIp()) ;
		}

		/************************************************************************
		*	Actions diverses effectue par le skin								*
		************************************************************************/
		else if (msg == BoutonAdd::ON_ADD) {
			this->OnAdd () ;
		}
		else if (msg == BoutonExit::ON_EXIT) {
			this->OnCancel () ;
		}
		else if (msg == BoutonStopRefresh::ON_STOP_REFRESH) {
			this->OnStopRefresh() ;
		}
		else if (msg == BoutonOptions::ON_OPTIONS) {
			this->OnOptions () ;
		}
		else if (msg == BoutonFiles::ON_FILE && param1 != NULL) {
			CRect * rect = (CRect*)param1 ;
			ClientToScreen(rect) ;
			this->mainMenuPopup->TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, rect->left, rect->bottom, this);  
		}
/*		else if (msg == TreeBudiesCtrl::ON_SEL_CHANGE) {
			this->MAJMenu() ;
		}*/
		else if (msg == BuddyImage::ON_MENU_BUDDY && param1 != NULL && param2 != NULL) {
			CPoint * pt = (CPoint*)param2 ;
			CRect rect ;
			GetWindowRect (&rect) ;
			this->selectBuddy ((Buddie*)param1) ;
			this->m_menuBuddy.TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pt->x + rect.left, pt->y + rect.top, this) ;
		}
		else if (msg == BuddyJoueurImage::ON_MENU_JOUEUR && param1 != NULL && param2 != NULL) 
		{
			ASSERT (this->m_pJoueurDlg) ;

			if (this->m_pJoueurDlg) 
			{
				CPoint * pt = (CPoint*)param2 ;
				CRect rect ;
				this->m_pJoueurDlg->GetWindowRect (&rect) ;
				this->selectPlayer ((Joueur*)param1) ;
				this->infoJoueur->TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pt->x + rect.left, pt->y + rect.top, this) ;
			}
		}
	/*	else if (msg == ClientMaster::ON_SERVER_DELETE) {
			this->m_pFavoris->updateMaster (this->liste) ;
		}*/
		else if (msg == ClientMaster::ON_REFRESH_COMPLETE) {
			this->m_pFavoris->updateMaster (this->liste) ;
		}
	}
}


/********************************************************
* Demande de lancement d'ET en se connectant au serveur	*
* sur lequel se trouve le buddy selectionn				*
********************************************************/
void CETBuddiesDlg::OnConnect() 
{
	// TODO: Add your control notification handler code here
	Joueur * j = NULL ;
	if (!this->afficherSkin)	j = this->listeCtrl->getJoueurSel() ;
	else						j = this->getSelectedPlayer() ;

	if (j) {
		try	{
			this->connection (j->getServeur()->getIp()) ;
		}
		CATCH_EXCEPTION;
	}
}

/********************************************************
* Lance Enemy Territory avec comme parametre l'ip		*
* a rejoindre											*
********************************************************/
void CETBuddiesDlg::connection (Ip * ip)
{

	// lancement d'ET
	this->getInfosDlg()->ShowWindow(SW_HIDE) ;
	if (_beginthread (lanceET, 0, (void*)ip) == -1)
	{
		ERREUR("Creation thread : ");
	}

}


/********************************************************
* Demande de suppression du buddy selectionn			*
********************************************************/
void CETBuddiesDlg::OnSuppr() 
{
	try	{
		Buddie * bud = NULL ;

		if (!this->afficherSkin) 
		{
			bud = this->listeCtrl->getBuddySel () ;
			if (bud) {
				this->liste->enleverBuddie (bud) ;
			}
		}
		else 
		{
			bud = this->getSelectedBuddy () ;
			if (bud) {
				this->liste->enleverBuddie (bud) ;
			}
		}
	}
	CATCH_EXCEPTION_NO_MSG
}

void CETBuddiesDlg::Suppr ()
{
	this->OnSuppr () ;
}

/********************************************************
* Demande de rafraichissement complet de la liste des	*
* serveurs												*
********************************************************/
void CETBuddiesDlg::OnRefresh() 
{
	try
	{
		this->liste->actualiserJoueurs () ;
		this->liste->getClientMaitre()->ajouterObserver (this->listeCtrl) ;
	}
	CATCH_EXCEPTION ;
	this->progresseRech->SetPos (0) ;
}

/********************************************************
* Actions diverses...									*
********************************************************/
void CETBuddiesDlg::OnDblclkBuddies(NMHDR* pNMHDR, LRESULT* pResult) {
	this->OnConnect () ;
	*pResult = 0;
}


void CETBuddiesDlg::OnSize(UINT nType, int cx, int cy) {
	CDialog::OnSize(nType, cx, cy);
	this->ArrangeLayout () ;
}

void CETBuddiesDlg::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) {
	if (nChar == VK_DELETE)		this->OnSuppr () ;
	CResizableDialog::OnKeyUp(nChar, nRepCnt, nFlags);
}


BOOL CETBuddiesDlg::PreTranslateMessage(MSG* pMsg) {
	// TODO: Add your specialized code here and/or call the base class
	this->toolTip->RelayEvent (pMsg) ;
	this->toolTipJoueur->RelayEvent (pMsg) ;
	
    if (pMsg->message ==WM_RBUTTONDOWN && !this->afficherSkin)
    {

		this->listeCtrl->SelectItem(this->listeCtrl->GetItemUnderMouse()) ;

		Joueur * sel = this->listeCtrl->getJoueur(this->listeCtrl->GetItemUnderMouse()) ;

		Buddie * bud = NULL ;
		bud = this->listeCtrl->getBuddy (this->listeCtrl->GetItemUnderMouse()) ;
	
		if (sel != NULL && this->infoJoueur) {
			this->infoJoueur->TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pMsg->pt.x, pMsg->pt.y, this);  
		}
		
		if (bud != NULL) {
			this->m_menuBuddy.TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pMsg->pt.x, pMsg->pt.y, this) ;
		}

		if (bud == NULL && sel == NULL) {
			m_defaultMenu.TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pMsg->pt.x, pMsg->pt.y, this) ;
		}

		this->selectPlayer (sel) ;
		this->selectBuddy (bud) ;
    }
	else if (pMsg->message==WM_MOUSEMOVE) {
		UpdateToolTips();
	}
	return CResizableDialog::PreTranslateMessage(pMsg);
}
/********************************************************
* Fin actions diverses									*
********************************************************/

/****************************************************************
* Affiche ou cache les controls	(boutons,...)					*
****************************************************************/
void CETBuddiesDlg::afficherControls (bool afficher /*= true*/)
{
	for (int i = 0 ; i < TAILLE_LISTE(controls) ; i++)
	{
		GetDlgItem(controls[i])->ShowWindow (afficher ? SW_SHOW : SW_HIDE) ;
	}
	if (!afficher)
		this->ModifyStyle (WS_CAPTION, 0, SWP_NOZORDER) ;
	else
		this->ModifyStyle (0, WS_CAPTION, SWP_NOZORDER) ;

	this->SetMenu (afficher ? this->mainMenu : NULL) ;

	CRect r ;
	GetWindowRect (r) ;
	SetWindowPos (NULL, 0, 0, r.Width() + 1, r.Height() + 1, SWP_NOMOVE|SWP_NOZORDER) ;
	SetWindowPos (NULL, 0, 0, r.Width(), r.Height(), SWP_NOMOVE|SWP_NOZORDER) ;
	
}

void CETBuddiesDlg::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if (this->afficherSkin)			this->skin->OnRButtonUp (point) ;

	CRect r ;
	this->GetWindowRect(r) ;
	this->MAJMenu() ;
	CResizableDialog::OnRButtonUp(nFlags, point);
}

BOOL CETBuddiesDlg::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	// TODO: Add your specialized code here and/or call the base class
	return CResizableDialog::OnNotify(wParam, lParam, pResult);
}

BOOL CETBuddiesDlg::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	UINT id = LOWORD(wParam) ;


	/********************************************************************
	* L'utilisateur a selectionne un skin								*
	********************************************************************/
	if (id >= NO_SKIN && id <= NO_SKIN + this->nbSkins)
	{
		try
		{
			if (id != NO_SKIN)		this->setSkin (id - NO_SKIN - 1) ;
			else					this->setSkin (SKIN_DEFAULT) ;
		}
		catch (Exception e)
		{	
			this->setSkin (SKIN_DEFAULT) ;
			MessageBox ("Impossible de charger le skin :\n" + e.getMessage(), "Erreur", MB_ICONERROR) ;
		}
		
	}

	/********************************************************************
	* L'utilisateur a selectionne quelque chose dans le menu principal	*
	********************************************************************/
	else if (id >= BASE_MENU_ID && id < END_MENU_ID)
	{
		switch (id)
		{
		case OPTIONS_MENU_ID:	OnOptions () ;		break ;
		case EXIT_MENU_ID:		OnOK () ;			break ;
		case ABOUT_MENU_ID:		OnAbout () ;		break ;
		case VIEW_SERVERS_ID:	OnViewServers () ;	break ;
		case REFRESH_MENU_ID:	OnRefresh () ;		break ;
		case ADD_F_MENU_ID:		OnAdd () ;			break ;
		case REMOVE_MENU_ID:	OnSuppr() ;			break ;
		case JOIN_MENU_ID:		OnConnect() ;		break ;
		case CONNECT_MENU_ID:	OnConnectIp() ;		break ;
//		case JOIN_PLAYER_ID:	OnConnect() ;		break ;
		case INFO_SERVER_ID:	OnInfosServer() ;	break ;
		case ADD_SERVER_ID:	this->m_addServer.ShowWindow (SW_SHOW) ; this->m_addServer.SetFocus(); break;

		}
	}

	/********************************************************************
	* L'utilisateur a selectionne un niveau de transparence				*
	********************************************************************/
	else if (id >= NO_TRANSPARENCY && id < NO_TRANSPARENCY + 10)
	{
		this->setTransparence (10 - id + NO_TRANSPARENCY) ;
	}

	return CResizableDialog::OnCommand(wParam, lParam);
}

void CETBuddiesDlg::OnConnectIp ()
{
	/*ConnectIpDlg dlg ;
	dlg.ajouterObserver (this) ;
	dlg.DoModal () ;*/
	this->getConnectIpDlg()->afficher() ;
}

/****************************************************************
* Modifie les parametres de transparence de la fenetre			*
* Factor = niveau de transparence (0 : invisible,				*
*								   255 : completement visible)	*
****************************************************************/
void CETBuddiesDlg::MakeWindowTransparent(BYTE factor /*=255*/)
{
   /* First, see if we can get the API call we need. If we've tried
    * once, we don't need to try again. */
   if (!initialized)
   {
      HMODULE hDLL = LoadLibrary ("user32");

      pSetLayeredWindowAttributes = 
         (PSLWA) GetProcAddress(hDLL, "SetLayeredWindowAttributes");

      initialized = TRUE;
   }

   /* ... elided ... */
   
   if (pSetLayeredWindowAttributes == NULL)
   {
	   throw (Exception ("Impossible de trouver la fonction SetLayeredWindowAttributes!\nVersion incorrecte de windows (Win2000/XP requis)")) ;
   }
    

   /* Windows need to be layered to be made transparent. This is done
    * by modifying the extended style bits to contain WS_EX_LAYARED. */
   SetLastError(0);


   SetWindowLong(this->m_hWnd, 
                 GWL_EXSTYLE , 
                 GetWindowLong(this->m_hWnd, GWL_EXSTYLE) | WS_EX_LAYERED);

   if (GetLastError())
   {
	   ERREUR("Erreur SetWindowLong") ;
   }
  

   if (!pSetLayeredWindowAttributes (this->m_hWnd, RGB(255,0,255), factor, LWA_COLORKEY|LWA_ALPHA))
   {
		ERREUR("Erreur SetLayeredWindowAttributes") ;
   }

}


/****************************************************************
* Modifie le niveau de transparence de la fenetre				*
* Met a jour le menu transparence								*
* trans = niveau de transparence (0 : invisible,				*
*								  10 : completement visible)	*
****************************************************************/
void CETBuddiesDlg::setTransparence (BYTE trans)
{
	try {
		this->MakeWindowTransparent ((255 * (trans)) / 10) ;
	}
	catch (Exception e) {
	}
	UINT id = trans ;
	id = 10 - id + NO_TRANSPARENCY ;
	this->transparence->CheckMenuRadioItem (NO_TRANSPARENCY, NO_TRANSPARENCY + 9, id, MF_BYCOMMAND) ;
	this->pref->setTransparence (trans) ;
}


/****************************************************************
* Interactions avec la fenetre									*
* Elles sont transmises au skin s'il est affich				*
****************************************************************/
void CETBuddiesDlg::OnLButtonDown(UINT nFlags, CPoint point) {
	if (this->afficherSkin)			this->skin->OnLButtonDown (point) ;
	this->MAJMenu() ;
	CResizableDialog::OnLButtonDown(nFlags, point);
}

void CETBuddiesDlg::OnLButtonUp(UINT nFlags, CPoint point) {
	if (this->afficherSkin)			this->skin->OnLButtonUp (point) ;
	this->MAJMenu() ;
	CResizableDialog::OnLButtonUp(nFlags, point);
}

void CETBuddiesDlg::OnLButtonDblClk(UINT nFlags, CPoint point) {
	if (this->afficherSkin)			this->skin->OnLButtonDblClk (point) ;
	this->MAJMenu() ;
	CResizableDialog::OnLButtonDblClk(nFlags, point);
}

void CETBuddiesDlg::OnMouseMove(UINT nFlags, CPoint point) {
	if (this->afficherSkin)			this->skin->OnMouseMove(point) ;
	CResizableDialog::OnMouseMove(nFlags, point);
}
/****************************************************************
* Fin des interactions											*
****************************************************************/


/****************************************************************
* Cette fonction indique quel skin doit etre affich			*
****************************************************************/
void CETBuddiesDlg::setSkin (int idSkin)
{
	if (idSkin != SKIN_DEFAULT)
	{
		this->skin->chargerSkin (idSkin) ;
		this->skin->ajouterObserver (this) ;
		this->afficherSkin = true ;
	}
	else {
		this->afficherSkin = false ;
		if (this->m_pJoueurDlg)		this->m_pJoueurDlg->ShowWindow(SW_HIDE) ;
	}
	this->popup_menu->CheckMenuRadioItem (NO_SKIN , NO_SKIN + this->nbSkins, idSkin + NO_SKIN + 1, MF_BYCOMMAND) ;
	this->pref->setSkin (this->skin->getSkin (idSkin)) ;
	this->afficherControls (!this->afficherSkin) ;

	if (this->skin->getProgress())
	{
		this->skin->getProgress()->setRange (0,100) ;
	}
}




/************************************************
* L'utilisateur veut voir les options			*
************************************************/
void CETBuddiesDlg::OnOptions () {
	Options dlg ("Preferences", this) ;
	if (dlg.DoModal (this->pref) == IDOK)
	{
		this->initTimerRefresh() ;
	}
}

/************************************************
* L'utilisateur veut voir le About				*
************************************************/
void CETBuddiesDlg::OnAbout () {
	CAboutDlg dlg ;
	dlg.DoModal() ;
}

/************************************************
* L'utilisateur veut rafraichir les serveurs	*
************************************************/
void CETBuddiesDlg::OnRefreshPartiel() {
	OnRefresh() ;
	/*this->liste->actualiserPartiellement () ;*/
}

/************************************************
* Le timer est arriv a chance				*
************************************************/
void CETBuddiesDlg::OnTimer(UINT nIDEvent) {
	/************************************************************
	* Demande d'actualisation de la liste						*
	************************************************************/
	if (nIDEvent == ID_TIMER_REFRESH) {
		this->OnRefreshPartiel () ;
	}

	CResizableDialog::OnTimer(nIDEvent);
}

/************************************************
* Retourne la liste des buddies					*
************************************************/
ListeBuddies * CETBuddiesDlg::getListeBud() {
	return (this->liste);
}


void CETBuddiesDlg::OnViewServers() 
{
	// TODO: Add your control notification handler code here
	this->getServerDlg () ;
	this->m_pServerDlg->ajouterObserver (this) ;
	this->m_pServerDlg->afficher (this->liste->getClientMaitre()) ;

}

void CETBuddiesDlg::OnInfosServer()
{
	Joueur * j = NULL ;
	if (this->afficherSkin) {
		j = this->getSelectedPlayer() ;
	}
	else {
		j = this->listeCtrl->getJoueurSel() ;
	}

	if (j && j->getServeur()) 
	{
		this->getInfosDlg() ;

		this->liste->getClientMaitre()->ajouterObserver (this->m_pInfosDlg) ;
		this->m_pInfosDlg->afficher (j->getServeur()) ;
	}

}

void CETBuddiesDlg::OnStopRefresh() 
{
	// TODO: Add your control notification handler code here
	this->liste->stopperActualisation() ;
}

void CETBuddiesDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CResizableDialog::OnShowWindow(bShow, nStatus);
	UpdateTrayMenu() ;
}


void CETBuddiesDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	if (this->pref->getMinInsteadClose()) {
		this->ShowWindow (SW_MINIMIZE) ;
	}
	else {
		CResizableDialog::OnCancel();
	}
}

void CETBuddiesDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	//this->RemoveIcon (m_hIcon) ;
	CResizableDialog::OnClose();
}

void CETBuddiesDlg::OnOK()
{
//	CResizableDialog::OnOK() ;
}

// met a jour les menus en grisant les choix invalides
void CETBuddiesDlg::MAJMenu ()
{
	Joueur * sel = this->listeCtrl->getJoueurSel() ;
	Ip * ipSel = sel ? sel->getServeur()->getIp() : NULL ;



	UINT enableIp = ipSel != NULL ? MF_ENABLED : MF_GRAYED ;
	UINT enableJoueur = sel != NULL ? MF_ENABLED : MF_GRAYED ;
	UINT enableBuddy = this->listeCtrl->getBuddySel() == NULL ? MF_GRAYED : MF_ENABLED ;


	this->mainMenu->EnableMenuItem (JOIN_MENU_ID,	MF_BYCOMMAND|enableIp) ;
	this->mainMenu->EnableMenuItem (REMOVE_MENU_ID, MF_BYCOMMAND|enableBuddy) ;
	this->mainMenu->EnableMenuItem (INFO_SERVER_ID, MF_BYCOMMAND|enableJoueur) ;
}


BOOL CETBuddiesDlg::OnToolTipNotify(UINT id, NMHDR *pNMH, LRESULT *pResult)
{
	TOOLTIPTEXT *pText = (TOOLTIPTEXT *)pNMH;
	int control_id = ::GetDlgCtrlID((HWND)pNMH->idFrom);
	if (!control_id)
		return FALSE;
	CString info, infoIncolore;
	
	if (control_id == IDC_BUDDIES)
	{
		Joueur * sel = this->listeCtrl->getJoueur(this->listeCtrl->GetItemUnderMouse()) ;
		if (!sel) {
			return (FALSE) ;
		}

		/* mise en forme du texte du tooltip */
		Server * server = sel->getServeur() ;
		if (server)	{
			info.Format (TOOLTIPON,sel->getNomColore(), server->getNomColore(), sel->getXp(), sel->getPing()) ;
			infoIncolore = COULEUR2INCO(info) ;
		}

	}

	m_strToolTip.ReleaseBuffer(); // release old used buffer
	m_strToolTip = infoIncolore;
	this->toolTipJoueur->setTexteColore (info) ;
	pText->lpszText = m_strToolTip.GetBuffer(1);
	pText->hinst = NULL; // we are not using a resource
	PostMessage(WM_ACTIVATE);
	return TRUE;
}


void CETBuddiesDlg::UpdateToolTips ()
{
	HTREEITEM sel = this->listeCtrl->GetItemUnderMouse();
	if (sel != NULL)
	{
		if (this->toolTipJoueur->IsWindowVisible())
			this->toolTipJoueur->Update();
		return;
	}

	if (sel == NULL)
		this->toolTipJoueur->Pop();

}

BOOL CETBuddiesDlg::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
	// TODO: Add your message handler code here and/or call default
	
	return CResizableDialog::OnMouseWheel(nFlags, zDelta, pt);
}


/* Update main dialog in order to make it always on top or not */
void CETBuddiesDlg::updateStayOnTop ()
{
	const CWnd * top ;
	if (MAIN_PREF->getStayOnTop())			top = &wndTopMost ;
	else									top = &wndNoTopMost ;

	this->SetWindowPos (top, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE) ;
}

void CETBuddiesDlg::OnKillFocus(CWnd* pNewWnd) 
{
	CResizableDialog::OnKillFocus(pNewWnd);
	
	// TODO: Add your message handler code here
	
}

void CETBuddiesDlg::OnDestroy() 
{
	CResizableDialog::OnDestroy();
	
	this->TrayHide() ;
}

void CETBuddiesDlg::OnExit()
{
	PostQuitMessage(0) ;
}

void CETBuddiesDlg::UpdateTrayMenu()
{
	if (IsIconic()) {
		this->TraySetMenu (IDR_SYSTRAY_MENU_MIN) ;
		if (m_pTaskbar)		this->m_pTaskbar->DeleteTab(m_hWnd) ;
	}
	else {
		this->TraySetMenu (IDR_SYSTRAY_MENU) ;
	}
}

BOOL CETBuddiesDlg::ShowWindow (int nCmdShow)
{
	BOOL retour = CResizableDialog::ShowWindow(nCmdShow) ;
	UpdateTrayMenu() ;

	return (retour) ;
}

void CETBuddiesDlg::OnMinimize() {
	this->ShowWindow(SW_MINIMIZE) ;

}

void CETBuddiesDlg::OnRestore() {
	if (IsIconic()) {
		this->ShowWindow(SW_RESTORE) ;
	}
	else {
	}
}

void CETBuddiesDlg::OnRclickBuddies(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}
