//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// Degrade.cpp: implementation of the Degrade class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "Degrade.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


#define COUL_CONTOUR		RGB(0,0,0)

#define RED(coul)			((BYTE)(coul))
#define GREEN(coul)			((BYTE)((coul)>>8))
#define BLUE(coul)			((BYTE)((coul)>>16))

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Degrade::Degrade()
{

}

Degrade::~Degrade()
{

}


/*static*/ void Degrade::dessiner (CDC * dc, CRect rect, COLORREF couleur1, COLORREF couleur2, BYTE pourcent, bool drawText /*= true*/)
{
	CRect contour(rect) ;
	CFont font ;
	font.CreateFont (13,0,0,0,400,0,0,0,0,0,0,0,0,"Arial") ;
	CFont * oldFont = dc->SelectObject(&font) ;

	/* Affichage du contour */
	CPen pen (PS_SOLID, 1, COUL_CONTOUR) ;
	CPen * old = dc->SelectObject (&pen) ;
	dc->MoveTo (contour.left,	contour.top) ;
	dc->LineTo (contour.right,	contour.top) ;
	dc->LineTo (contour.right,	contour.bottom) ;
	dc->LineTo (contour.left,	contour.bottom) ;
	dc->LineTo (contour.left,	contour.top) ;
	dc->SelectObject (old) ;
	
	/* affichage du degrad */
	COLORREF couleur ;

	int deltR = RED(couleur2) -		RED(couleur1) ;
	int deltG = GREEN(couleur2) -	GREEN(couleur1) ;
	int deltB = BLUE(couleur2) -	BLUE(couleur1) ;
	
	contour.DeflateRect(1,1,1,0) ;

	if (pourcent > 100)	pourcent = 100 ;
	for (int i = 0 ; i < pourcent * contour.Width() / 100 ; i++) 
	{
		couleur = RGB(
			RED(couleur1) + deltR * i / contour.Width(),
			GREEN(couleur1) + deltG * i / contour.Width(),
			BLUE(couleur1) + deltB * i / contour.Width()) ;

		CPen pen2 (PS_SOLID, 1, couleur) ;
		old = dc->SelectObject (&pen2) ;
		dc->MoveTo (contour.left + i, contour.top) ;
		dc->LineTo (contour.left + i, contour.bottom) ;
		dc->SelectObject (old) ;
		
	}

	/* affichage du texte */
	if (drawText) {
		CString texte ;
		texte.Format ("%02d%%", pourcent) ;
		contour.DeflateRect (0,0,0,1) ;
		dc->DrawText (texte, contour, DT_CENTER) ;
	}

	dc->SelectObject(oldFont) ;
}