//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ConnectIpDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ConnectIpDlg.h"
#include "BuddyJoueurImage.h"
#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DEFAUT_PORT		27960

#define FAV_FILE		"Connect.fav"

/////////////////////////////////////////////////////////////////////////////
// ConnectIpDlg dialog


ConnectIpDlg::ConnectIpDlg(CWnd* pParent /*=NULL*/)
	: CDialog(ConnectIpDlg::IDD, pParent), Objet("ConnectIpDlg")
{
	//{{AFX_DATA_INIT(ConnectIpDlg)
	//}}AFX_DATA_INIT

	try {
		m_pOldIps = Favorites::loadFavorites(FAV_FILE) ;
	}
	catch (Exception e) {
		this->m_pOldIps = new Favorites () ;
		m_pOldIps->setNomFichier(FAV_FILE) ;
	}

	this->Create (IDD, pParent) ;

	
}

ConnectIpDlg::~ConnectIpDlg () 
{
	
	try {
		m_pOldIps->saveFavorites() ;
	}
	CATCH_LOG ;

	delete (m_pOldIps) ;
}


void ConnectIpDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ConnectIpDlg)
	DDX_Control(pDX, IDC_IP, m_comboIp);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(ConnectIpDlg, CDialog)
	//{{AFX_MSG_MAP(ConnectIpDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ConnectIpDlg message handlers

BOOL ConnectIpDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	

	/* add favorites to the combo */
	vector<CString> * fav = m_pOldIps->getFavorites () ;
	FOR_VECTOR(CString, (*fav)) {
		m_comboIp.AddString (*i) ;
	}
	m_comboIp.SetWindowText ("") ;

	GetDlgItem(IDC_IP)->SetFocus() ;


	return (FALSE) ;
//	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

int ConnectIpDlg::DoModal() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CDialog::DoModal();
}

void ConnectIpDlg::OnOK() 
{
	this->ShowWindow (SW_HIDE) ;

	// TODO: Add extra validation here
	/* retrieve Ip on combo and store it in favorites */
	CString ip ;
	GetDlgItemText (IDC_IP, ip) ;
	m_pOldIps->addServer (ip) ;
	if (m_comboIp.FindString (-1, ip) == CB_ERR) {
		m_comboIp.AddString (ip) ;
	}

	/*BYTE ip1,ip2,ip3,ip4 ;
	UINT port = 0 ;
	sscanf (STR_BUFFER(ip), "%d.%d.%d.%d:%d", &ip1, &ip2, &ip3, &ip4, &port) ;
	if (port == 0)	{
		port = DEFAUT_PORT ;
	}*/
	MAIN_DLG->connection (new Ip (ip)) ;



	CDialog::OnOK();


}


void ConnectIpDlg::afficher ()
{
	this->ShowWindow (SW_SHOW) ;
}
