//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// ColorPreview.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ETBuddiesDlg.h"
#include "ColorPreview.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// ColorPreview

ColorPreview::ColorPreview()
{
	this->m_color = RGB(0,0,0) ;
}

ColorPreview::~ColorPreview()
{
}


BEGIN_MESSAGE_MAP(ColorPreview, CStatic)
	//{{AFX_MSG_MAP(ColorPreview)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ColorPreview message handlers

void ColorPreview::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CRect rect ;	
	CBrush gr1(m_color) ;
	this->GetClientRect(&rect) ;

	CPen pen(PS_SOLID, 1, RGB(0,0,0)) ;
	CPen * old = dc.SelectObject (&pen) ;
	dc.MoveTo (rect.TopLeft()) ;
	dc.LineTo (rect.right, rect.top) ;
	dc.LineTo (rect.BottomRight()) ;
	dc.LineTo (rect.left, rect.bottom) ;
	dc.LineTo (rect.TopLeft()) ;
	dc.SelectObject (old) ;

	rect.DeflateRect(1,1,0,0) ;
	dc.FillRect(&rect, &gr1) ;
	
}


void ColorPreview::SetColor (COLORREF color)
{
	this->m_color = color ;
	this->Invalidate() ;
}
