//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ClientSlaveWolf.h: interface for the ClientSlaveWolf class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CLIENTSLAVEWOLF_H__3A10467A_AC2E_41A0_97E5_78036914576E__INCLUDED_)
#define AFX_CLIENTSLAVEWOLF_H__3A10467A_AC2E_41A0_97E5_78036914576E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ClientSlave.h"

struct DateEnvoi;

class ClientSlaveWolf : public ClientSlave  
{
private:
//	Server * encours;
	vector<DateEnvoi*> listeDates ;

	/************************************************************
	* Met a jour la variable fournie dans les donnees du serveur*
	* Par ex : nomVar = "sv_hostname" et val = Nom du serveur	*
	*		   -> modifie le nom du serveur						*
	************************************************************/
	virtual void processVariable (char * nomVar, char * val, Server * server) ;
public:

	static UINT ID_TIMER ;
	static UINT GAME_PORT;

	ClientSlaveWolf(ClientMaster * maitre);
	virtual ~ClientSlaveWolf();

	/************************************************************
	* Envoie la requete de demande d'infos a ce serveur			*
	************************************************************/
	virtual void connecterServer (Server * server) throw (Exception) ;

	/************************************************************
	* Realise un rafraichissement des informations de ce serveur*
	************************************************************/
	//virtual void litInfos (Server * server) throw (Exception) ;

//	Server * getServerEnCours () {return (this->encours);}

	/************************************************************
	* Traite le paquet entrant									*
	* Leve une exception si le packet est incorrect				*
	************************************************************/
	virtual void traiterPacket (Packet * packet) throw (Exception)  ;

	/************************************************************
	* Verifie si des serveurs sont time-out						*
	************************************************************/
	void checkTimeOut () ;
	



	/************************************************************
	* Traite le prochain argument de la trame					*
	* Renvoie l'adresse de la fin de l'argument					*
	************************************************************/
	BYTE * traiteArg (BYTE * debutArg, Packet * trame) throw (Exception) ;

	// cree le joueur a partir des donnes de la trame
	// renvoie l'adresse de la fin de l'argument
	BYTE * traiteJoueurs (BYTE * debutJoueur, Packet * trame) throw (Exception) ;

};

#endif // !defined(AFX_CLIENTSLAVEWOLF_H__3A10467A_AC2E_41A0_97E5_78036914576E__INCLUDED_)
