//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ClientSlaveWolf.cpp: implementation of the ClientSlaveWolf class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ClientSlaveWolf.h"
#include "defines.h"
#include <process.h>
#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define NEXT_BYTE(trame)	(BYTE)*trame; trame++;

//#define REQUETE				"\377\377\377\377infos\n" 
#define REQUETE_STATUS			"\377\377\377\377getstatus"
#define REQUETE_INFOS			"\377\377\377\377getinfo"


#define REPONSE_INFOS			"\377\377\377\377infoResponse\n"
#define REPONSE_STATUS			"\377\377\377\377statusResponse\n"

/*static*/ UINT ClientSlaveWolf::ID_TIMER = 3 ;
/*static*/ UINT ClientSlaveWolf::GAME_PORT = 27960 ;

/*
void recupInfosSlave (void * clientSlave) ;
void traiteTrameSlave (char * trame, int taille, ClientSlaveWolf * client) throw (Exception) ;
char * traiteArg (char * debutArg, const char * finTrame, ClientSlaveWolf * client) throw (Exception) ; 
char * traiteJoueurs (char * debutJoueur, const char * finTrame, ClientSlaveWolf * client) throw (Exception) ;
*/
#define MAX_ARG		1024

#define NAME		"sv_hostname"
#define PROTOCOL	"protocol"
#define LOAD		"serverload"
#define MAP_NAME	"mapname"
#define CLIENTS		"clients"
#define MAX_CLIENTS	"sv_maxclients"
#define GAME_TYPE	"gametype"
#define PUR			"pure"
#define GAME_TYPEN	"game"
#define FF			"friendlyFire"
#define NEEDPASS	"needpass"

BOOL PeekAndPump()
{
	static MSG msg;

	while (::PeekMessage(&msg,NULL,0,0,PM_NOREMOVE)) {
		if (!AfxGetApp()->PumpMessage()) {
			::PostQuitMessage(0);
			return FALSE;
		}	
	}

	return TRUE;
}


#define ID_SLAVE_TIMER		100

ClientSlaveWolf * client ;


// indique a quel moment la requete a ete lance sur ce serveur
struct DateEnvoi
{
	CString ipServ ;
	DWORD date ;
	DateEnvoi (CString ipServ, DWORD date)		{this->ipServ = ipServ; this->date = date;}
} ;


void CALLBACK onTimer(HWND hwnd, UINT uMsg, UINT idEvent,  DWORD dwTime) ;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ClientSlaveWolf::ClientSlaveWolf(ClientMaster * maitre) : ClientSlave (maitre)
{
//	this->encours = NULL ;
	client = this ;
	this->create (0, SOCK_DGRAM) ;
	SetTimer (AfxGetMainWnd()->m_hWnd, ID_SLAVE_TIMER, MAIN_PREF->getTimeOutSlave() * 1000, onTimer) ;
}

ClientSlaveWolf::~ClientSlaveWolf()
{
	EFFACER_LISTE(DateEnvoi, this->listeDates);
}

/************************************************************
* Envoie la requete de demande d'infos a ce serveur			*
************************************************************/
/*virtual*/ void ClientSlaveWolf::connecterServer (Server * server)
{
	static UINT nbConnec = 0 ;

	nbConnec++;
	if (server == NULL)		throw (Exception ("ClientSlaveWolf::connecterServer() : le server fourni n'est pas valide"));
	int retour ;
/*	retour = this->SendTo (REQUETE_INFOS, sizeof (REQUETE_INFOS), server->getIp()->getPort(), server->getIp()->getIp()) ;
	if (retour == SOCKET_ERROR || !retour)	{
		ERREUR("Erreur socket") ;
	}
*/
	server->raz() ;
	this->listeDates.push_back(new DateEnvoi(server->getIp()->getIpTotal(), GetTickCount()));
	retour = this->SendTo (REQUETE_STATUS, sizeof (REQUETE_STATUS), server->getIp()->getPort(), server->getIp()->getIp()) ;

	if (retour == SOCKET_ERROR || !retour)	
	{
		CString err ;
		CString desc ;
		GET_LAST_ERROR(desc) ;
		err.Format ("ClientSlaveWolf::connecterServer() : Can't connect to %s(%s)", server->getIp()->getIpTotal(), desc) ;
		THROW_E (err) ;
	}

	

}

/************************************************************
* Realise un rafraichissement des informations de ce serveur*
************************************************************/
/*virtual*/ /*void ClientSlaveWolf::litInfos (Server * server) throw (Exception)
{
	if (server == NULL)		throw (Exception ("ClientSlaveWolf::litInfos() : le server fourni n'est pas valide"));
	this->connecterServer (server) ;
}*/

/************************************************************
* Traite le paquet entrant									*
* Leve une exception si le packet est incorrect				*
************************************************************/
/*virtual*/ void ClientSlaveWolf::traiterPacket (Packet * packet)
{
	UINT taille = packet->getLength() ;
		
	BYTE * trame = packet->getPacket() ;
	BYTE * encours = trame ;
	Server * server = this->maitre->getServer(STR_BUFFER(packet->getServeurIp())) ;
	packet->setServer (server) ;

	
	/************************************************************
	* Actualisation du ping et suppression de la liste des		*
	* serveurs en attente										*
	************************************************************/
	UINT ping = 0 ;
	FOR_VECTOR_COND(DateEnvoi*, this->listeDates, ping == 0)
	{
		
		DateEnvoi * d = (*i) ;
		if (strcmp(STR_BUFFER(d->ipServ),STR_BUFFER(packet->getServeurIp())) == 0)
		{
			listeDates.erase (i) ;
			ping = GetTickCount() - d->date ;
			packet->getServer()->setPing(ping) ;
			delete (d) ;
			i--;
		}
	}
	


	/************************************************************
	* Traitement du debut de trame								*
	************************************************************/
	char reponse[MAX_ARG_SIZE] ;
	char * repv = reponse ;
	while (packet->estDansTrame(encours) && *encours != '\\')	
	{
		*repv = *encours ;
		encours++;
		repv++;
	}
	encours++ ;
	*repv = '\0' ;


	/************************************************************
	* Test de l'entete du debut de trame						*
	************************************************************/
	if (strcmp (reponse, REPONSE_STATUS) != 0 && strcmp (reponse, REPONSE_INFOS) != 0)
	{
		CString msg ;
		msg.Format ("ClientSlaveWolf::traiterPacket() : en-tete de trame incorrecte\nEn-tete recue : %s", reponse) ;
		THROW_E(CString(msg));
	}


	/************************************************************
	* Lecture des parametres du serveur (nom, ping,...)			*
	************************************************************/
	while (packet->estDansTrame(encours) && *encours != '\n')
	{
		encours = traiteArg (encours, packet) ;
	}

	
	/************************************************************
	* Lecture des joueurs et de leur xp si present dans			*
	* la trame													*
	************************************************************/
	while (packet->estDansTrame(encours))
	{
	
		if (*encours == '\n')		encours++;
		encours = traiteJoueurs (encours, packet) ;
	}


/*	if (ping != 0) {
		this->maitre->getServer (STR_BUFFER(packet->getServeur()))->setPing (ping) ;
	}*/

	/************************************************************
	* On indique au serveur maitre qu'on a recu toutes les		*
	* infos de ce serveur										*
	************************************************************/
	if (strcmp (reponse, REPONSE_STATUS) == 0) {
		this->maitre->rechercheFinie (packet->getServer()) ;
	}


	
	/*	else if (GetTickCount() - d->date > MAIN_PREF->getTimeOutSlave() * 1000)
		{
			listeDates.erase (i) ;
			this->maitre->rechercheFinie (d->ipServ) ;
			delete (d) ;
			i--;
		}*/
	//}

	Socket::traiterPacket(packet) ;
}

/************************************************************
* Verifie si des serveurs sont time-out						*
************************************************************/
void ClientSlaveWolf::checkTimeOut ()
{
	FOR_VECTOR(DateEnvoi*, this->listeDates)
	{
		DateEnvoi * d = (*i) ;
		if (GetTickCount() - d->date > MAIN_PREF->getTimeOutSlave() * 1000)
		{
			listeDates.erase (i) ;
			this->maitre->rechercheFinie (NULL) ;
			delete (d) ;
			i--;
		}
	}
}

/************************************************************
* Met a jour la variable fournie dans les donnees du serveur*
************************************************************/
/*virtual*/ void ClientSlaveWolf::processVariable (char * nomVar, char * val, Server * server)
{
	if (!server)	return ;
	//ASSERT(server);

	ClientSlave::processVariable (nomVar, val, server) ;
}


/************************************************************
* Traite le prochain argument de la trame					*
* Renvoie l'adresse de la fin de l'argument					*
************************************************************/
BYTE * ClientSlaveWolf::traiteArg (BYTE * debutArg, Packet * trame) throw (Exception)
{
	char arg[MAX_ARG_SIZE] ;
	char nomParam[MAX_ARG_SIZE] = "" ;

	char * argv = arg ;
	char * nomParamv = nomParam ;

	BYTE * encours = debutArg ;

	/************************************************************
	* Lecture du nom de la variable								*
	************************************************************/
	while (trame->estDansTrame(encours) && *encours != '\\')
	{
		*argv = NEXT_BYTE(encours) ;
		argv++;
	}
	encours++;
	*argv = '\0' ;
	
	strcpy (nomParam, arg) ;
	argv = arg ;
	
	/************************************************************
	* Lecture du contenu de la variable							*
	************************************************************/
	while (trame->estDansTrame (encours) && *encours != '\\' && *encours != '\n')
	{
		*argv = NEXT_BYTE(encours) ;
		argv++ ;
	}
	if (*encours != '\n')		encours++;
	*argv = '\0' ;
	
	processVariable (nomParam, arg, trame->getServer()) ;
	
	return (encours);
	
}

/************************************************************
* Cree le joueur a partir des donnes de la trame			*
* Renvoie l'adresse de la fin de l'argument					*
************************************************************/
BYTE * ClientSlaveWolf::traiteJoueurs (BYTE * debutjoueur, Packet * trame) throw (Exception)
{
	UINT xp = 0 ;
	UINT ping = 0 ;
	char nomJoueur[MAX_ARG_SIZE] ;
	char * nomv = nomJoueur ;

	BYTE * encours = debutjoueur ;

	/************************************************************
	* Recuperation de l'XP du joueur							*
	************************************************************/
	while (trame->estDansTrame (encours) && *encours != '\n' && *encours != ' ')
	{
		xp *= 10 ;
		xp += *encours - '0' ;
		encours++;
	}

	/************************************************************
	* Recuperation du png du joueur							*
	************************************************************/
	if (*encours == ' ')		encours++;
	while (trame->estDansTrame (encours) && *encours != '\n' && *encours != ' ')
	{
		ping *= 10 ;
		ping += *encours - '0' ;
		encours++;
	}

	/************************************************************
	* Recuperation du nom du joueur								*
	************************************************************/
	if (*encours == ' ')		encours++;
	while (trame->estDansTrame (encours) && *encours != '\n')
	{
		// on ignore la couleur
	/*	if (*encours == '^' &&
			*(encours + 1) != '^' &&
			*(encours + 1) != '\n')
		{
			encours++ ;
		}
		else if (*encours != '\"') {
			*nomv = *encours ;
			nomv++;
		}*/
		if (*encours != '\"') 
		{
			*nomv = *encours;
			nomv++;
		}
		encours++;
		
		
	}
	*nomv = '\0' ;
	/************************************************************
	* Tout est ok, on ajoute le joueur sur le serveur			*
	* correspondant a cette trame								*
	************************************************************/
	if (trame->estDansTrame (encours))
	{
		Server * aModifier = trame->getServer() ;
		if (aModifier) {
			aModifier->ajouterJoueur (new Joueur(nomJoueur, xp, ping, aModifier)) ;
		}
	}

	return (encours) ;

}

void CALLBACK onTimer (HWND hwnd, UINT uMsg, UINT idEvent,  DWORD dwTime)
{
	if (idEvent == ID_SLAVE_TIMER) {
		client->checkTimeOut () ;
	}
}
 