//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ClientSlave.h: interface for the ClientSlave class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CLIENTSLAVE_H__AB5D746F_2841_44FC_ABB8_480DCCC827A9__INCLUDED_)
#define AFX_CLIENTSLAVE_H__AB5D746F_2841_44FC_ABB8_480DCCC827A9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Client.h"
#include "ClientMaster.h"
#include "Exception.h"

#define MAX_ARG_SIZE		256


class ClientSlave : public Client  
{
protected:
	ClientMaster * maitre ;
	
	/************************************************************
	* Met a jour la variable fournie dans les donnees du serveur*
	* Par ex : nomVar = "sv_hostname" et val = Nom du serveur	*
	*		   -> modifie le nom du serveur						*
	************************************************************/
	virtual void processVariable (char * nomVar, char * val, Server * server) ;
public:
	ClientSlave(ClientMaster * maitre) throw (Exception) ;
	virtual ~ClientSlave();

	virtual void connecterServer (Server * server)  throw (Exception) = 0 ;
//	virtual void litInfos (Server * server) throw (Exception) = 0 ;

	// indique au clientMaster de passer au server suivant
	//void passerClientSuivant () ;

	// retourne le serveur maitre
	ClientMaster * getServerMaitre () {return (this->maitre);}

	

//	void initTimeOut (UINT idTimer) ;

};

#endif // !defined(AFX_CLIENTSLAVE_H__AB5D746F_2841_44FC_ABB8_480DCCC827A9__INCLUDED_)
