//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ClientMasterWolf.cpp: implementation of the ClientMasterWolf class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ClientMasterWolf.h"
#include "ClientSlaveWolf.h"
#include <process.h>
#include "ETBuddiesDlg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/*static*/ UINT ClientMasterWolf::GAME_WOLF = 1 ;
/*static*/ UINT ClientMasterWolf::GAME_ET = 2;
/*static*/ UINT ClientMasterWolf::ID_TIMER = 2 ;

#define AFX_SOCK_THREAD_STATE AFX_MODULE_THREAD_STATE


#define ET_SERVER		MAIN_PREF->getServeurMaitre()
#define WOLF_SERVER		"wolfmaster.idsoftware.com"
#define PROTO_ET		MAIN_PREF->getProtocole()
#define PROTO_WOLF		67

#define MAX_BUFF		4096	

// the "%d" will receive protocol
#define REQUETE			"\377\377\377\377getservers %d full demo\n"
#define MASTER_REPONSE	"\377\377\377\377getserversResponse"
#define PORT			27950
#define GAME_PORT		27960

#define NEXT_BYTE(trame)	(BYTE)*trame; trame++;

// clientMaster doit etre de type ClientMasterWolf
/*void recupInfos (void * clientMaster) ;
void traiteTrame (char * trame, int taille, ClientMasterWolf * client) throw (Exception) ;*/




//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ClientMasterWolf::ClientMasterWolf(UINT gameType)
{
	if (gameType != GAME_WOLF && gameType != GAME_ET)
	{
		CString e ;
		e.Format ("ClientMasterWolf::ClientMasterWolf() : type de jeu incorrect(%d)", gameType) ;
		throw (Exception (CString(e))) ;
	}
	this->gameType = gameType ;
	this->create (0, SOCK_DGRAM) ;
	this->clientSlave = new ClientSlaveWolf (this) ;


	if (gameType == GAME_WOLF){
		this->serveur = WOLF_SERVER ;
		this->protocole = PROTO_WOLF ;
	}
	else{
		this->serveur = ET_SERVER ;
		this->protocole = PROTO_ET ;
	}

	this->trameEnCours = false ;
	
	
	
}

ClientMasterWolf::~ClientMasterWolf()
{
}


// se connecte au server approprie
void ClientMasterWolf::connecter () 
{

	CString requete ;
	requete.Format (REQUETE, this->protocole) ;
	if (this->SendTo (STR_BUFFER(requete), requete.GetLength(), PORT, this->serveur) == SOCKET_ERROR)
	{
		CString err ;
		err.Format ("Socket::connecter() : can't connect to %s\nDescription", this->serveur) ;
		ERREUR(err) ;
	}

	requete.ReleaseBuffer () ;
	
	
}

// lit les infos sur le server et les stock dans la liste de Server* fournie en parametre
/*virtual*/ void ClientMasterWolf::litInfos (/*vector<Server*> * listeServ*/)
{
	ClientMaster::litInfos() ;
	this->connecter () ; 	
}


/*virtual*/ void ClientMasterWolf::OnReceive (int nErrorCode )
{
	Socket::OnReceive(nErrorCode) ;
}



// traite le paquet entrant provenant d'un serveur maitre de type WOLF ou ET
// leve une exception si le packet est incorrect
/*virtual*/ void ClientMasterWolf::traiterPacket (Packet * packet) throw (Exception)
{


	trameEnCours = true ;


	BYTE * trame = packet->getPacket() ;
	BYTE * encours = trame ;
	UINT taille = packet->getLength() ;


	


	/************************************************************
	* Traitement du debut de trame								*
	************************************************************/
	CString reponse = "" ;
	while (*encours != '\\')	
	{
		reponse += *encours ;
		encours++;
	}
	encours++ ;

	
	/************************************************************
	* Test de l'entete du debut de trame						*
	************************************************************/
	if (reponse != MASTER_REPONSE)		THROW_E("ClientMasterWolf::traiterPacket() : en-tete de trame incorrecte");


	
	/************************************************************
	* Recuperations des donnes de tous les serveurs presents	*
	* sur la trame												*
	************************************************************/
	
	// tant qu'il reste des donnees a lire faire
	while (encours < trame + taille - 3)
	{
		/************************************************************
		* Recuperation de l'ip du serveur en cours sur la trame		*
		************************************************************/
		BYTE ip[4] ;
		BYTE port[2] = {0,0} ;
		bool suivant = false ;
		for (int i = 0 ; i < 4 ; i++)
		{
			ip[i] = NEXT_BYTE(encours) ;
		}
		
		/************************************************************
		* Recuperation du port du serveur en cours sur la trame		*
		************************************************************/
		port[0] = 0 ;
		if (!suivant)
		{
			if (*encours != '\\')
			{
				port[0] = NEXT_BYTE(encours);
				port[1] = NEXT_BYTE(encours);
			}

			if (!suivant)
			{
				if (*encours != '\\')
					throw (Exception ("ClientMasterWolf::traiterPacket() : Trame du serveur maitre incorrecte")) ;
			}
		}
		/************************************************************
		* Mise en forme de l'adresse IP								*
		************************************************************/
		UINT portComplet = GAME_PORT ;
		if (port[0])
		{
		//	if (port[1] == '\\')	port[1] = 0 ;
			portComplet = (port[0] << 8) + port[1] ;
		}
		Ip * pIp = new Ip(ip[0],ip[1],ip[2],ip[3],portComplet) ;
		
		/************************************************************
		* Ajout du serveur dans la liste							*
		************************************************************/
		Server * serv = new Server (pIp, this) ;
		this->ajouterServeur (serv) ;


		/************************************************************
		* On passe les caracteres '\' restants						*
		************************************************************/
		while (packet->estDansTrame(encours) && *encours == '\\')		encours++;
	}


	trameEnCours = false ;
	Socket::traiterPacket(packet) ;
}



/*
void recupInfos (void * client)
{
	INIT_SOCKET_THREAD;

	ClientMasterWolf * clientM = (ClientMasterWolf *) client ;
	
	int nb = 0 ;
	char buffer[4096] ;
	CString data = "" ;
	CString message = "" ;
	
	HWND hwnd = AfxGetMainWnd()->m_hWnd ;

	
	try
	{
		do
		{
			// traitement d'une trame
		//	clientM->initTimeOut (ClientMasterWolf::ID_TIMER) ;
			nb = clientM->receive (buffer, sizeof(buffer)) ;
			try
			{
				traiteTrame (buffer, nb, clientM) ;
			}
			CATCH_EXCEPTION;

		//	clientM->stopTimeOut (ClientMasterWolf::ID_TIMER) ;

		}	while (!clientM->getTimeOut() && nb > 0) ;

	}
	CATCH_EXCEPTION_NO_MSG;
//	MessageBox (hwnd, message, "", MB_OK) ;
	
	//	MessageBox (AfxGetMainWnd()->m_hWnd, message, "", MB_OK) ;
	clientM->close () ;	
	clientM->setTimeOut (false) ;
	
	try
	{
		clientM->refreshInfosServers () ;
	}
	CATCH_EXCEPTION;

	_endthread() ;

}	*/
/*
void traiteTrame (char * trame, int taille, ClientMasterWolf * client)
{
	if (taille <= 0)		return ;

	char * encours = trame ;
	// on passe le getserversResponse
	while (*encours != '\\')	encours++;
	encours++ ;

	vector<Server*> * liste = client->getListeServeurs () ;

	Server * serv ;
	while (encours < trame + taille - 3)
	{
		BYTE ip[4] ;
		BYTE port[2] = {0,0} ;
		bool suivant = false ;
		for (int i = 0 ; i < 4 ; i++)
		{
			ip[i] = NEXT_BYTE(encours) ;
			if (ip[i] == '\\')	suivant = true ;
		}
		
		if (!suivant)
		{
			if (*encours != '\\')
			{
				port[0] = NEXT_BYTE(encours);
				port[1] = NEXT_BYTE(encours);
				if (port[1] == '\\')	suivant = true;
			}

			if (!suivant)
			{
				if (*encours != '\\')
					encours++;
			
				if (*encours != '\\')
					throw (Exception ("Trame incorrecte")) ;
			}
			// tout est ok, ajout du server a la liste
			serv = new Server (new Ip(ip[0],ip[1],ip[2],ip[3],(port[0] << 8) + port[1])) ;
			liste->push_back (serv) ;
		}

	}

}*/