//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ClientMaster.h: interface for the ClientMaster class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CLIENTMASTER_H__D9C35BF2_6AE6_4D28_B5C2_D3EAF4A12CB6__INCLUDED_)
#define AFX_CLIENTMASTER_H__D9C35BF2_6AE6_4D28_B5C2_D3EAF4A12CB6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Client.h"
#include "Server.h"
//#include "ClientSlave.h"
#include "Exception.h"
#include <vector>
#include <stack>
#include "Objet.h"
#include <set>

using namespace std ;

class ClientSlave ;

class ClientMaster : public Client
{
	
private:


	map<CString,Server*> listeServers ;

	// liste des serveurs n'ayant pas encore t traits
	stack<Server*> listeATraiter ;
//	ClientSlave * dernierClient ;


	

	// numero du server en cours de refresh
	UINT numServer  ;

	// liste des sockets effectuant la recherche des infos server
	//vector<ClientSlave*> listeClients ;

	// indique si une recherche sur les slave est deja en cours
	bool rechercheEnCours ;

	// nombre de slave en train de rechercher les infos
	UINT nbSlaves ;

	// indice de depart des XProchainsServeurs
	UINT indiceDepart ;

	// indique le nombre de serveurs ayant finis d'etre rafraichir
	UINT nbFinis ;

	UINT etat ;

	// nombre de serveurs invalides
	UINT nbInvalides ;

	

protected:
	// recupere les infos de ce serveur
	// renvoie le client s'occupant de ce serveur
//	virtual ClientSlave * traiterServeur (Server * server) throw (Exception) = 0 ;

	ClientSlave * clientSlave ;

public:

	// indique que tous les servers ont t effacs
	static UINT ON_SERVER_DELETE ;
	// indique que le refresh a t complet (tous les serveurs ont t reinitialiss)
	static UINT	ON_REFRESH_COMPLETE ;
	// le refresh n'a pas mis a jour la liste des serveurs
	static UINT ON_REFRESH_PARTIEL ;
	// indique qu'un server vient d'etre mis a jour
	// param1 = Server* -> server venant d'etre MAJ
	static UINT ON_REFRESH_UN_SERVER ;
	// indique qu'un joueur va etre effac
	// param1 = Joueur* -> joueur allant etre effac
	static UINT ON_JOUEUR_DELETE ;


	ClientMaster();
	virtual ~ClientMaster();

	map<CString, Server*> * getListeServeurs () {return (&listeServers);}

	// lit les infos sur le server et les stock dans la liste de Server* fournie en parametre
	virtual void litInfos (/*vector<Server*> * listeServ*/) throw (Exception) ;

	// effectue la deuxieme passe
	void passeSuivante () ;

	

	/********************************************************************
	* recherche les differents serveurs sur lesquels se trouve le		*
	* joueur possedant ce nom 											*
	* ATTENTION :	Il faut liberer apres traitement la place occupe	*
	*				par la liste retourne !!							*
	********************************************************************/
	vector<Server*> * rechercherIp (CString nomJoueur) ;

	/********************************************************************
	* Stoppe la recherche des serveurs									*
	********************************************************************/
	void stopperRecherche () ;

	// retourne le serveur possedant cette ip
	Server * getServer (char * ip) ;

	// indique a ce server maitre qu'un server a t actualis
	void rechercheFinie (Server * server) ;



	// traite le serveur suivant dans la liste des serveurs a traiter
	void traiteServeurSuivant () ;

	// ajoute le server a la liste temporaire
	void ajouterServeur (Server * serveur) ;

	/********************************************************************
	* Met a jour les infos de ce serveur								*
	********************************************************************/
	void rafraichirServeur (Server * serveur) ;

	

	// Returns all different values of this parameter
	set<CString> getValues(CString variable) ;

	set<CString> getVariables() ;


};

#endif // !defined(AFX_CLIENTMASTER_H__D9C35BF2_6AE6_4D28_B5C2_D3EAF4A12CB6__INCLUDED_)
