//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ClientMaster.cpp: implementation of the ClientMaster class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ClientMaster.h"
#include "defines.h"
#include "ClientSlave.h"
#include "ClientSlaveWolf.h"
#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// nombre maximu de connections simultanes
#define MAX_CONNEC_SIMUL		MAIN_PREF->getNbSearchSimul()

// indique que tous les servers ont t effacs
/*static*/ UINT ClientMaster::ON_SERVER_DELETE = 9 ;
// indique que le refresh a t complet (tous les serveurs ont t reinitialiss)
/*static*/ UINT	ClientMaster::ON_REFRESH_COMPLETE = 10 ;
// le refresh n'a pas mis a jour la liste des serveurs
/*static*/ UINT ClientMaster::ON_REFRESH_PARTIEL = 11 ;
// indique qu'un server vient d'etre mis a jour
// param1 = Server* -> server venant d'etre MAJ
/*static*/ UINT ClientMaster::ON_REFRESH_UN_SERVER = 105 ;
// indique qu'un joueur va etre effac
// param1 = Joueur* -> joueur allant etre effac
/*static*/ UINT ClientMaster::ON_JOUEUR_DELETE = 106 ;


#define EFFACER_SERVEURS \
	Server * aSuppr ;\
	while (!this->listeServers.empty())\
	{\
		aSuppr = this->listeServers.begin()->second ;\
		this->listeServers.erase (this->listeServers.begin()) ;\
		delete (aSuppr) ;\
	}


#define NB_PASSES		MAIN_PREF->getNbPasses()

#define ARRETE			0
#define PASSE(n)		(n)
#define END_PASSE		PASSE(NB_PASSES)

/*#define PREMIERE_PASSE	1
#define DEUXIEME_PASSE	2*/

static UINT nbPrem = 0 ;

static DWORD tempsDepart = 0 ;

typedef map<CString,Server*> STR2SERVER ;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ClientMaster::ClientMaster() 
{
	this->numServer = 0 ;
	this->rechercheEnCours = false ;
	this->nbSlaves = 0 ;
	this->indiceDepart = 0 ;
	this->clientSlave = NULL ;

	this->nbFinis = 0 ;
	this->etat = ARRETE ;
}

ClientMaster::~ClientMaster()
{
	if (this->clientSlave)		delete (this->clientSlave) ;

	EFFACER_SERVEURS;

}


/********************************************************************
* Ajoute le serveur a la liste des serveurs et le traite			*
********************************************************************/
void ClientMaster::ajouterServeur (Server * serveur)
{
	if (!serveur)		return ;
	ASSERT(serveur) ;

	if (listeServers.find (serveur->getIp()->getIpTotal()) != listeServers.end()) {
		delete (serveur) ;
	}
	else
	{
		this->listeServers.insert(STR2SERVER::value_type(serveur->getIp()->getIpTotal(), serveur)) ;
		this->listeATraiter.push (serveur) ;
	}

	/****************************************************************
	* s'il n'y a pas assez de connections, on en cree				*
	****************************************************************/
	while (!listeATraiter.empty() && this->nbSlaves < MAX_CONNEC_SIMUL) {
		this->traiteServeurSuivant () ;
	}

}

/********************************************************************
* traite le serveur suivant dans la liste des serveurs a traiter	*
********************************************************************/
void ClientMaster::traiteServeurSuivant ()
{
	if (listeATraiter.empty())			return ;

	Server * aTraiter = this->listeATraiter.top () ;
	this->listeATraiter.pop() ;

//	SetDlgItemInt (AfxGetMainWnd()->m_hWnd, IDC_TEST, listeATraiter.size(), FALSE) ;
	

	this->rafraichirServeur (aTraiter) ;

	if (rechercheEnCours)
		this->nbSlaves++;
}

/********************************************************************
* Met a jour entierement les serveurs								*
* Se connecte au server maitre pour recuperer la liste des serveurs,*
* puis actualise les infos des serveurs								*
********************************************************************/
/*virtual*/ void ClientMaster::litInfos () throw (Exception)
{

//	AfxGetApp()->SetThreadPriority(THREAD_PRIORITY_BELOW_NORMAL) ;
	if (this->rechercheEnCours)	return ;

	this->notifierObs (ClientMaster::ON_SERVER_DELETE) ;
	EFFACER_SERVEURS;

	while (!this->listeATraiter.empty()) {
		this->listeATraiter.pop ();
	}

	this->nbFinis = 0 ;
	this->rechercheEnCours = true ;
	tempsDepart = GetTickCount () ;
	this->etat = PASSE(1) ;
	
}

/********************************************************************
* Indique au serveur maitre qu'un serveur vient d'etre rafraichi	*
********************************************************************/
void ClientMaster::rechercheFinie (Server * server)
{
	if (this->etat == ARRETE) {
		this->notifierObs(ON_REFRESH_UN_SERVER, (void*)server) ;
	}
	if (!rechercheEnCours)		return ;
	

	this->nbSlaves-- ;
	ASSERT(nbSlaves < MAX_CONNEC_SIMUL) ;
	this->nbFinis++ ;

//	SetDlgItemInt (MAIN_DLG->m_hWnd, IDC_TEST2, (GetTickCount() - tempsDepart)/1000, TRUE) ;


	while (!listeATraiter.empty() && this->nbSlaves < MAX_CONNEC_SIMUL) {
		this->traiteServeurSuivant () ;
	}

	UINT nbVides = 0 ;
	

	
	UINT total = listeServers.size() ;
	if (this->listeATraiter.size() == 0 && this->nbSlaves == 0)
	{
		
		if (this->etat == END_PASSE) {
			this->stopperRecherche () ;
		}
		else
		{
			//ASSERT (etat == PREMIERE_PASSE) ;
			this->notifierObs (ON_REFRESH_COMPLETE) ;
			if (this->etat != ARRETE) {
				this->passeSuivante () ;
			}
		}
		//AfxGetApp()->SetThreadPriority(THREAD_PRIORITY_NORMAL) ;
	}
	else
	{
		switch (etat)
		{
		case PASSE(1): 
			this->notifierObs (ON_REFRESH_PARTIEL, &this->nbFinis, &total) ;
			break ;
		case ARRETE:
			break ;
		default:
			this->notifierObs (ON_REFRESH_PARTIEL, &this->nbFinis, &nbInvalides) ;
			break ;
		}
	}

}

void ClientMaster::passeSuivante ()
{
	ASSERT(this->etat != END_PASSE && this->etat != ARRETE);
	if (this->etat == END_PASSE || this->etat == ARRETE) {
		return;
	}
	
	this->etat += 1 ;
	this->nbFinis = 0 ;
	this->nbInvalides = 0 ;
	/*************************************************
	* On essaye de nouveau tous les serveurs qui ont *
	* t perdus a la premiere passe				 *
	*************************************************/
	FOR_MAP(CString, Server*,this->listeServers)
	{
		if (!i->second->estValide()) {
			this->listeATraiter.push (i->second) ;
			nbInvalides++;
		}
	}

	/****************************************************************
	* s'il n'y a pas assez de connections, on en cree				*
	****************************************************************/
	while (!listeATraiter.empty() && this->nbSlaves < MAX_CONNEC_SIMUL) {
		this->traiteServeurSuivant () ;
	}

}


/********************************************************************
* recherche les differents serveurs sur lesquels se trouve le		*
* joueur possedant ce nom 											*
* ATTENTION :	Il faut liberer apres traitement la place occupe	*
*				par la liste retourne !!							*
********************************************************************/
vector<Server*> * ClientMaster::rechercherIp (CString nomJoueur)
{
	vector<Server*> * retour = NULL ;

	FOR_MAP(CString, Server*, this->listeServers)
	{
		if (i->second->estSurCeServeur (nomJoueur).size() > 0) 
		{
			if (!retour)		retour = new vector<Server*> ;
			retour->push_back(i->second) ;
		}
	}

	return (retour) ;
}

/********************************************************************
* Retourne le serveur possedant cette ip							*
********************************************************************/
Server * ClientMaster::getServer (char * ip)
{
	Server * retour = NULL ;
	MAP_ITER(CString, Server *, i);
	i = this->listeServers.find (ip) ;
	if (i != this->listeServers.end())	{
		retour = i->second ;
	}

/*	FOR_VECTOR_COND(Server*, this->listeServers, retour == NULL)
	{
		if (strcmp (STR_BUFFER((*i)->getIp()->getIpTotal()),ip) == 0) {
			retour = *i ;
		}
	}*/


	return (retour) ;
}

/********************************************************************
* Stoppe la recherche des serveurs									*
********************************************************************/
void ClientMaster::stopperRecherche ()
{
	while (!this->listeATraiter.empty()) {
		this->listeATraiter.pop ();
	}
	this->rechercheEnCours = false ;
	this->etat = ARRETE ;
	this->nbSlaves = 0 ;

	this->notifierObs (ON_REFRESH_COMPLETE) ;
}

/********************************************************************
* Met a jour les infos de ce serveur								*
********************************************************************/
void ClientMaster::rafraichirServeur (Server * serveur)
{
	if (this->clientSlave != NULL && serveur != NULL)
	{
		try {
			this->clientSlave->connecterServer (serveur);
		}
		CATCH_LOG ;
	}
}




/*
void ClientMaster::initTimeOut (UINT idTimer)
{
	Client::initTimeOut (idTimer, MAIN_DLG->getPref()->getTimeOutMaitre()) ;
}*/

// Returns all different values of this parameter
set<CString> ClientMaster::getValues(CString key) {

	set<CString> retour ;

	map<CString, Server*> * servers = getListeServeurs() ;
	map<CString,Server*>::iterator j ;
	for (j = servers->begin() ; j != servers->end() ; j++) {
		Server* serv = j->second ;
		CString m = serv->getVariable(key) ;
		m.MakeLower() ;
		if (m.Compare("") != 0) {
			retour.insert(m) ;
		}
	}

	return (retour) ;
}

set<CString> ClientMaster::getVariables() {

	set<CString> retour ;

	map<CString, Server*> * servers = getListeServeurs() ;
	map<CString,Server*>::iterator j ;
	for (j = servers->begin() ; j != servers->end() ; j++) {
		Server* serv = j->second ;
		map<CString, CString> * variables = serv->getVariables() ;

		map<CString, CString>::iterator i ;
		for (i = variables->begin() ; i != variables->end() ; i++) {
			CString v = i->first ;
			v.MakeLower() ;
			if (v.Compare("") != 0) {
				retour.insert(v) ;
			}
		}

	
	}

	return (retour) ;
}