//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ChargerSauverDlg.cpp: implementation of the ChargerSauverDlg class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ChargerSauverDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define TAILLE_NOM		256

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ChargerSauverDlg::ChargerSauverDlg()
{
	this->fic = new char[TAILLE_NOM] ;
	this->fic[0] = '\0' ;
}

ChargerSauverDlg::~ChargerSauverDlg()
{
	delete (this->fic) ;
}


bool ChargerSauverDlg::getFile (bool sauver, CString initialDir /*= ".\\"*/, char * filter /*= "All files (*.*)\0*.*\0\0"*/)
{
	OPENFILENAME ofn ;
	bool retour = false ;

	memset (&ofn, 0, sizeof (OPENFILENAME)) ;
	ofn.lStructSize  = sizeof (OPENFILENAME) ;
	ofn.lpstrFilter = filter ;
	ofn.lpstrFile = this->fic ;
	ofn.nMaxFile = TAILLE_NOM ;
	ofn.lpstrInitialDir = initialDir ;
	if (sauver)	{
		ofn.lpstrTitle = "Sauvegarder" ;
	}
	else {
		ofn.lpstrTitle = "Charger" ;
	}
	ofn.Flags = OFN_EXPLORER /*| OFN_NOREADONLYRETURN*/ | OFN_OVERWRITEPROMPT ;

	
	if (sauver)
	{
		retour = GetSaveFileName (&ofn) == TRUE ;
	}
	else
	{
		ofn.Flags |= OFN_FILEMUSTEXIST ;
		retour = GetOpenFileName (&ofn) == TRUE ;
	}
	return (retour) ;
}

bool ChargerSauverDlg::getSaveFile (CString * dir, CString initialDir /*= ".\\"*/, char * filter /*= "All files (*.*)\0*.*\0\0"*/)
{
	bool retour = this->getFile (true, initialDir, filter) ;

	if (retour)	{
		*dir = this->fic ;
	}

	return (retour) ;
}

bool ChargerSauverDlg::getLoadFile (CString * dir, CString initialDir /*= ".\\"*/, char * filter /*= "All files (*.*)\0*.*\0\0"*/)
{
	bool retour = this->getFile(false, initialDir, filter) ;
	if (retour)	{
		*dir = this->fic ;
	}

	return (retour) ;
}
