//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// BuddyJoueurImage.cpp: implementation of the BuddyJoueurImage class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "BuddyJoueurImage.h"
#include "EtBuddiesDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


/*static*/ UINT BuddyJoueurImage::ON_CONNECT		= 102 ;
/*static*/ UINT BuddyJoueurImage::ON_MENU_JOUEUR	= 108 ;

BuddyJoueurImage::BuddyJoueurImage(CString nom, Buddie * bud, Joueur * joueur, Image * online) : BuddyImage (nom, bud)
{
	this->joueur = joueur ;
	this->online = online ;
}

BuddyJoueurImage::~BuddyJoueurImage()
{

}


// affiche la premiere ligne de texte
/*virtual*/ void BuddyJoueurImage::afficherLigne1 (/*Police * police,*/ CDC * dc, CRect rect/*, int numPolice*/)
{
	if (this->joueur == NULL) {
		DEBUG_LOG("BuddyJoueurImage::afficherLigne1 () : le joueur n'existe pas");
		return ;
	}

	CString nom ;
	nom.Format ("%s^0 : %d XP / Ping : %dms", joueur->getNomColore(), joueur->getXp(), joueur->getPing()) ;
	BuddyImage::afficherLigne1 (/*police,*/ dc, rect, nom/*, numPolice*/) ;
}

// affiche la deuxieme ligne de texte
/*virtual*/ void BuddyJoueurImage::afficherLigne2 (/*Police * police,*/ CDC * dc, CRect rect/*, int numPolice*/)
{
	if (this->joueur == NULL || this->joueur->getServeur() == NULL) {
		DEBUG_LOG("BuddyJoueurImage::afficherLigne2 () : le joueur n'existe pas");
		return ;
	}

	CString serveur ;
	serveur.Format ("Online : %s", this->joueur->getServeur()->getNomColore()) ;
	BuddyImage::afficherLigne2 (/*police,*/ dc, rect, online, serveur/*, 0*/) ;
}


// indique a l'image que l'utilisateur a double-clique a cette position
// retourne TRUE si la souris se trouve sur l'image
/*virtual*/ BOOL BuddyJoueurImage::OnLButtonDblClk (CPoint pSouris)
{
	BOOL retour = Image::OnLButtonDblClk (pSouris) ;
	if (retour)	{		
		this->notifierObs (ON_CONNECT, this->joueur->getServeur()) ;
	}
	return (retour) ;
}

/*virtual*/ BOOL BuddyJoueurImage::OnRButtonUp (CPoint pSouris)
{
	BOOL retour = Image::OnRButtonUp(pSouris) ;
	if (retour) {
		this->notifierObs (ON_MENU_JOUEUR, this->joueur, &pSouris) ;
	}

	return (retour) ;
}