//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// BuddyImage.h: interface for the BuddyImage class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BUDDYIMAGE_H__F71D45C8_AAFE_4C36_989A_7F3F9E65B0F9__INCLUDED_)
#define AFX_BUDDYIMAGE_H__F71D45C8_AAFE_4C36_989A_7F3F9E65B0F9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Image.h"
#include "Buddie.h"
#include "BoutonImage.h"

#define NB_IMAGES_BUD		3

class BuddyImage : public BoutonImage  
{
private:
	CPoint taille ;

	bool estSelect ;

	// indique si ce buddy est visible sur le skin
	bool visible ;

protected:
	Buddie * buddy ;
	
public:

	static UINT ON_INFO_BUDDY ;
	static UINT ON_MENU_BUDDY ;

	// construit la base de l'image Buddy
	BuddyImage(CString image, Buddie * bud) ;
	//BuddyImage (CString left) ;
	virtual ~BuddyImage();

	// indique a l'image que l'utilisateur a boug la souris
	// retourne TRUE si la souris se trouve sur l'image
	virtual BOOL OnMouseMove (CPoint pSouris) ;

	/*// indique a l'image que l'utilisateur a double-clique a cette position
	// retourne TRUE si la souris se trouve sur l'image
	virtual BOOL OnLButtonDblClk (CPoint pSouris) ;*/

	// indique a l'image que l'utilisateur a clique a cette position
	virtual BOOL OnLButtonDown (CPoint pSouris) ;

	// indique a l'image que l'utilisateur a clique a cette position
	virtual BOOL OnLButtonUp (CPoint pSouris) ;

	virtual BOOL OnRButtonUp (CPoint pSouris) ;

	// affiche le buddy a la position (x,y)
	// et au dimensions cx, cy
	// leve une Exception en cas d'erreur d'affichage
	virtual void afficher (CDC * dc, int x, int y, int cx, int cy = 0) throw (Exception) ;

	// affiche la premiere ligne de texte
	virtual void afficherLigne1 (/*Police * police, */CDC * dc, CRect rect, CString texte/*, int numPolice*/) throw (Exception) ;

	// affiche la deuxieme ligne de texte
	virtual void afficherLigne2 (/*Police * police, */CDC * dc, CRect rect, Image * online, CString texte/*, int numPolice*/) throw (Exception) ;


	// retourne la taille de l'image
	virtual CPoint getSize (CDC * dc) ;

	// retourne le buddy associe a cette image
	Buddie * getBuddy () {return (this->buddy);}

	bool estVisible ()	{return (this->visible);}
	void setVisible (bool visible = true) {this->visible = visible;}

};

#endif // !defined(AFX_BUDDYIMAGE_H__F71D45C8_AAFE_4C36_989A_7F3F9E65B0F9__INCLUDED_)
