//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// BuddyImage.cpp: implementation of the BuddyImage class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "BuddyImage.h"
#include "TexteColore.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define LEFT		0
#define CENTRE		1
#define RIGHT		2

/*static*/ UINT BuddyImage::ON_INFO_BUDDY = 6 ;
/*static*/ UINT BuddyImage::ON_MENU_BUDDY = 107 ;

enum	{BUDDY_LEFT, BUDDY_CENTRE, BUDDY_RIGHT, FIN} ;

static Partie listeParties[] = {	Partie (BUDDY_LEFT,		CRect(0,	0,	16,	34)),
									Partie (BUDDY_CENTRE,	CRect(17,	0,	18,	34)),
									Partie (BUDDY_RIGHT,	CRect(19,	0,	35,	34)),
									Partie (FIN,			NULL)
} ;


/* Ecart entre l'image Online/Offline et le texte */
#define ECART_IM_TEXTE			5

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BuddyImage::BuddyImage(CString nom, Buddie * bud)
	: BoutonImage (nom, nom)
{
	this->buddy = bud ;
	this->taille = CPoint (0,0) ;
}


BuddyImage::~BuddyImage()
{
}

// indique a l'image que l'utilisateur a boug la souris
// retourne TRUE si la souris se trouve sur l'image
/*virtual*/ BOOL BuddyImage::OnMouseMove (CPoint pSouris)
{
	return (Image::OnMouseMove(pSouris)) ;
}

// indique a l'image que l'utilisateur a double-clique a cette position
// retourne TRUE si la souris se trouve sur l'image
/*virtual*/ /*BOOL BuddyImage::OnLButtonDblClk (CPoint pSouris)
{
	BOOL retour = Image::OnLButtonDblClk (pSouris) ;

	if (retour)
	{		
		this->notifierObs (ON_INFO_BUDDY, this->buddy) ;
	}
	return (retour) ;
}*/

// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL BuddyImage::OnLButtonDown (CPoint pSouris)
{
	return (BoutonImage::OnLButtonDown(pSouris)) ;

}

// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL BuddyImage::OnLButtonUp (CPoint pSouris)
{
	UINT etat = this->getEtat() ;
	BOOL retour = BoutonImage::OnLButtonUp (pSouris) ;

	if (retour &&
		etat == BoutonImage::ENFONCE &&
		this->estVisible())	
	{		
		this->notifierObs (ON_INFO_BUDDY, this->buddy) ;
	}
	return (retour) ;
}

/*virtual*/ BOOL BuddyImage::OnRButtonUp (CPoint pSouris)
{
	BOOL retour = Image::OnRButtonUp (pSouris) ;

	if (retour && this->estVisible()) {		
		this->notifierObs (ON_MENU_BUDDY, this->buddy, &pSouris) ;
	}
	return (retour) ;
}

// affiche le buddy a la position (x,y)
// et au dimensions cx, cy
// leve une Exception en cas d'erreur d'affichage
/*virtual*/ void BuddyImage::afficher (CDC * dc, int x, int y, int cx, int cy /*= 0*/)
{
	CRect * pos = new CRect [TAILLE_LISTE(listeParties)] ;
	for (int i = 0 ; i < TAILLE_LISTE(listeParties) ; i++)
	{
		pos[i] = getCoord(i, listeParties, FIN) ;
	}

	Image::afficher (dc, pos[BUDDY_LEFT], x, y) ;
	Image::afficher (dc, pos[BUDDY_CENTRE], x + pos[BUDDY_LEFT].Width(), y, cx - pos[BUDDY_RIGHT].Width(), pos[BUDDY_CENTRE].Height()) ;
	Image::afficher (dc, pos[BUDDY_RIGHT], x + cx - pos[BUDDY_RIGHT].Width(), y) ;

	this->taille = CPoint (cx, pos[BUDDY_CENTRE].Height()) ;
	this->rect->SetRect(x, y, x + cx, y + pos[BUDDY_CENTRE].Height()) ;

	delete [] pos ;
}



// retourne la taille de l'image
/*virtual*/ CPoint BuddyImage::getSize (CDC * dc)
{
	if (this->taille == CPoint (0,0))
	{
		taille = Image::getSize(dc) ;
	}
	return (taille) ;
}


// affiche la premiere ligne de texte
void BuddyImage::afficherLigne1 (/*Police * police,*/ CDC * dc, CRect rect, CString texte/*, int numPolice*/)
{
	dc->SetBkMode (TRANSPARENT) ;
	TEXTE_OUT(dc,texte,&rect,DT_LEFT) ;
	//police->afficherTexte (dc, texte, x, y, numPolice, cx) ;
}

// affiche la deuxieme ligne de texte
void BuddyImage::afficherLigne2 (/*Police * police,*/ CDC * dc, CRect rect, Image * online, CString texte/*, int numPolice*/)
{
	CSize sizeOnline ;
	online->afficher (dc, rect.left, rect.top + 2) ;
	sizeOnline = online->getSize(dc) ;

	rect.left += sizeOnline.cx + 2 ;
	dc->SetBkMode (TRANSPARENT) ;	
	TEXTE_OUT(dc,texte,&rect,DT_LEFT) ;
	//police->afficherTexte (dc, texte, online->getSize(dc).x + x + ECART_IM_TEXTE, y, numPolice, cx) ;
}