//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Buddie.h: interface for the Buddie class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BUDDIE_H__946A5D45_139A_4230_AE93_1A227C3E99D1__INCLUDED_)
#define AFX_BUDDIE_H__946A5D45_139A_4230_AE93_1A227C3E99D1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Objet.h"
#include "Ip.h"
#include "Server.h"
#include "Joueur.h"
#include <vector>

using namespace std ;

class Buddie : public Objet  
{
private:
	CString nom ;

/*	Server * serveur ;
	Joueur * joueur ;*/
	vector<Server*> listeServeurs ;
public:
	Buddie(CString nom);
	virtual ~Buddie();

	virtual void serialize (Fichier * f) ;
	static Objet * getFromFile (Fichier * f) throw (Exception) ;

	CString getNom ()		{return (this->nom);}

//	Ip * getIp () ;
	vector<Server*> * getServeurs ()	{return (&this->listeServeurs);}

	/************************************************************
	* Retourne le joueur correspondant a ce buddy jouant sur ce *
	* serveur ou NULL s'il ne joue pas dessus					*
	************************************************************/
	vector<Joueur*> getJoueurs (Server * serveur) ;

	/************************************************************
	* Retourne la liste des joueurs online correspondant a ce	*
	* buddy														*
	************************************************************/
	vector<Joueur*> getJoueurs () ;

	/************************************************************
	* Met a jour la liste des serveurs auquels jouent ce buddy	*
	************************************************************/
	void setServeurs (vector<Server*> * serveurs) ;


	/************************************************************
	* Indique si le buddy est connect sur au moins un serveur	*
	************************************************************/
	bool estConnecte () ;

	
};

#endif // !defined(AFX_BUDDIE_H__946A5D45_139A_4230_AE93_1A227C3E99D1__INCLUDED_)
 