//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Buddie.cpp: implementation of the Buddie class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "Buddie.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define NOMCLASSE		"Buddie"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Buddie::Buddie(CString nom) : Objet(NOMCLASSE)
{
	this->nom = nom ;
}

Buddie::~Buddie()
{
}

/*virtual*/ void Buddie::serialize (Fichier * f) throw (Exception)
{
	Objet::serialize(f) ;
	// ecriture de la taille du nom
	int taille = this->nom.GetLength() + 1 ;
	f->Write (&taille, 1, sizeof(int)) ;

	// ecriture du nom en lui meme
	f->Write (this->nom.GetBuffer(taille), sizeof(char), taille) ;
	this->nom.ReleaseBuffer () ;
}


/*static*/ Objet * Buddie::getFromFile (Fichier * f) throw (Exception)
{
	int taille ;
	char * nomLu ;

	// verification de la validite du fichier
	delete (Objet::getFromFile(f, NOMCLASSE)) ;

	// lecture de la taille du nom du buddie
	f->Read (&taille, 1, sizeof(int)) ;
	if (taille <= 0)
	{
		FICHIER_CORROMPU(f);
	}

	// lecture du nom
	nomLu = new char [taille] ;
	f->Read (nomLu, taille, sizeof (char)) ;


	CString nom = nomLu ;
	delete (nomLu) ;

	return (new Buddie (nom)) ;
}
/*
void Buddie::setIp (Ip * ip)
{
	if (this->ip)		delete (this->ip) ;
	this->ip = ip ;
}
*/
/*
Ip * Buddie::getIp ()
{*/
	/* !!!! a modifier */
//	return (/*this->serveur && this->joueur ? this->serveur->getIp() :*/ NULL) ;
/*}
*/
/************************************************************
* Met a jour la liste des serveurs auquels jouent ce buddy	*
************************************************************/
void Buddie::setServeurs (vector<Server*> * serveurs)
{
	this->listeServeurs.clear() ;
	if (serveurs != NULL)
	{
		FOR_VECTOR(Server*,(*serveurs))
		{
			/************************************************************
			* Ajout du serveur en cours de la liste "serveurs" a la 	*
			* liste des serveurs associs au buddy						*
			************************************************************/
			if (*i != NULL)
			{
				this->listeServeurs.push_back (*i) ;
			}
		}

		/************************************************************
		* Liberation de la place memoire occupe par la liste	 	*
		************************************************************/
		delete (serveurs) ;
	}	
}

/************************************************************
* Retourne le joueur correspondant a ce buddy jouant sur ce *
* serveur ou NULL s'il ne joue pas dessus					*
************************************************************/
vector<Joueur*> Buddie::getJoueurs (Server * serveur)
{
	return (serveur ? serveur->estSurCeServeur(this->nom) : vector<Joueur*>()) ;
}

/************************************************************
* Indique si le buddy est connect sur au moins un serveur	*
************************************************************/
bool Buddie::estConnecte ()
{
	return (!this->listeServeurs.empty()) ;
}

vector<Joueur*> Buddie::getJoueurs ()
{
	vector<Joueur*> retour ;

	vector<Joueur*> temp ;
	vector<Server*> * listeServ = this->getServeurs() ;
	FOR_VECTOR (Server*,(*listeServ))
	{
		/* get players from this server */
		temp = this->getJoueurs (*i) ;
		/* add this list to returned list */
		FOR_VECTOR_IND (Joueur*, temp, j) {
			retour.push_back (*j) ;
		}
	}
	return (retour) ;
}