//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// BoutonImage.h: interface for the BoutonImage class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BOUTONIMAGE_H__84CA51CB_C01A_47EF_8731_355A3928A3B4__INCLUDED_)
#define AFX_BOUTONIMAGE_H__84CA51CB_C01A_47EF_8731_355A3928A3B4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Image.h"

class BoutonImage : public Image  
{
private:
	// image representant le bouton a l'etat enfonce
	Image * boutonEnfonce ;

	// image affichee en ce moment
	Image * imageAffichee ;

	// indique l'etat du bouton : enfonce ou relach
	UINT etat ;

	// differents etats du boutons
	static UINT RELACHE ;
	static UINT ENFONCE ;

protected:
	void setEtat (UINT etat)	throw (Exception) ;
	UINT getEtat () 			{ return (this->etat) ; }


public:

	//BoutonImage();
	// charge l'image du bouton
	// normal indique l'image representant le bouton a l'etat normal
	// enfonce -> bouton a l'etat enfonce
	BoutonImage (CString normal, CString enfonce) throw (Exception) ;
	//BoutonImage (UINT id) throw (Exception) ;

	virtual ~BoutonImage();

	// indique a l'image que l'utilisateur a clique a cette position
	virtual BOOL OnLButtonDown (CPoint pSouris) ;

	// indique a l'image que l'utilisateur a clique a cette position
	virtual BOOL OnLButtonUp (CPoint pSouris) ;

	// indique a l'image que l'utilisateur a boug la souris
	// retourne TRUE si la souris se trouve sur l'image
	virtual BOOL OnMouseMove (CPoint pSouris) ;

	virtual void afficher (CDC * dc, int x = 0, int y = 0) throw (Exception) ;

	// affiche l'image sur le CDC a la position (x,y)
	// et au dimensions cx, cy
	// leve une Exception en cas d'erreur d'affichage
	virtual void afficher (CDC * dc, int x, int y, int cx, int cy) throw (Exception) ;

};

#endif // !defined(AFX_BOUTONIMAGE_H__84CA51CB_C01A_47EF_8731_355A3928A3B4__INCLUDED_)
