//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// BoutonImage.cpp: implementation of the BoutonImage class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "BoutonImage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// differents etats du boutons
/*static*/ UINT BoutonImage::RELACHE = 1 ;
/*static*/ UINT BoutonImage::ENFONCE = 2 ;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/*BoutonImage::BoutonImage()
{
	this->imageAffichee = this ;
	this->boutonEnfonce = NULL ;
	this->etat = RELACHE ;
}*/

BoutonImage::BoutonImage (CString normal, CString enfonce)  throw (Exception) : Image(normal)
{
	this->imageAffichee = this ;
	this->boutonEnfonce = new Image (enfonce) ;
	this->etat = RELACHE ;
}
/*
BoutonImage::BoutonImage (UINT id)  throw (Exception) : Image (id)
{
	this->imageAffichee = this ;
	this->boutonEnfonce = NULL ;
	this->etat = RELACHE ;
}*/

BoutonImage::~BoutonImage()
{
	if (this->boutonEnfonce)	delete (this->boutonEnfonce) ;
}

// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL BoutonImage::OnLButtonDown (CPoint pSouris) 
{
	BOOL retour = Image::OnLButtonDown(pSouris) ;
	if (retour) 
	{
		//MessageBox (AfxGetMainWnd()->m_hWnd, "Bouton appuy...","Click",MB_OK) ;
	
		this->setEtat (ENFONCE) ;
	}
	return (retour) ;
}

// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL BoutonImage::OnLButtonUp (CPoint pSouris)
{
	BOOL retour = Image::OnLButtonUp(pSouris) ;
	if (retour) 
	{
		//MessageBox (AfxGetMainWnd()->m_hWnd, "...bouton relev!","Click",MB_OK) ;
		this->setEtat (RELACHE) ;
	}
	return (retour) ;
}

// affiche l'image sur le CDC a la position (x,y)
// leve une Exception en cas d'erreur d'affichage
/*virtual*/ void BoutonImage::afficher (CDC * dc, int x /*= 0*/, int y /*= 0*/) throw (Exception)
{
	if (this->imageAffichee == this)
	{
		Image::afficher (dc, x, y) ;
	}
	else
	{
		this->imageAffichee->afficher (dc, x, y) ;
	}
}

// affiche l'image sur le CDC a la position (x,y)
// et au dimensions cx, cy
// leve une Exception en cas d'erreur d'affichage
/*virtual*/ void BoutonImage::afficher (CDC * dc, int x, int y, int cx, int cy) throw (Exception)
{
	if (this->getEtat() == RELACHE)
	{
		Image::afficher (dc, x, y, cx, cy) ;
	}
	else
	{
		this->imageAffichee->afficher (dc, x, y, cx, cy) ;
	}
}


void BoutonImage::setEtat (UINT etat)	throw (Exception)
{
	if (etat != RELACHE && etat != ENFONCE)
	{
		CString ex = ""  ;
		ex.Format ("Erreur BoutonImage::setEtat : l'etat demande n'est pas valide (%d)", etat) ;
		throw (Exception (CString (ex))) ;
	}
	this->imageAffichee = (etat == ENFONCE) ? this->boutonEnfonce : this ;
	this->etat = etat ;
	this->notifierObs (Image::ON_REDRAW, this->getRectIm()) ;
}


// indique a l'image que l'utilisateur a boug la souris
// retourne TRUE si la souris se trouve sur l'image
/*virtual*/ BOOL BoutonImage::OnMouseMove (CPoint pSouris)
{
	BOOL retour = Image::OnMouseMove (pSouris) ;
	if (!retour && this->getEtat () == ENFONCE)
	{
		this->setEtat (RELACHE) ;
	}
	return (retour) ;
}
