//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// BackgroundJoueur.cpp: implementation of the BackgroundJoueur class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "BackgroundJoueur.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

enum	{	BACK_NO, BACK_N, BACK_NE,
			BACK_O, BACK_C, BACK_E,
			BACK_SO, BACK_S, BACK_SE,
			FIN} ;

static Partie listeParties[] = {	Partie (BACK_NO,	CRect(0,	0,	16,	16)),
									Partie (BACK_N,		CRect(17,	0,	18,	16)),
									Partie (BACK_NE,	CRect(19,	0,	35,	16)),
									Partie (BACK_O,		CRect(0,	17,	16,	18)),
									Partie (BACK_C,		CRect(17,	17,	18,	18)),
									Partie (BACK_E,		CRect(19,	17,	35,	18)),
									Partie (BACK_SO,	CRect(0,	19,	16,	35)),
									Partie (BACK_S,		CRect(17,	19,	18,	35)),
									Partie (BACK_SE,	CRect(19,	19,	35,	35)),
									Partie (FIN,		NULL)
} ;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BackgroundJoueur::BackgroundJoueur(CString nom) : Image(nom) 
{

}

BackgroundJoueur::~BackgroundJoueur()
{

}


// affiche le background a la position (x,y)
// et au dimensions cx, cy
// leve une Exception en cas d'erreur d'affichage
/*virtual*/ void BackgroundJoueur::afficher (CDC * dc, int x, int y, int cx, int cy) throw (Exception)
{
	CRect * pos = new CRect [TAILLE_LISTE(listeParties)] ;
	for (int i = 0 ; i < TAILLE_LISTE(listeParties) ; i++)
	{
		pos[i] = getCoord(i, listeParties, FIN) ;
	}

	UINT repetX = cx - pos[BACK_NO].Width() - pos[BACK_NE].Width() ;
	UINT repetY = cy - pos[BACK_NO].Height() - pos[BACK_SO].Height() ;

	Image::afficher (dc, pos[BACK_NO], x, y) ;
	Image::afficher (dc, pos[BACK_N],  x + pos[BACK_NO].Width(), y, repetX, pos[BACK_N].Height()) ;
	Image::afficher (dc, pos[BACK_NE], cx - pos[BACK_NE].Width(), y) ; 

	Image::afficher (dc, pos[BACK_O], x, y + pos[BACK_NO].Height(), pos[BACK_O].Width(), repetY) ;
	Image::afficher (dc, pos[BACK_C],  x + pos[BACK_NO].Width(), y  + pos[BACK_NO].Height() , repetX, repetY) ;
	Image::afficher (dc, pos[BACK_E], cx - pos[BACK_NE].Width(), y  + pos[BACK_NO].Height(), pos[BACK_E].Width(), repetY) ; 


	UINT basY = cy - pos[BACK_SO].Height() ;

	Image::afficher (dc, pos[BACK_SO], x, basY) ;
	Image::afficher (dc, pos[BACK_S],  x + pos[BACK_SO].Width(), basY, repetX, pos[BACK_S].Height()) ;
	Image::afficher (dc, pos[BACK_SE], cx - pos[BACK_SE].Width(), basY) ; 

	delete [] pos ;
}


// retourne la taille de l'image
/*virtual*/ CPoint BackgroundJoueur::getSize (CDC * dc)
{
/*	CPoint retour ;

	CRect * pos = new CRect [TAILLE_LISTE(listeParties)] ;
	for (int i = 0 ; i < TAILLE_LISTE(listeParties) ; i++)
	{
		pos[i] = getCoord(i, listeParties, FIN) ;
	}

	retour.x = pos[BACK_NO].Width() + pos[BACK_N].Width() + pos[BACK_NE].Width() + 2 ;
	retour.y = pos[BACK_NO].Height() + pos[BACK_O].Height() + pos[BACK_SO].Height() + 2 ;

	delete [] pos ;

	return (retour) ;*/
	return (Image::getSize(dc)) ;
}


// retourne le point de depart pour le dessin des buddies
CPoint BackgroundJoueur::getPointDepart ()
{
//	CRect r = getCoord(BACK_NO, listeParties, FIN) ;
	return (CPoint (10,10)) ;
}

// retourne la largeur de la bordure droite
UINT BackgroundJoueur::getTailleBordure ()
{
	return (getCoord(BACK_NE, listeParties, FIN).Width() + 4) ;
}