//this file is part of ETBuddies
//Copyright (C)2004-2005 Jos ( josb_31@hotmail.com / http://www.etbuddies.tk )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// AddRelationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "AddRelationDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AddRelationDlg dialog


AddRelationDlg::AddRelationDlg(CWnd* pParent /*=NULL*/)
	: CDialog(AddRelationDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(AddRelationDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pRelation = NULL ;
}


void AddRelationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AddRelationDlg)
	DDX_Control(pDX, IDC_VALUE, m_value);
	DDX_Control(pDX, IDC_LISTE_COMP, m_comparaisons);
	DDX_Control(pDX, IDC_LISTE_VAR, m_variables);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(AddRelationDlg, CDialog)
	//{{AFX_MSG_MAP(AddRelationDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AddRelationDlg message handlers

void AddRelationDlg::setMaster(ClientMaster * maitre) {
	m_pMaster = maitre ;
}


BOOL AddRelationDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	if (m_pMaster != NULL) {
		m_variables.initVariables(m_pMaster) ;
	}

	m_comparaisons.AddString("<") ;
	m_comparaisons.AddString("=") ;
	m_comparaisons.AddString(">") ;
	m_comparaisons.SetCurSel(0) ;

	CString var ;
	m_variables.GetWindowText(var) ;
	CString value ;
	m_value.GetWindowText(value) ;

	if (m_pRelation != NULL)		delete (m_pRelation) ;
	m_pRelation = new Relation(var, m_comparaisons.GetCurSel() - 1, value) ;

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}




void AddRelationDlg::OnOK() 
{

	CString var ;
	m_variables.GetWindowText(var) ;
	

	CString value ;
	m_value.GetWindowText(value) ;

	if (value.Compare("") == 0) {
		MessageBox("You must specify a value for this relation", "Error", MB_ICONERROR) ;
		return ;
	}


	// TODO: Add extra validation here
	if (m_pRelation != NULL)		delete (m_pRelation) ;
	m_pRelation = new Relation(var, m_comparaisons.GetCurSel() - 1, value) ;
	
	CDialog::OnOK();
}
