
-- WolfAdmin module for Wolfenstein: Enemy Territory servers.
-- Copyright (C) 2015-2016 Timo 'Timothy' Smit

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- at your option any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local commands = require "luascripts.wolfadmin.commands.commands"

function commandHelp(clientId, cmdArguments)
    local cmds = commands.getadmin()
    
    if #cmdArguments == 0 then
        local availableCommands = {}
        
        for command, data in pairs(cmds) do
            if data["function"] and data["flag"] and et.G_shrubbot_permission(clientId, data["flag"]) == 1 and (not data["hidden"] or (type(data["hidden"]) == "function" and not data["hidden"]())) then
                table.insert(availableCommands, command)
            end
        end
        
        et.trap_SendConsoleCommand(et.EXEC_APPEND, "cchat "..clientId.." \"^dhelp: ^9"..#availableCommands.." additional commands (open console for the full list)\";")
        
        local cmdsOnLine, cmdsBuffer = 0, ""
        
        for _, command in pairs(availableCommands) do
            cmdsBuffer = cmdsBuffer ~= "" and cmdsBuffer..string.format("%-12s", command) or string.format("%-12s", command)
            cmdsOnLine = cmdsOnLine + 1
                
            if cmdsOnLine == 6 then
                et.trap_SendConsoleCommand(et.EXEC_APPEND, "csay "..clientId.." \"^f"..cmdsBuffer.."\";")
                cmdsBuffer = ""
                cmdsOnLine = 0
            end
        end
        
        if cmdsBuffer ~= "" then
            et.trap_SendConsoleCommand(et.EXEC_APPEND, "csay "..clientId.." \"^f"..cmdsBuffer.."\";")
        end
        
        et.trap_SendConsoleCommand(et.EXEC_APPEND, "csay "..clientId.." \"^9Type ^2!help ^d[command] ^9for help with a specific command.\";")
        
        return false
    elseif #cmdArguments > 0 then
        local helpCmd = string.lower(cmdArguments[1])
        
        if cmds[helpCmd] ~= nil and (not cmds[helpCmd]["hidden"] or (type(cmds[helpCmd]["hidden"]) == "function" and not cmds[helpCmd]["hidden"]())) then
            et.trap_SendConsoleCommand(et.EXEC_APPEND, "csay "..clientId.." \"^dhelp: ^9help for '^2"..helpCmd.."^9':\";")
            et.trap_SendConsoleCommand(et.EXEC_APPEND, "csay "..clientId.." \"^dfunction: ^9"..cmds[helpCmd]["help"].."\";")
            et.trap_SendConsoleCommand(et.EXEC_APPEND, "csay "..clientId.." \"^dsyntax: ^9"..cmds[helpCmd]["syntax"].."\";")
            et.trap_SendConsoleCommand(et.EXEC_APPEND, "csay "..clientId.." \"^dflag: ^9'^2"..cmds[helpCmd]["flag"].."^9'\";")
            
            return true
        end
    end
    
    return false
end
commands.addadmin("help", commandHelp, "h", "display commands available to you or help on a specific command", "^9(^hcommand^9)", true)