
-- WolfAdmin module for Wolfenstein: Enemy Territory servers.
-- Copyright (C) 2015 Timo 'Timothy' Smit

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- at your option any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local constants = require "luascripts.wolfadmin.util.constants"
local util = require "luascripts.wolfadmin.util.util"
local events = require "luascripts.wolfadmin.util.events"

local timers = {}

local data = {}

function timers.get(id)
    return data[id]
end

function timers.add(func, interval, rep, ...)
    local args = {...}
    
    table.insert(data, {
        ["function"] = func,
        ["start"] = et.trap_Milliseconds(),
        ["interval"] = interval,
        ["iteration"] = 0,
        ["repeat"] = rep,
        ["args"] = args
    })
end

function timers.remove(id)
    data[id] = nil
end

function timers.ongameframe(levelTime)
    for id, timer in pairs(data) do
        if (et.trap_Milliseconds() - timer["start"]) > timer["interval"] then
            timer["function"](unpack(timer["args"]))
            timer["iteration"] = timer["iteration"] + 1
            
            if timer["repeat"] == 0 or timer["iteration"] < timer["repeat"] then
                timer["start"] = et.trap_Milliseconds()
            else
                timers.remove(id)
            end
        end
    end
end
events.handle("onGameFrame", timers.ongameframe)

return timers