
-- WolfAdmin module for Wolfenstein: Enemy Territory servers.
-- Copyright (C) 2015 Timo 'Timothy' Smit

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- at your option any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local util = require "luascripts.wolfadmin.util.util"
local events = require "luascripts.wolfadmin.util.events"
local settings = require "luascripts.wolfadmin.util.settings"
local files = require "luascripts.wolfadmin.util.files"

local stats = require "luascripts.wolfadmin.players.stats"

local greetings = {}

local userGreetings = {}
local levelGreetings = {}

function greetings.get(clientId)
    local lvl = et.G_shrubbot_level(clientId)
    
    if et.G_shrubbot_permission(clientId, "@") ~= 1 then
        if userGreetings[stats.get(clientId, "playerGUID")] ~= nil then
            return userGreetings[stats.get(clientId, "playerGUID")]
        elseif levelGreetings[lvl] ~= nil then
            return levelGreetings[lvl]
        end
    else
        if levelGreetings[0] then
            return levelGreetings[0]
        end
    end
end

function greetings.show(clientId)
    local greetingText = greetings.get(clientId)
    
    if greetingText then
        et.trap_SendConsoleCommand(et.EXEC_APPEND, util.getAreaName(settings.get("g_greetingArea")).." \"^dgreeting: ^9"..greetingText:gsub("%[N%]", et.gentity_get(clientId, "pers.netname")).."\";")
    end
end

function greetings.load()
    local fileName = settings.get("g_fileGreetings")
    
    local amount, array = files.loadCFG(fileName, "[a-z]+", true)
    
    if amount == 0 then return 0 end
    
    for id, greeting in ipairs(array["level"]) do
        levelGreetings[tonumber(greeting["level"])] = greeting["greeting"]
    end
    
    for id, greeting in ipairs(array["user"]) do
        userGreetings[greeting["guid"]] = greeting["greeting"]
    end
    
    return amount
end

function greetings.oninit(levelTime, randomSeed, restartMap)
    if settings.get("g_fileGreetings") ~= "" then
        greetings.load()
        
        events.handle("onClientBegin", greetings.onbegin)
    end
end
events.handle("onGameInit", greetings.oninit)

function greetings.onbegin(clientId, firstTime)
    if firstTime then
        greetings.show(clientId)
    end
end

return greetings