/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Stats {
    public static String NAME_SHORT = "StatWhore";
    public static String NAME_LONG = "StatWhore - RTCW:ET Log File Analyser";
    public static String VERSION = "1.1.9";
    public static int LINE_COUNT = 0;
    static JFrame frame = new JFrame();
    static JTextArea results;
    String filename = "D:\\Program Files\\Wolfenstein - Enemy Territory\\etpro\\etconsole.log";
    String outfilename = "";
    PrintWriter os = null;
    File consoleLog = null;
    BufferedReader in = null;
    long fileSize = 0L;
    boolean shutdown = false;
    long filedate = 0L;
    long starttime = new Date().getTime();
    MatchSummary summary = new MatchSummary();
    List playerEvents = new ArrayList();
    List gameEvents = new ArrayList();
    List messageEvents = new ArrayList();
    Players players = new Players();
    List deathNotices = new ArrayList();
    List objectiveNotices = new ArrayList();
    List playerRoundStats = new ArrayList();
    Map suicideWeaponsType = new HashMap();
    Map weaponDescription = new HashMap();
    List weaponList = new ArrayList();
    Pattern logfileDatePattern = Pattern.compile("logfile opened on (.+)");
    Pattern mapPattern = Pattern.compile("LOADING\\.\\.\\. maps/(.+)\\.bsp");
    Pattern map2Pattern = Pattern.compile("\\^3>>> Map: \\^2(.+)");
    Pattern etproPattern = Pattern.compile("\\[skipnotify\\]etpro: Server version (.+)");
    Pattern fightPattern = Pattern.compile("\\[skipnotify\\]\\^1FIGHT!");
    Pattern pausePattern = Pattern.compile("\\[skipnotify\\]\\*\\*\\* \\^3INFO: \\^5\\^3Match is \\^1PAUSED\\^3! \\(\\^\\d(Axis|Allies)\\^7\\^3\\)");
    Pattern renamedPattern = Pattern.compile("\\[skipnotify\\](.+)\\^7 renamed to (.+)");
    Pattern enteredPattern = Pattern.compile("\\[skipnotify\\](.+)\\^7 entered the game");
    Pattern messagePattern = Pattern.compile("(.+)\\^7: \\^2(.+)");
    Pattern killedPattern = Pattern.compile("(\\^1TEAM KILL\\^7: )?(.+)\\^7 (?:was .+ by|failed to spot|never saw|got buried under) (.+)\\^7's (.+)");
    Pattern suicidePattern = Pattern.compile("(\\[skipnotify\\])?(.+)\\^7 (.+)\\.");
    Pattern endOfRoundPattern = Pattern.compile("(\\[skipnotify\\])?\\^7Overall stats for:(.+)");
    Pattern statsPattern = Pattern.compile("\\[skipnotify\\]\\^(?:1|4)(Axis|Allies)\\^7(?: {1,3}?)\\^(?:7|3)(.+)\\^3(....)(....)(....)(...)\\^(?:7|3)(....)\\^3(....)\\^2(......)\\^1(......)\\^6(.....)\\^3(.......)");
    Pattern statsTypePattern = Pattern.compile("\\^7TEAM   Player          Kll Dth Sui TK Eff  \\^3GP\\^7    \\^2DG    \\^1DR   \\^6TD  \\^3Score");
    Pattern round1Pattern = Pattern.compile("\\[skipnotify\\]>>> \\^3Clock set to: (.+)");
    Pattern round2Pattern = Pattern.compile("\\[skipnotify\\]>>> \\^3Objective (?:NOT reached in time \\((.+)\\)|reached at (.+) \\(original\\: (.+)\\))");
    Pattern roundTimelimit = Pattern.compile("\\[skipnotify\\]Timelimit hit.");
    Pattern shutdownPattern = Pattern.compile("----- CL_Shutdown -----");

    public void parse() {
        long roundStartTime = new Date().getTime();
        boolean paused = false;
        long pauseTime = 0L;
        long pauseStartTime = 0L;
        boolean etpro3GibStats = true;
        boolean endOfRoundStatsParse = false;
        while (this.ready()) {
            Player killer;
            Player player;
            Stats.incLineCount();
            boolean matched = false;
            String line = this.readLine();
            Matcher matcher = null;
            if (!matched && (matcher = this.logfileDatePattern.matcher(line)).matches()) {
                SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
                Date date = null;
                try {
                    date = df.parse(matcher.group(1));
                    this.filedate = date.getTime();
                }
                catch (ParseException pe) {
                    System.err.println("Parse error getting date from log file entry '" + matcher.group(1) + "'.  Will use file modified date instead.");
                }
                matched = true;
            }
            if (!matched && (matcher = this.mapPattern.matcher(line)).matches()) {
                this.gameEvents.add(new GameEvent().setMap(matcher.group(1)));
                matched = true;
            }
            if (!matched && (matcher = this.map2Pattern.matcher(line)).matches()) {
                this.gameEvents.add(new GameEvent().setMap(matcher.group(1)));
                matched = true;
            }
            if (!matched && (matcher = this.etproPattern.matcher(line)).matches()) {
                this.gameEvents.add(new GameEvent().setEtpro(matcher.group(1)));
                matched = true;
            }
            if (!matched && (matcher = this.fightPattern.matcher(line)).matches()) {
                this.gameEvents.add(new GameEvent().setFight());
                if (paused) {
                    paused = false;
                    pauseTime += new Date().getTime() - pauseStartTime;
                } else {
                    roundStartTime = new Date().getTime();
                }
                matched = true;
            }
            if (!matched && (matcher = this.pausePattern.matcher(line)).matches()) {
                this.gameEvents.add(new GameEvent().setPause(matcher.group(1)));
                paused = true;
                pauseStartTime = new Date().getTime();
                matched = true;
            }
            if (!matched && (matcher = this.renamedPattern.matcher(line)).matches()) {
                this.players.renamePlayer(matcher.group(1), matcher.group(2));
                matched = true;
            }
            if (!matched && (matcher = this.enteredPattern.matcher(line)).matches()) {
                player = this.players.playerSearchAdd(matcher.group(1));
                this.gameEvents.add(new GameEvent().setEntered(player));
                matched = true;
            }
            if (!matched && (matcher = this.killedPattern.matcher(line)).matches()) {
                killer = this.players.playerSearchAdd(matcher.group(3));
                Player victim = this.players.playerSearchAdd(matcher.group(2));
                PlayerEvent event = new PlayerEvent();
                if (killer != null && victim != null) {
                    if (matcher.group(1) != null) {
                        event.teamKill(this.getRoundTime(roundStartTime, pauseStartTime), killer, victim, (Weapon)this.weaponDescription.get(matcher.group(4)));
                    } else {
                        event.kill(this.getRoundTime(roundStartTime, pauseStartTime), killer, victim, (Weapon)this.weaponDescription.get(matcher.group(4)));
                    }
                    this.playerEvents.add(event);
                    matched = true;
                }
            }
            if (!matched && (matcher = this.suicidePattern.matcher(line)).matches()) {
                if (matcher.group(1) != null) {
                    matched = true;
                } else {
                    killer = this.players.playerSearchAdd(matcher.group(2));
                    PlayerEvent event = new PlayerEvent();
                    if (killer != null) {
                        if ("killed himself".equals(matcher.group(3))) {
                            event.slashKill(this.getRoundTime(roundStartTime, pauseStartTime), killer);
                        } else {
                            event.suicide(this.getRoundTime(roundStartTime, pauseStartTime), killer, (Weapon)this.suicideWeaponsType.get(matcher.group(3)));
                        }
                        this.playerEvents.add(event);
                        matched = true;
                    }
                }
            }
            if (!matched && (matcher = this.messagePattern.matcher(line)).matches()) {
                player = this.players.playerSearchAdd(matcher.group(1));
                this.messageEvents.add(new MessageEvent(new Date().getTime(), player, matcher.group(2)));
                matched = true;
            }
            if (!matched && (matcher = this.statsTypePattern.matcher(line)).matches()) {
                etpro3GibStats = false;
                matched = true;
            }
            if (!matched && (matcher = this.endOfRoundPattern.matcher(line)).matches()) {
                endOfRoundStatsParse = true;
            }
            if (!matched && endOfRoundStatsParse && (matcher = this.statsPattern.matcher(line)).matches() && (player = this.players.playerSearchStats(matcher.group(2).trim())) != null) {
                PlayerRoundStats prs = null;
                prs = etpro3GibStats ? new PlayerRoundStats(player, matcher.group(1), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7), "0", matcher.group(8), matcher.group(9), matcher.group(10), matcher.group(11), matcher.group(12)) : new PlayerRoundStats(player, matcher.group(1), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7), matcher.group(8), "0", matcher.group(9), matcher.group(10), matcher.group(11), matcher.group(12));
                this.playerRoundStats.add(prs);
                matched = true;
            }
            if (!matched && (matcher = this.roundTimelimit.matcher(line)).matches()) {
                this.gameEvents.add(new GameEvent().setRoundTimelimitHit());
                matched = true;
            }
            if (!matched && (matcher = this.round1Pattern.matcher(line)).matches()) {
                this.gameEvents.add(new GameEvent().setRoundOneEnd(matcher.group(1)));
                endOfRoundStatsParse = false;
                matched = true;
            }
            if (!matched && (matcher = this.round2Pattern.matcher(line)).matches()) {
                endOfRoundStatsParse = false;
                if (matcher.group(1) != null) {
                    this.gameEvents.add(new GameEvent().setRoundTwoEnd(false, matcher.group(1)));
                } else {
                    this.gameEvents.add(new GameEvent().setRoundTwoEnd(true, matcher.group(2)));
                }
                matched = true;
            }
            if (matched || !(matcher = this.shutdownPattern.matcher(line)).matches()) continue;
            matched = true;
            this.shutdown = true;
            this.gameEvents.add(new GameEvent().setShutdown());
        }
    }

    private long getRoundTime(long roundStartTime, long pauseTime) {
        return new Date().getTime() - roundStartTime - pauseTime;
    }

    public void analyse() {
        ArrayList<Game> games = new ArrayList<Game>();
        Game game = new Game();
        String map = "unknown";
        int gameNumber = 1;
        Round round = new Round();
        round.setMap(map);
        round.setGameNumber(gameNumber);
        Iterator i = this.gameEvents.iterator();
        while (i.hasNext()) {
            GameEvent gameEvent = (GameEvent)i.next();
            if (gameEvent.isMap()) {
                map = gameEvent.getMap();
                round.setMap(map);
            }
            if (gameEvent.isEtpro()) {
                round.foundEtpro(gameEvent.getTime(), gameEvent.getLineNumber());
            }
            if (gameEvent.isFight() && round.getStart() == 0L) {
                round.setStart(gameEvent.getTime());
                round.setStartLine(gameEvent.getLineNumber());
            }
            if (gameEvent.isTimelimitHit()) {
                round.setSuccess(false);
            }
            if (gameEvent.isRoundEnd()) {
                round.setEnd(gameEvent.getTime());
                round.setEndLine(gameEvent.getLineNumber());
                if (gameEvent.isRoundOneEnd()) {
                    round.setRoundOne();
                    round.setTime(gameEvent.getRoundClockTime());
                    if (game.getRound1() != null) {
                        games.add(game);
                        game = new Game();
                        ++gameNumber;
                    }
                    game.setRound1(round);
                } else if (gameEvent.isRoundTwoEnd()) {
                    round.setRoundTwo();
                    round.setTime(gameEvent.getRoundClockTime());
                    game.setRound2(round);
                } else {
                    round.setPartial(true);
                    if (game.getRound1() == null) {
                        game.setRound1(round);
                    } else {
                        game.setRound2(round);
                    }
                }
                this.addRoundEvents(round);
                if (game.getRound2() != null || round.isPartial() && round.getStart() > 0L) {
                    games.add(game);
                    game = new Game();
                    ++gameNumber;
                }
                round = new Round(map, gameNumber);
            }
            this.summary.setMap(map);
            this.summary.setGameDate(this.filedate);
            this.summary.setGames(games);
            this.summary.setMessages(this.messageEvents);
        }
        int count = 1;
        SimpleDateFormat sdf = new SimpleDateFormat("mm:ss");
        Iterator i2 = games.iterator();
        while (i2.hasNext()) {
            long diff;
            long end;
            long start;
            game = (Game)i2.next();
            if (game.getRound1() != null) {
                start = game.getRound1().getStart();
                end = game.getRound1().getEnd();
                diff = end - start;
                this.findPlayersInRound(game.getRound1(), game);
            }
            if (game.getRound2() != null) {
                start = game.getRound2().getStart();
                end = game.getRound2().getEnd();
                diff = end - start;
                this.findPlayersInRound(game.getRound2(), game);
                if (game.getRound1() != null) {
                    this.adjustRound2Stats(game.getRound1().getTeamA(), game.getRound2().getTeamA(), game.getRound2().getPlayerStats());
                    this.adjustRound2Stats(game.getRound1().getTeamB(), game.getRound2().getTeamB(), game.getRound2().getPlayerStats());
                }
            }
            ++count;
        }
        i2 = games.iterator();
        while (i2.hasNext()) {
            game = (Game)i2.next();
            if (game.getRound1() != null) {
                this.compilePlayerStats(game.getRound1(), game);
            }
            if (game.getRound2() != null) {
                this.compilePlayerStats(game.getRound2(), game);
            }
            if (game.isPartial()) continue;
            if (game.isDraw()) {
                this.summary.incrementDraws();
                continue;
            }
            if (game.isTeamAWin()) {
                this.summary.incrementTeamAScore();
                continue;
            }
            this.summary.incrementTeamBScore();
        }
        count = 0;
        Iterator i3 = games.iterator();
        while (i3.hasNext()) {
            Iterator j;
            PlayerRoundStats roundTotal;
            game = (Game)i3.next();
            ++count;
            if (game.getRound1() != null) {
                round = game.getRound1();
                roundTotal = new PlayerRoundStats();
                roundTotal.setPlayer(new Player(this.summary.getTeamATag()));
                j = round.getTeamA().iterator();
                while (j.hasNext()) {
                    PlayerRoundStats prs = (PlayerRoundStats)j.next();
                    roundTotal.sum(prs);
                }
                round.setTeamATotal(roundTotal);
                roundTotal = new PlayerRoundStats();
                roundTotal.setPlayer(new Player(this.summary.getTeamBTag()));
                j = round.getTeamB().iterator();
                while (j.hasNext()) {
                    PlayerRoundStats prs = (PlayerRoundStats)j.next();
                    roundTotal.sum(prs);
                }
                round.setTeamBTotal(roundTotal);
            }
            if (game.getRound2() == null) continue;
            round = game.getRound2();
            roundTotal = new PlayerRoundStats();
            roundTotal.setPlayer(new Player(this.summary.getTeamBTag()));
            j = round.getTeamB().iterator();
            while (j.hasNext()) {
                PlayerRoundStats prs = (PlayerRoundStats)j.next();
                roundTotal.sum(prs);
            }
            round.setTeamBTotal(roundTotal);
            roundTotal = new PlayerRoundStats();
            roundTotal.setPlayer(new Player(this.summary.getTeamATag()));
            j = round.getTeamA().iterator();
            while (j.hasNext()) {
                PlayerRoundStats prs = (PlayerRoundStats)j.next();
                roundTotal.sum(prs);
            }
            round.setTeamATotal(roundTotal);
        }
        int kills = 0;
        int gamekills = 0;
        ArrayList<Player> teamA = new ArrayList<Player>();
        ArrayList<Player> teamB = new ArrayList<Player>();
        PlayerRoundStats teamATotal = new PlayerRoundStats();
        teamATotal.setPlayer(new Player(this.summary.getTeamATag()));
        PlayerRoundStats teamBTotal = new PlayerRoundStats();
        teamBTotal.setPlayer(new Player(this.summary.getTeamBTag()));
        Iterator<Object> i4 = games.iterator();
        while (i4.hasNext()) {
            PlayerRoundStats prs;
            Iterator j;
            game = (Game)i4.next();
            if (game.getRound1() != null) {
                j = game.getRound1().getTeamA().iterator();
                while (j.hasNext()) {
                    prs = (PlayerRoundStats)j.next();
                    this.players.playerSearch(prs.getPlayer().getName()).getStatsTotal().sum(prs);
                    kills += prs.getKills();
                }
                j = game.getRound1().getTeamB().iterator();
                while (j.hasNext()) {
                    prs = (PlayerRoundStats)j.next();
                    this.players.playerSearch(prs.getPlayer().getName()).getStatsTotal().sum(prs);
                    kills += prs.getKills();
                }
                gamekills += this.countKills(game.getRound1().getStart(), game.getRound1().getEnd());
            }
            if (game.getRound2() == null) continue;
            j = game.getRound2().getTeamA().iterator();
            while (j.hasNext()) {
                prs = (PlayerRoundStats)j.next();
                this.players.playerSearch(prs.getPlayer().getName()).getStatsTotal().sum(prs);
                kills += prs.getKills();
            }
            j = game.getRound2().getTeamB().iterator();
            while (j.hasNext()) {
                prs = (PlayerRoundStats)j.next();
                this.players.playerSearch(prs.getPlayer().getName()).getStatsTotal().sum(prs);
                kills += prs.getKills();
            }
            gamekills += this.countKills(game.getRound2().getStart(), game.getRound2().getEnd());
        }
        i4 = this.players.getPlayers().entrySet().iterator();
        while (i4.hasNext()) {
            Map.Entry entry = (Map.Entry)i4.next();
            Player player = (Player)entry.getValue();
            if (player.isTeamA()) {
                teamA.add(player);
                teamATotal.sum(player.getStatsTotal());
            }
            if (!player.isTeamB()) continue;
            teamB.add(player);
            teamBTotal.sum(player.getStatsTotal());
        }
        this.summary.setTeamAPlayers(teamA);
        this.summary.setTeamBPlayers(teamB);
        this.summary.setTeamATotal(teamATotal);
        this.summary.setTeamBTotal(teamBTotal);
        this.summary.setTeamATag(this.players.getTeamTag(Player.TEAM_A));
        this.summary.setTeamBTag(this.players.getTeamTag(Player.TEAM_B));
        this.summary.setWeapons(this.weaponList);
        ArrayList awards = new ArrayList();
        this.summary.setAwards(awards);
        HashMap<String, Object> award = new HashMap<String, Object>();
        String stat = "kills";
        int amount = this.players.findMaxStat(stat);
        int avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("name", "Lady Macbeth");
        award.put("description", String.valueOf(amount) + " kills");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Killing Spree");
        stat = "kkd";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " frags without being killed");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Rampage");
        stat = "4kill";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " killing sprees of 4+ frags");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "1-Kill Wonder");
        stat = "1kill";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " times managing only a single frag");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Accountant");
        stat = "eff";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + "% kills/killed ratio");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "He's dead, Jim!");
        stat = "gib";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " gibs");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "...and stay dead!");
        stat = "gib/k";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + "% gibs/kill");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Lead Poisoning");
        stat = "smg";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " SMG kills");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Spammity spam spam!");
        stat = "spam";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " SPAM kills");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Fragstealer");
        stat = "d/k";
        amount = this.players.findMinStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " damage per frag");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Die!  Damn you, Die!");
        stat = "d/k";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " damage per frag");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "What objective?");
        stat = "xp";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " xp");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Red Shirt");
        stat = "deaths";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " deaths");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Are these pliers sharp?");
        stat = "kdk";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " deaths without fragging");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Med Pack Whore");
        stat = "d/kd";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " damage per death");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Eyes Wide Shut");
        stat = "tk";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " team kills");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        award = new HashMap();
        award.put("name", "Gingerbread man");
        stat = "/kill";
        amount = this.players.findMaxStat(stat);
        avg = this.players.findAvgStat(stat);
        award.put("average", "" + avg);
        award.put("description", String.valueOf(amount) + " /kills");
        award.put("players", this.players.findPlayerWithStat(stat, amount));
        if (amount != 0) {
            awards.add(award);
        }
        if (this.players.findMaxStat(stat = "knife") > 0) {
            award = new HashMap();
            award.put("name", "Ginzu");
            stat = "knife";
            award.put("description", "at least 1 knife kill");
            award.put("players", this.players.findPlayerWithMinStat(stat, 1));
            awards.add(award);
            award = new HashMap();
            award.put("name", "et tu, Brute!");
            stat = "knifed";
            avg = this.players.findAvgStat(stat);
            award.put("description", "stabbed to death by a knife");
            award.put("players", this.players.findPlayerWithMinStat(stat, 1));
            awards.add(award);
        }
    }

    private void compilePlayerStats(Round round, Game game) {
        PlayerRoundStats prs = null;
        Map playersInRound = round.getPlayerStats();
        Iterator i = playersInRound.keySet().iterator();
        while (i.hasNext()) {
            Player player = (Player)i.next();
            prs = new PlayerRoundStats();
            prs.setPlayer(player);
            this.populateObservedStats(prs, round);
            PlayerRoundStats endOfRound = round.findByPlayer(player);
            if (endOfRound == null) {
                round.addPlayerStats(prs);
                continue;
            }
            endOfRound.combine(prs);
        }
    }

    private int calcDamage(int OriginalDamage, int originalKills, int newKills) {
        if (originalKills == 0) {
            originalKills = 1;
        }
        if (newKills == 0) {
            newKills = 1;
        }
        double damagePerFrag = new Double(OriginalDamage) / (double)originalKills;
        return new Double(damagePerFrag * (double)newKills).intValue();
    }

    private Map findPlayersInRound(Round round, Game game) {
        HashMap<Player, PlayerRoundStats> playersInRound = new HashMap<Player, PlayerRoundStats>();
        HashMap playersInRoundPreStart = new HashMap();
        PlayerRoundStats prs = null;
        int etproSeen = 0;
        boolean fightSeen = false;
        Iterator i = round.getGameEvents().iterator();
        while (i.hasNext()) {
            GameEvent event = (GameEvent)i.next();
            if (event.isEtpro() && ++etproSeen == 2) {
                playersInRoundPreStart = playersInRound;
                playersInRound = new HashMap();
            }
            if (event.isFight()) {
                fightSeen = true;
            }
            if (!event.isEntered()) continue;
            if (!fightSeen && etproSeen == 2 && playersInRoundPreStart.containsKey(event.getEnteredPlayer())) {
                prs = (PlayerRoundStats)playersInRoundPreStart.get(event.getEnteredPlayer());
                playersInRound.put(event.getEnteredPlayer(), prs);
            } else if (playersInRound.containsKey(event.getEnteredPlayer())) {
                prs = (PlayerRoundStats)playersInRound.get(event.getEnteredPlayer());
            } else {
                prs = new PlayerRoundStats();
                prs.setPlayer(event.getEnteredPlayer());
                prs.setRoundStart(round.getStart());
                prs.setEtproSeen(round.getEtproSeen());
                playersInRound.put(event.getEnteredPlayer(), prs);
            }
            prs.setLastEntered(event.getTime());
            if (event.getTime() <= round.getStart()) continue;
            prs.setEstimate(true);
        }
        round.setPlayerStats(playersInRound);
        return playersInRound;
    }

    private void populateObservedStats(PlayerRoundStats prs, Round round) {
        Player player = prs.getPlayer();
        int kills = 0;
        int deaths = 0;
        int suicides = 0;
        int teamkills = 0;
        int slashkills = 0;
        int teamkilled = 0;
        int killsBeforeKilled = 0;
        int killsBeforeDeath = 0;
        int killedBeforeKill = 0;
        int deathsBeforeKill = 0;
        Iterator i = round.getPlayerEvents().iterator();
        while (i.hasNext()) {
            PlayerEvent event = (PlayerEvent)i.next();
            if (event.getPrimary() == player) {
                if (event.iskill()) {
                    ++kills;
                    ++killsBeforeKilled;
                    ++killsBeforeDeath;
                    prs.getWeaponKill().increment(event.getWeapon().getWeaponLevel());
                    prs.getKilledBeforeKill().increment(killedBeforeKill);
                    prs.getWeaponDetail().increment(this.weaponList.indexOf(event.getWeapon()));
                    killedBeforeKill = 0;
                    deathsBeforeKill = 0;
                    if (!event.getPrimary().isInTeam() && event.getSecondary().isInTeam()) {
                        event.getPrimary().setOtherTeam(event.getSecondary().getTeam());
                    }
                    if (event.getPrimary().isInTeam() && !event.getSecondary().isInTeam()) {
                        event.getSecondary().setOtherTeam(event.getPrimary().getTeam());
                    }
                }
                if (event.isSlashKill()) {
                    ++slashkills;
                    killsBeforeDeath = 0;
                    ++deathsBeforeKill;
                }
                if (event.isSuicide()) {
                    ++suicides;
                    killsBeforeDeath = 0;
                    ++deathsBeforeKill;
                }
                if (event.isTeamKill()) {
                    ++teamkills;
                    if (!event.getPrimary().isInTeam() && event.getSecondary().isInTeam()) {
                        event.getPrimary().setTeam(event.getSecondary().getTeam());
                    }
                    if (event.getPrimary().isInTeam() && !event.getSecondary().isInTeam()) {
                        event.getSecondary().setTeam(event.getPrimary().getTeam());
                    }
                }
            }
            if (event.getSecondary() == player && event.iskill()) {
                prs.getWeaponKilled().increment(event.getWeapon().getWeaponLevel());
                prs.getKillBeforeKilled().increment(killsBeforeKilled);
                ++deaths;
                ++killedBeforeKill;
                ++deathsBeforeKill;
                killsBeforeKilled = 0;
                killsBeforeDeath = 0;
            }
            if (event.getSecondary() == player && event.isTeamKill()) {
                ++teamkilled;
                ++deathsBeforeKill;
                killsBeforeDeath = 0;
            }
            prs.updateKillBeforeKilledMax(killsBeforeKilled);
            prs.updateKillBeforeDeathMax(killsBeforeDeath);
            prs.updateKilledBeforeKillMax(killedBeforeKill);
            prs.updateDeathBeforeKillMax(deathsBeforeKill);
        }
        prs.getKillBeforeKilled().increment(killsBeforeKilled);
        prs.getKilledBeforeKill().increment(killedBeforeKill);
        prs.setKills(kills);
        prs.setDeaths(deaths);
        prs.setSuicides(suicides);
        prs.setTeamkills(teamkills);
        prs.setSlashkills(slashkills);
        prs.calculateEfficiency();
    }

    private void adjustRound2Stats(List r1team, List r2team, Map playersInRound) {
        Iterator i = r1team.iterator();
        block0: while (i.hasNext()) {
            PlayerRoundStats prs;
            PlayerRoundStats player = (PlayerRoundStats)i.next();
            if (!playersInRound.containsKey(player.getPlayer()) || (prs = (PlayerRoundStats)playersInRound.get(player.getPlayer())).isNewToRound()) continue;
            Iterator j = r2team.iterator();
            while (j.hasNext()) {
                PlayerRoundStats prsRound2 = (PlayerRoundStats)j.next();
                if (prsRound2.getPlayer() != player.getPlayer()) continue;
                prsRound2.setKills(prsRound2.getKills() - player.getKills());
                prsRound2.setDeaths(prsRound2.getDeaths() - player.getDeaths());
                prsRound2.setSuicides(prsRound2.getSuicides() - player.getSuicides());
                prsRound2.setTeamkills(prsRound2.getTeamkills() - player.getTeamkills());
                prsRound2.calculateEfficiency();
                prsRound2.setGamepoints(prsRound2.getGamepoints() - player.getGamepoints());
                prsRound2.setGibs(prsRound2.getGibs() - player.getGibs());
                prsRound2.setDamageGiven(prsRound2.getDamageGiven() - player.getDamageGiven());
                prsRound2.setDamageReceived(prsRound2.getDamageReceived() - player.getDamageReceived());
                prsRound2.setDamageTeam(prsRound2.getDamageTeam() - player.getDamageTeam());
                continue block0;
            }
        }
    }

    private void showPlayers(Round round) {
        String side;
        Player player;
        PlayerRoundStats prs;
        Iterator i = round.getTeamA().iterator();
        while (i.hasNext()) {
            prs = (PlayerRoundStats)i.next();
            player = prs.getPlayer();
            side = round.getRound() == 1 ? "Allies" : "Axis";
        }
        i = round.getTeamB().iterator();
        while (i.hasNext()) {
            prs = (PlayerRoundStats)i.next();
            player = prs.getPlayer();
            if (round.getRound() == 1) {
                side = "Axis";
                continue;
            }
            String string = "Allies";
        }
    }

    private void addRoundEvents(Round round) {
        Object event;
        long preStartTime = round.getPreStart();
        long startTime = round.getStart();
        long endTime = round.getEnd();
        int preStartLine = round.getPreStartLine();
        int startLine = round.getStartLine();
        int endLine = round.getEndLine();
        if (round.getStartLine() == -1) {
            return;
        }
        Iterator i = this.playerRoundStats.iterator();
        while (i.hasNext()) {
            PlayerRoundStats prs = (PlayerRoundStats)i.next();
            if (prs.getLineNumber() < startLine) continue;
            if (prs.getLineNumber() > endLine) break;
            round.addEndOfRoundStats(prs);
        }
        i = this.gameEvents.iterator();
        while (i.hasNext()) {
            event = (GameEvent)i.next();
            if (((GameEvent)event).getLineNumber() < preStartLine) continue;
            if (((GameEvent)event).getLineNumber() > endLine) break;
            round.getGameEvents().add(event);
        }
        i = this.playerEvents.iterator();
        while (i.hasNext()) {
            event = (PlayerEvent)i.next();
            if (((PlayerEvent)event).getLineNumber() < startLine) continue;
            if (((PlayerEvent)event).getLineNumber() > endLine) break;
            round.getPlayerEvents().add(event);
        }
    }

    private int countKills(long startTime, long endTime) {
        int count = 0;
        Iterator i = this.playerEvents.iterator();
        while (i.hasNext()) {
            PlayerEvent event = (PlayerEvent)i.next();
            if (event.getTime() < startTime) continue;
            if (event.getTime() > endTime) break;
            if (!event.iskill()) continue;
            ++count;
        }
        return count;
    }

    public void calcAwards() {
    }

    public void loadDeathNotices() {
        Iterator j;
        Weapon weapon = null;
        this.weaponList.add(new Weapon("knf", "Knife", "knife", null, true, true, Weapon.LEVEL_KNIFE));
        this.weaponList.add(new Weapon("clt", "Colt", ".45ACP 1911", null, true, true, Weapon.LEVEL_PISTOL));
        this.weaponList.add(new Weapon("lgr", "Luger", "Luger 9mm", null, true, true, Weapon.LEVEL_PISTOL));
        this.weaponList.add(new Weapon("act", "Akimbo Colt", "Akimbo .45ACP 1911s", null, true, true, Weapon.LEVEL_PISTOL));
        this.weaponList.add(new Weapon("alg", "Akimbo Luger", "Akimbo Luger 9mms", null, true, true, Weapon.LEVEL_PISTOL));
        this.weaponList.add(new Weapon("tmpn", "Thompson", "Thompson", null, true, true, Weapon.LEVEL_SMG));
        this.weaponList.add(new Weapon("mp40", "MP40", "MP40", null, true, true, Weapon.LEVEL_SMG));
        this.weaponList.add(new Weapon("stn", "Sten", "Sten", null, true, false, Weapon.LEVEL_SMG));
        this.weaponList.add(new Weapon("fg42", "FG42", "FG42", null, true, false, Weapon.LEVEL_SMG));
        this.weaponList.add(new Weapon("k43", "K43", "K43", null, true, false, Weapon.LEVEL_RIFLE));
        this.weaponList.add(new Weapon("grnd", "Garand", "Garand", null, true, false, Weapon.LEVEL_RIFLE));
        this.weaponList.add(new Weapon("gnde", "Grenade", "grenade", "dove on his own grenade", true, false, Weapon.LEVEL_SPAM));
        this.weaponList.add(new Weapon("rgd", "Rifle Grenade", "rifle grenade", "ate his own rifle grenade", true, false, Weapon.LEVEL_SPAM));
        this.weaponList.add(new Weapon("dyn", "Dynamite", "dynamite", "dynamited himself to pieces", true, false, Weapon.LEVEL_SPAM));
        this.weaponList.add(new Weapon("mine", "Landmine", "Landmine", "failed to spot his own landmine", true, false, Weapon.LEVEL_SPAM));
        this.weaponList.add(new Weapon("pnz", "Panzerfaust", "Panzerfaust", "vaporized himself", true, false, Weapon.LEVEL_SPAM));
        this.weaponList.add(new Weapon("flm", "Flamethrower", "flamethrower", "played with fire", true, false, Weapon.LEVEL_SPAM));
        this.weaponList.add(new Weapon("mrtr", "Mortar", "mortar round coming", "never saw his own mortar round coming", true, false, Weapon.LEVEL_SPAM));
        weapon = new Weapon("mg-c", "MG42", "crew-served MG42", null, true, false, Weapon.LEVEL_SPAM);
        weapon.getLogNames().add("crew-served MG");
        this.weaponList.add(weapon);
        this.weaponList.add(new Weapon("mg-m", "Mobile MG42", "Mobile MG42", null, true, false, Weapon.LEVEL_SPAM));
        weapon = new Weapon("mg-t", "Tank MG42", "tank-mounted browning 30cal", null, true, false, Weapon.LEVEL_SPAM);
        weapon.getLogNames().add("tank-mounted MG42");
        this.weaponList.add(weapon);
        weapon = new Weapon("art", "Artillery", "artillery support", "ate his own artillery fire", true, false, Weapon.LEVEL_SPAM);
        weapon.getSuicideNames().add("fired-for-effect on himself");
        this.weaponList.add(weapon);
        weapon = new Weapon("air", "Airstrike", "support fire", "obliterated himself", true, false, Weapon.LEVEL_SPAM);
        weapon.getSuicideNames().add("danced on his airstrike marker");
        this.weaponList.add(weapon);
        this.weaponList.add(new Weapon("stch", "Satchel Charge", "Satchel Charge", "embraced his own satchel explosion", true, false, Weapon.LEVEL_SPAM));
        weapon = new Weapon("con", "Construction", "construction madness", "got buried under a pile of rubble", true, false, Weapon.LEVEL_SPAM);
        weapon.getSuicideNames().add("engineered himself into oblivion");
        this.weaponList.add(weapon);
        this.weaponList.add(new Weapon("", "Slash Kill", null, "killed himself", false, false, Weapon.LEVEL_SUICIDE));
        this.weaponList.add(new Weapon("", "Falling", null, "fell to his death", false, false, Weapon.LEVEL_SUICIDE));
        this.weaponList.add(new Weapon("", "Death", null, "died", false, false, Weapon.LEVEL_SUICIDE));
        this.weaponList.add(new Weapon("", "Killed", null, "was killed to death", false, false, Weapon.LEVEL_SUICIDE));
        this.weaponList.add(new Weapon("", "Moving Object", null, "was crushed", false, false, Weapon.LEVEL_SUICIDE));
        this.weaponList.add(new Weapon("", "Drowning", null, "drowned", false, false, Weapon.LEVEL_SUICIDE));
        Iterator i = this.weaponList.iterator();
        while (i.hasNext()) {
            weapon = (Weapon)i.next();
            if (!weapon.isWeapon()) continue;
            j = weapon.getLogNames().iterator();
            while (j.hasNext()) {
                this.weaponDescription.put(j.next(), weapon);
            }
        }
        i = this.weaponList.iterator();
        while (i.hasNext()) {
            weapon = (Weapon)i.next();
            j = weapon.getSuicideNames().iterator();
            while (j.hasNext()) {
                this.suicideWeaponsType.put(j.next(), weapon);
            }
        }
    }

    public void loadObjectiveNotices() {
        this.objectiveNotices.add(new ObjectiveNotice("Allied CP", "Allies", "Allied Command Post", "Allied Command Post constructed\\. Charge speed increased!", "Axis team has destroyed the Allied Command Post!", null, null, null, null));
    }

    public boolean ready() {
        return !this.shutdown && this.in != null;
    }

    private void beginFileInitialisation(String[] argv) {
        File dir;
        String tempdir = "";
        if (argv.length > 0) {
            this.filename = argv[0];
            this.consoleLog = new File(this.filename);
            if (!this.consoleLog.exists()) {
                Stats.outputln("Could not open file '" + this.consoleLog.getAbsolutePath() + "'.  Exiting.");
                this.shutdown = true;
                return;
            }
        } else {
            this.filename = "etconsole.log";
            this.consoleLog = new File(this.filename);
            if (!this.consoleLog.exists()) {
                this.filename = "etpro" + File.separatorChar + "etconsole.log";
                tempdir = "etpro";
                this.consoleLog = new File(this.filename);
                if (!this.consoleLog.exists()) {
                    Stats.outputln("Could not open file '" + this.consoleLog.getAbsolutePath() + "'.  Exiting.");
                    this.shutdown = true;
                    return;
                }
            }
        }
        if (argv.length > 1) {
            dir = new File(argv[1]);
            if (!dir.isDirectory()) {
                try {
                    dir = new File(dir.getCanonicalPath());
                    dir.mkdirs();
                }
                catch (Exception e) {
                    Stats.outputln("exception." + e.getMessage());
                }
                if (!dir.exists()) {
                    Stats.outputln("Could not create output directory '" + dir.getAbsolutePath() + "'.  Exiting.");
                    this.shutdown = true;
                    return;
                }
            }
            this.outfilename = dir.getAbsolutePath();
        } else {
            this.outfilename = tempdir;
            if (!"".equals(this.outfilename)) {
                this.outfilename = String.valueOf(this.outfilename) + File.separatorChar;
            }
            this.outfilename = String.valueOf(this.outfilename) + "html";
            dir = new File(this.outfilename);
            dir.mkdirs();
        }
        if (!this.shutdown) {
            dir = new File(String.valueOf(this.outfilename) + File.separatorChar + "css");
            dir.mkdirs();
            dir = new File(String.valueOf(this.outfilename) + File.separatorChar + "js");
            dir.mkdirs();
            dir = new File(String.valueOf(this.outfilename) + File.separatorChar + "images");
            dir.mkdirs();
            FileOutputStream fos = null;
            InputStream is = null;
            try {
                JarFile jarfile = new JarFile(String.valueOf(NAME_SHORT) + ".jar", false);
                byte[] bytes = new byte[8092];
                Enumeration<JarEntry> enumeration = jarfile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry entry = enumeration.nextElement();
                    if (!entry.getName().startsWith("html/")) continue;
                    String filename = entry.getName();
                    filename = filename.substring("html/".length());
                    File file = new File(String.valueOf(this.outfilename) + File.separatorChar + filename);
                    if (file.exists()) continue;
                    fos = new FileOutputStream(file);
                    is = jarfile.getInputStream(entry);
                    int i = 0;
                    while ((i = is.read(bytes)) > 0) {
                        fos.write(bytes, 0, i);
                    }
                    fos.close();
                    is.close();
                }
            }
            catch (IOException e) {
                Stats.outputln("Could not open " + NAME_SHORT + ".jar.  Stylesheets, images and javascript files will not be checked or written out.");
            }
        }
        Stats.outputln("Reading Logfile: " + this.consoleLog.getAbsolutePath());
        long fileSize = this.consoleLog.length();
        this.filedate = this.consoleLog.lastModified();
        try {
            this.in = new BufferedReader(new FileReader(this.consoleLog));
        }
        catch (Exception e) {
            this.shutdown = true;
            Stats.outputln("exception: " + e.getMessage());
        }
    }

    private void waitFileReset() {
        try {
            while (this.fileSize > 0L) {
                this.fileSize = this.consoleLog.length();
                Thread.sleep(10L);
            }
            while (this.fileSize == 0L) {
                this.fileSize = this.consoleLog.length();
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            this.shutdown = true;
            System.out.println("exception: " + e.getMessage());
        }
    }

    private String readLine() {
        String line = "";
        try {
            if (!this.in.ready()) {
                this.shutdown = true;
                line = "";
            } else {
                line = this.in.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.shutdown = true;
            System.out.println("exception: " + e.getMessage());
        }
        return line;
    }

    public static String removeColourCodes(String str) {
        String result = "";
        String[] split = str.split("\\^\\^", -1);
        Pattern p = Pattern.compile("\\^.");
        int i = 0;
        while (i < split.length) {
            if (i > 0) {
                result = String.valueOf(result) + "^";
            }
            Matcher m = p.matcher(split[i]);
            result = String.valueOf(result) + m.replaceAll("");
            ++i;
        }
        return result;
    }

    public static boolean isAlliedOffence(String map) {
        if ("mml_church_et_v1".equals(map)) {
            return false;
        }
        if ("railgun".equals(map)) {
            return false;
        }
        if ("caen".equals(map)) {
            return false;
        }
        if ("omg_caen".equals(map)) {
            return false;
        }
        if ("vengeance_final".equals(map)) {
            return false;
        }
        return !"et_ice".equals(map);
    }

    public static String teamOnOffence(String map) {
        if (Stats.isAlliedOffence(map)) {
            return "Allies";
        }
        return "Axis";
    }

    private static void startWindow() {
        frame.setTitle(String.valueOf(NAME_LONG) + " v" + VERSION);
        frame.setDefaultCloseOperation(3);
        Container cp = frame.getContentPane();
        JPanel panel = new JPanel();
        cp.add("North", panel);
        results = new JTextArea(20, 60);
        cp.add("Center", new JScrollPane(results));
        frame.pack();
        double height = frame.getToolkit().getScreenSize().getHeight();
        double width = frame.getToolkit().getScreenSize().getWidth();
        frame.setLocation((int)(width - (double)frame.getWidth()) / 2, (int)(height - (double)frame.getHeight()) / 2);
        frame.setVisible(true);
    }

    private static void closeWindow() {
        frame.setVisible(false);
        frame.dispose();
    }

    public static void outputln(String text) {
        results.append(String.valueOf(text) + "\n");
        System.out.println(text);
    }

    public static void output(String text) {
        results.append(text);
        System.out.print(text);
    }

    public static int getLineCount() {
        return LINE_COUNT;
    }

    public static void incLineCount() {
        ++LINE_COUNT;
    }

    public static void main(String[] argv) {
        Stats.startWindow();
        Stats.outputln(NAME_LONG);
        Stats.outputln("Version: " + VERSION);
        Stats stats = new Stats();
        stats.beginFileInitialisation(argv);
        stats.loadDeathNotices();
        stats.loadObjectiveNotices();
        if (!stats.shutdown) {
            Stats.outputln("Reading logfile events...");
            stats.parse();
            Stats.outputln("Processing events...");
            stats.analyse();
            if (stats.summary.getGames().size() > 0) {
                HtmlOutput output = new HtmlOutput();
                Stats.outputln("Generating statistics in html...");
                output.write(stats.summary, stats.outfilename);
            } else {
                Stats.outputln("No games found.  Please check it processed the correct log file - look in /etmain or /etpro.");
            }
            Stats.outputln("Finished writing file");
        } else {
            Stats.outputln("Finished");
        }
        Stats.outputln(">>> Thank you for using StatWhore by bS!4.ni.k8.or - http://homepages.paradise.net.nz/kumachan/StatWhore/");
    }
}

