/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Players {
    Map players = new HashMap();
    String teamATag = "";
    String teamBTag = "";
    int teamAScore = 0;
    int teamBScore = 0;
    int draws = 0;

    public Player playerSearch(String name) {
        Player player = null;
        if (this.players.containsKey(name)) {
            return (Player)this.players.get(name);
        }
        Iterator i = this.players.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            player = (Player)entry.getValue();
            if (!this.shortName(name).equals(player.getShortName())) continue;
            return player;
        }
        return null;
    }

    public Player playerSearchStats(String name) {
        Player player = null;
        Iterator i = this.players.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            player = (Player)entry.getValue();
            if (!name.equals(player.getStatName().trim())) continue;
            return player;
        }
        return null;
    }

    public Player playerSearchAdd(String name) {
        Player player = this.playerSearch(name);
        if (player == null) {
            player = new Player(name);
            this.addPlayer(player);
        }
        return player;
    }

    public void addPlayer(Player player) {
        if (!this.players.containsKey(player.getName())) {
            this.players.put(player.getName(), player);
        }
    }

    public void renamePlayer(String oldName, String newName) {
        Player player = this.playerSearchAdd(oldName);
        this.removePlayer(player);
        player.setName(newName);
        this.addPlayer(player);
    }

    public void removePlayer(Player player) {
        this.players.remove(player.getName());
    }

    public String shortName(String name) {
        int length = name.length() > 29 ? 29 : name.length();
        return name.substring(0, length);
    }

    public Map getPlayers() {
        return this.players;
    }

    public String getTeamTag(String team) {
        if ("".equals(this.teamATag)) {
            this.parseTeamTag();
        }
        if (Player.TEAM_A.equals(team)) {
            return this.teamATag;
        }
        return this.teamBTag;
    }

    public void parseTeamTag() {
        ArrayList<String> teamA = new ArrayList<String>();
        ArrayList<String> teamB = new ArrayList<String>();
        Iterator i = this.players.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Player player = (Player)entry.getValue();
            if (player.isTeamA()) {
                teamA.add(player.getCleanName());
                continue;
            }
            if (!player.isTeamB()) continue;
            teamB.add(player.getCleanName());
        }
        this.teamATag = this.findCommonTagPart(teamA, "TeamA");
        this.teamBTag = this.findCommonTagPart(teamB, "TeamB");
    }

    private String findCommonTagPart(List tags, String defaultTag) {
        int count;
        Pattern findTeamTagPattern = Pattern.compile("(?i:(.*)(.+)),(?i:(\\1)(.+))");
        HashMap<String, Integer> startTags = new HashMap<String, Integer>();
        HashMap<String, Integer> endTags = new HashMap<String, Integer>();
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            String tagToCheck = (String)i.next();
            Iterator j = tags.iterator();
            while (j.hasNext()) {
                String match;
                String checkAgainst = (String)j.next();
                if (tagToCheck.equals(checkAgainst)) continue;
                Matcher matcher = findTeamTagPattern.matcher(String.valueOf(tagToCheck) + "," + checkAgainst);
                if (matcher.matches() && (match = matcher.group(1)) != null && !"".equals(match)) {
                    count = 0;
                    if (startTags.containsKey(match)) {
                        count = (Integer)startTags.get(match);
                    }
                    startTags.put(match, new Integer(count + 1));
                }
                if (!(matcher = findTeamTagPattern.matcher(String.valueOf(new StringBuffer(tagToCheck).reverse().toString()) + "," + new StringBuffer(checkAgainst).reverse().toString())).matches() || (match = matcher.group(1)) == null || "".equals(match)) continue;
                match = new StringBuffer(match).reverse().toString();
                count = 0;
                if (endTags.containsKey(match)) {
                    count = (Integer)endTags.get(match);
                }
                endTags.put(match, new Integer(count + 1));
            }
        }
        int startMax = 0;
        String startTag = "";
        Iterator i2 = startTags.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry entry = i2.next();
            String possibleTag = (String)entry.getKey();
            count = (Integer)entry.getValue();
            if (count <= startMax) continue;
            startMax = count;
            startTag = possibleTag.trim();
        }
        if (startMax < tags.size() / 2 * (tags.size() / 2)) {
            startTag = "";
        }
        int endMax = 0;
        String endTag = "";
        Iterator i3 = endTags.entrySet().iterator();
        while (i3.hasNext()) {
            Map.Entry entry = i3.next();
            String possibleTag = (String)entry.getKey();
            int count2 = (Integer)entry.getValue();
            if (count2 <= endMax) continue;
            endMax = count2;
            endTag = possibleTag.trim();
        }
        if (endMax > tags.size() / 2 * (tags.size() / 2)) {
            startTag = String.valueOf(startTag) + endTag;
        }
        if (startTag == null || "".equals(startTag)) {
            return defaultTag;
        }
        return startTag;
    }

    public int getDraws() {
        return this.draws;
    }

    public void setDraws(int draws) {
        this.draws = draws;
    }

    public void incrementDraws() {
        ++this.draws;
    }

    public int getTeamAScore() {
        return this.teamAScore;
    }

    public void setTeamAScore(int teamAScore) {
        this.teamAScore = teamAScore;
    }

    public void incrementTeamAScore() {
        ++this.teamAScore;
    }

    public int getTeamBScore() {
        return this.teamBScore;
    }

    public void setTeamBScore(int teamBScore) {
        this.teamBScore = teamBScore;
    }

    public void incrementTeamBScore() {
        ++this.teamBScore;
    }

    public int findMaxStat(String stat) {
        int max = 0;
        Iterator i = this.players.entrySet().iterator();
        while (i.hasNext()) {
            boolean count = false;
            Map.Entry entry = i.next();
            Player player = (Player)entry.getValue();
            if (!player.isInTeam()) continue;
            PlayerRoundStats stats = player.getStatsTotal();
            max = Math.max(max, this.getStatName(stat, stats));
        }
        return max;
    }

    public int findMinStat(String stat) {
        int min = 1000000000;
        Iterator i = this.players.entrySet().iterator();
        while (i.hasNext()) {
            boolean count = false;
            Map.Entry entry = i.next();
            Player player = (Player)entry.getValue();
            if (!player.isInTeam()) continue;
            PlayerRoundStats stats = player.getStatsTotal();
            min = Math.min(min, this.getStatName(stat, stats));
        }
        return min;
    }

    public List findPlayerWithStat(String stat, int value) {
        ArrayList<Player> result = new ArrayList<Player>();
        Iterator i = this.players.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Player player = (Player)entry.getValue();
            if (!player.isInTeam()) continue;
            PlayerRoundStats stats = player.getStatsTotal();
            int playerStat = 0;
            playerStat = this.getStatName(stat, stats);
            if (playerStat != value) continue;
            result.add(stats.getPlayer());
        }
        return result;
    }

    public List findPlayerWithMinStat(String stat, int value) {
        ArrayList<Player> result = new ArrayList<Player>();
        Iterator i = this.players.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Player player = (Player)entry.getValue();
            if (!player.isInTeam()) continue;
            PlayerRoundStats stats = player.getStatsTotal();
            int playerStat = 0;
            playerStat = this.getStatName(stat, stats);
            if (playerStat < value) continue;
            result.add(stats.getPlayer());
        }
        return result;
    }

    public int findAvgStat(String stat) {
        ArrayList result = new ArrayList();
        int total = 0;
        int count = 0;
        Iterator i = this.players.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Player player = (Player)entry.getValue();
            if (!player.isInTeam()) continue;
            PlayerRoundStats stats = player.getStatsTotal();
            total += this.getStatName(stat, stats);
            ++count;
        }
        return count > 0 ? total / count : total;
    }

    private int getStatName(String stat, PlayerRoundStats prs) {
        if ("kills".equals(stat)) {
            return prs.getKills();
        }
        if ("deaths".equals(stat)) {
            return prs.getDeaths();
        }
        if ("kdk".equals(stat)) {
            return prs.getKilledBeforeKillMax();
        }
        if ("kkd".equals(stat)) {
            return prs.getKillBeforeKilledMax();
        }
        if ("1kill".equals(stat)) {
            return prs.getKillBeforeKilled().getIndex(1);
        }
        if ("4kill".equals(stat)) {
            return prs.getKillBeforeKilled().getIndex(4);
        }
        if ("eff".equals(stat)) {
            return prs.getEfficiency();
        }
        if ("xp".equals(stat)) {
            return prs.getScore();
        }
        if ("/kill".equals(stat)) {
            return prs.getSlashkills();
        }
        if ("gib".equals(stat)) {
            return prs.getGibs();
        }
        if ("d/kd".equals(stat)) {
            return prs.getDamageReceived() / (prs.getDeaths() == 0 ? 1 : prs.getDeaths());
        }
        if ("gib/k".equals(stat)) {
            return prs.getPercentOfKills(prs.getGibs());
        }
        if ("tk".equals(stat)) {
            return prs.getTeamkills();
        }
        if ("knifed".equals(stat)) {
            return prs.getWeaponKilled().getIndex(Weapon.LEVEL_KNIFE);
        }
        if ("knife".equals(stat)) {
            return prs.getWeaponKill().getIndex(Weapon.LEVEL_KNIFE);
        }
        if ("smg".equals(stat)) {
            return prs.getWeaponKill().getIndex(Weapon.LEVEL_SMG);
        }
        if ("spam".equals(stat)) {
            return prs.getWeaponKill().getIndex(Weapon.LEVEL_SPAM);
        }
        if ("d/k".equals(stat)) {
            return prs.getDamageGiven() / (prs.getKills() == 0 ? 1 : prs.getKills());
        }
        return 0;
    }
}

