/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HtmlOutput {
    PrintWriter os = null;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(MatchSummary summary, String pathname) {
        Object consoleLog = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            try {
                pathname = pathname == null || "".equals(pathname) ? "" : String.valueOf(pathname) + File.separatorChar;
                new File(pathname).mkdirs();
                pathname = String.valueOf(pathname) + this.getOutputFilename(summary);
                Stats.outputln("Generated statistics filename: " + new File(pathname).getAbsolutePath());
                this.os = new PrintWriter((Writer)new FileWriter(pathname), true);
                String result = "";
                if (summary.getDraws() > 0) {
                    result = String.valueOf(result) + "-" + summary.getDraws();
                }
                result = summary.getTeamAScore() > summary.getTeamBScore() ? String.valueOf(summary.getTeamAScore()) + "-" + summary.getTeamBScore() + result + " to " + summary.getTeamATag() : (summary.getTeamBScore() > summary.getTeamAScore() ? String.valueOf(summary.getTeamBScore()) + "-" + summary.getTeamAScore() + result + " to " + summary.getTeamBTag() : String.valueOf(summary.getTeamBScore()) + "-" + summary.getTeamAScore() + result + " draw");
                String title = String.valueOf(HtmlOutput.encode(Stats.NAME_SHORT)) + ": " + sdf.format(summary.getGameDate()) + " " + HtmlOutput.encode(summary.getTeamATag()) + " vs " + HtmlOutput.encode(summary.getTeamBTag()) + " on " + HtmlOutput.encode(summary.getMap()) + " (" + HtmlOutput.encode(result) + ")";
                this.os.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.os.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
                this.os.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
                this.os.println("<head>");
                this.os.println("    <title>" + title + "</title>");
                this.os.println("    <meta name=\"generated by\" content=\"" + HtmlOutput.encode(Stats.NAME_LONG) + "\" />");
                this.os.println("    <meta name=\"version\" content=\"" + HtmlOutput.encode(Stats.VERSION) + "\" />");
                this.os.println("    <meta name=\"date\" content=\"" + HtmlOutput.encode(new Date().toString()) + "\" />");
                this.os.println("    <link rel=\"stylesheet\" type=\"text/css\" href=\"css/layout.css\" />");
                this.os.println("    <link rel=\"stylesheet\" type=\"text/css\" href=\"css/style.css\" />");
                this.os.println("    <link rel=\"stylesheet\" type=\"text/css\" href=\"css/sortabletable.css\" />");
                this.os.println("    <script type=\"text/javascript\" src=\"js/sortabletable.js\"></script>");
                this.os.println("    <script type=\"text/javascript\">");
                this.os.println("      //<![CDATA[");
                this.os.println("    function setTogglePlayers(obj, bool){");
                this.os.println("      objAxis=document.getElementById(obj+'Axis');");
                this.os.println("        objAllies=document.getElementById(obj+'Allies');");
                this.os.println("        objMinus=document.getElementById(obj+'minus');");
                this.os.println("        objPlus=document.getElementById(obj+'plus');");
                this.os.println("        if(bool == false){");
                this.os.println("          objAxis.style.display='none';");
                this.os.println("          objAllies.style.display='none';");
                this.os.println("          objMinus.style.display='none';");
                this.os.println("          objPlus.style.display='inline';");
                this.os.println("        } else { ");
                this.os.println("          objAxis.style.display='table-header-group';");
                this.os.println("          objAllies.style.display='table-header-group';");
                this.os.println("          objMinus.style.display='inline';");
                this.os.println("          objPlus.style.display='none';");
                this.os.println("        }");
                this.os.println("    }");
                this.os.println("    //]]>");
                this.os.println("    </script>");
                this.os.println("</head>");
                this.os.println("<body>");
                this.os.println("<h1>" + title + "</h1>");
                this.scoreboardDisplay(summary);
                this.awardsDisplay(summary);
                List<PlayerRoundStats> team = new ArrayList<PlayerRoundStats>();
                Iterator i = summary.getTeamAPlayers().iterator();
                while (true) {
                    if (!i.hasNext()) break;
                    team.add(((Player)i.next()).getStatsTotal());
                }
                Collections.sort(team);
                Collections.reverse(team);
                String tableId = "playerSummaryTable";
                String teamId = "teamA";
                this.resultsTableHeader(tableId, teamId, "Player summary for all games", false, true);
                this.resultsTableLineLoop(String.valueOf(teamId) + "Axis", "", team, null, false, true);
                this.resultsTableTotal(teamId, "", HtmlOutput.encode(summary.getTeamATag()), summary.getTeamATotal(), false, true);
                team = new ArrayList();
                Iterator i2 = summary.getTeamBPlayers().iterator();
                while (true) {
                    if (!i2.hasNext()) break;
                    team.add(((Player)i2.next()).getStatsTotal());
                }
                Collections.sort(team);
                Collections.reverse(team);
                this.resultsTableLineLoop(String.valueOf(teamId) + "Allies", "", team, null, false, true);
                this.resultsTableTotal(teamId, "", HtmlOutput.encode(summary.getTeamBTag()), summary.getTeamBTotal(), false, true);
                this.resultsTableFooter(tableId, false, true);
                this.weaponDisplay(summary);
                int gameCount = 0;
                Iterator i3 = summary.getGames().iterator();
                while (true) {
                    PlayerRoundStats total;
                    List events;
                    if (!i3.hasNext()) {
                        this.messageLogDisplay(summary.getMessages(), summary.getGames());
                        this.os.println("<p><span class=\"logo\" style=\"border: 1px dashed black; padding: 2px;\"><a href=\"http://homepages.paradise.net.nz/kumachan/StatWhore/\" title=\"" + HtmlOutput.encode(Stats.NAME_LONG) + "\">" + HtmlOutput.encode(Stats.NAME_SHORT) + "</a></span>");
                        this.os.println("<a href=\"http://validator.w3.org/check/referer\"><img src=\"http://www.w3.org/Icons/valid-xhtml10\" alt=\"Valid XHTML 1.0!\" height=\"31\" width=\"88\" class=\"logo\"/></a>");
                        this.os.println("<a href=\"http://jigsaw.w3.org/css-validator/\"><img style=\"width:88px;height:31px\" src=\"http://jigsaw.w3.org/css-validator/images/vcss\" alt=\"Valid CSS!\" class=\"logo\"/></a>");
                        this.os.println("<a href=\"http://www.mozilla.org/products/firefox/\" title=\"Get Firefox - Web Browsing Redefined\"><img src=\"http://www.mozilla.org/products/firefox/buttons/getfirefox_88x31.png\" width=\"88\" height=\"31\" class=\"logo\" alt=\"Get Firefox\" /></a>");
                        this.os.println("<span class=\"logo\" style=\"border: 1px dashed black; padding: 2px;\"><a href=\"http://webfx.eae.net/dhtml/sortabletable/sortabletable.html\" title=\"WebFX Sortable Table - GPL JavaScript DOM Level 1 Table element sort\">WebFX Sortable Table</a></span></p>");
                    }
                    Game game = (Game)i3.next();
                    this.os.println("<fieldset><legend>Game " + ++gameCount + "</legend>");
                    Round round = game.getRound1();
                    if (round != null) {
                        events = round.getPlayerEvents();
                        team = round.getTeamA();
                        total = round.getTeamATotal();
                        teamId = "g" + gameCount + "r1";
                        tableId = String.valueOf(teamId) + "Table";
                        this.resultsTableHeader(tableId, teamId, "Round 1 Duration: " + round.getTime(), true, false);
                        this.resultsTableLineLoop(teamId, round.getSideTeamA(), team, events, true, false);
                        this.resultsTableTotal(teamId, round.getSideTeamA(), HtmlOutput.encode(summary.getTeamATag()), round.getTeamATotal(), true, false);
                        team = round.getTeamB();
                        total = round.getTeamBTotal();
                        this.resultsTableLineLoop(teamId, round.getSideTeamB(), team, events, true, false);
                        this.resultsTableTotal(teamId, round.getSideTeamB(), HtmlOutput.encode(summary.getTeamBTag()), round.getTeamBTotal(), true, false);
                        this.resultsTableFooter(tableId, true, false);
                    }
                    if ((round = game.getRound2()) != null) {
                        events = round.getPlayerEvents();
                        team = round.getTeamA();
                        total = round.getTeamATotal();
                        teamId = "g" + gameCount + "r2";
                        tableId = String.valueOf(teamId) + "Table";
                        this.resultsTableHeader(tableId, teamId, "Round 2 Duration: " + round.getTime(), true, false);
                        this.resultsTableLineLoop(teamId, round.getSideTeamA(), team, events, true, false);
                        this.resultsTableTotal(teamId, round.getSideTeamA(), HtmlOutput.encode(summary.getTeamATag()), round.getTeamATotal(), true, false);
                        team = round.getTeamB();
                        total = round.getTeamBTotal();
                        this.resultsTableLineLoop(teamId, round.getSideTeamB(), team, events, true, false);
                        this.resultsTableTotal(teamId, round.getSideTeamB(), HtmlOutput.encode(summary.getTeamBTag()), round.getTeamBTotal(), true, false);
                        this.resultsTableFooter(tableId, true, false);
                    }
                    this.os.println("</fieldset>");
                }
            }
            catch (IOException e) {
                Stats.outputln("exception: " + e.getMessage());
            }
            catch (Exception e) {
                Stats.outputln("exception: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            this.os.println("</body>");
            this.os.println("</html>");
            this.os.close();
            throw throwable;
        }
        {
            Object var16_21 = null;
            this.os.println("</body>");
            this.os.println("</html>");
            this.os.close();
            return;
        }
    }

    public static String encode(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    private void resultsTableHeader(String tableId, String id, String title, boolean showEvents, boolean showKillDistribution) {
        this.os.println("<table id=\"" + tableId + "\" class=\"results\" rules=\"groups\" frame=\"void\" border=\"1\" cellspacing=\"0\">");
        this.os.println("  <caption>" + title + "</caption>");
        this.os.println("  <colgroup span=\"2\"/>");
        this.os.println("  <colgroup span=\"2\"/>");
        this.os.println("  <colgroup span=\"6\"/>");
        this.os.println("  <colgroup span=\"3\"/>");
        this.os.println("  <colgroup span=\"4\"/>");
        if (showKillDistribution) {
            this.os.println("  <colgroup span=\"3\"/>");
            this.os.println("  <colgroup span=\"11\"/>");
        }
        if (showEvents) {
            this.os.println("  <colgroup />");
        }
        this.os.println("  <thead>");
        this.os.println("    <tr>");
        this.os.println("      <th class=\"button\"><span id=\"" + id + "minus\" class=\"hidebutton\" title=\"click to hide player details\" onmousedown=\"setTogglePlayers('" + id + "',false)\">-</span>" + "<span  id=\"" + id + "plus\" class=\"showbutton\" title=\"click to show player details\" onmousedown=\"setTogglePlayers('" + id + "',true)\">+</span>" + "</th>");
        this.os.println("      <th class=\"playername\" title=\"click to sort\">Name</th>");
        this.os.println("      <th title=\"Efficiency - kills/(killed+suicides) - click to sort\">%Eff</th>");
        this.os.println("      <th title=\"XP - Points awarded for revives, kills etc - click to sort\">XP</th>");
        this.os.println("      <th class=\"graph\" title=\"Kills - number of times player has killed an enemy player - click to sort\"><span class=\"k\">K</span></th>");
        this.os.println("      <th class=\"graph\"  title=\"Killed - number of times player has been killed by an enemy player - click to sort\"><span class=\"kd\">Kd</span></th>");
        this.os.println("      <th title=\"Gibs - number of times player has gibbed an enemy player - click to sort\">Gib</th>");
        this.os.println("      <th class=\"graph\"  title=\"Suicide - number of times player has killed themselves accidentally - click to sort\"><span class=\"s\">Sui</span></th>");
        this.os.println("      <th class=\"graph\"  title=\"Team Kills - number of times player has killed a teammate - click to sort\"><span class=\"tk\">TK</span></th>");
        this.os.println("      <th class=\"graph\"  title=\"Slash Kills - number of times player has wilfully killed themselves - click to sort\"><span class=\"sk\">/K</span></th>");
        this.os.println("      <th title=\"Damage Given - amount of damage done to enemy players - click to sort\">DG</th>");
        this.os.println("      <th title=\"Damage Received - amount of damage received from enemy players - click to sort\">DR</th>");
        this.os.println("      <th title=\"Team Damage - amount of damage done to teammates - click to sort\">TD</th>");
        this.os.println("      <th title=\"Knife - kills/killed\">Knf</th>");
        this.os.println("      <th title=\"Pistol/Rifle - kills/killed\">P/R</th>");
        this.os.println("      <th title=\"SMG - including FG42 and Sten - kills/killed\">SMG</th>");
        this.os.println("      <th title=\"SPAM - including landmines, grenades - kills/killed\">SPM</th>");
        if (showKillDistribution) {
            this.os.println("      <th title=\"Damage Given per Kill - click to sort\">D/K</th>");
            this.os.println("      <th title=\"Damage Received per time Killed - click to sort\">D/Kd</th>");
            this.os.println("      <th title=\"Gibs per kill - click to sort\">%G/K</th>");
            this.os.println("      <th title=\"Max Killed before killing - click to sort\">KdK</th>");
            this.os.println("      <th title=\"Killed 4+ times before killing - click to sort\">-4</th>");
            this.os.println("      <th title=\"Killed 3 times before killing - click to sort\">-3</th>");
            this.os.println("      <th title=\"Killed 2 times before killing - click to sort\">-2</th>");
            this.os.println("      <th title=\"Killed 1 time before killing - click to sort\">-1</th>");
            this.os.println("      <th title=\"0 Kills before killed - click to sort\">0K</th>");
            this.os.println("      <th title=\"1 Kill before killed - click to sort\">1</th>");
            this.os.println("      <th title=\"2 Kills before killed - click to sort\">2</th>");
            this.os.println("      <th title=\"3 Kills before killed - click to sort\">3</th>");
            this.os.println("      <th title=\"4+ Kills before killed - click to sort\">4+</th>");
            this.os.println("      <th title=\"Max Kills before Killed - click to sort\">KKd</th>");
        }
        if (showEvents) {
            this.os.println("      <th title=\"Events display\">Events</th>");
        }
        this.os.println("    </tr>");
        this.os.println("  </thead>");
    }

    private void resultsTableTotal(String id, String side, String tag, PlayerRoundStats total, boolean showEvents, boolean showKillDistribution) {
        this.os.println("  <tbody title=\"" + side + "\" class=\"" + side + "Total\">");
        this.os.print("    <tr>");
        this.os.print("<td></td><td class=\"playername\">" + tag + "</td>" + "<td>" + total.getEfficiency() + "</td>" + "<td>" + total.getScore() + "</td>" + "<td>" + total.getKills() + "</td>" + "<td>" + total.getDeaths() + "</td>" + "<td>" + total.getGibs() + "</td>" + "<td>" + total.getSuicides() + "</td>" + "<td>" + total.getTeamkills() + "</td>" + "<td>" + total.getSlashkills() + "</td>" + "<td>" + total.getDamageGiven() + "</td>" + "<td>" + total.getDamageReceived() + "</td>" + "<td>" + total.getDamageTeam() + "</td>" + "<td>" + total.getPercentOfKills(total.getWeaponKill().getIndex(0)) + "/" + total.getPercentOfDeaths(total.getWeaponKilled().getIndex(0)) + "%</td>" + "<td>" + total.getPercentOfKills(total.getWeaponKill().getIndex(1)) + "/" + total.getPercentOfDeaths(total.getWeaponKilled().getIndex(1)) + "%</td>" + "<td>" + total.getPercentOfKills(total.getWeaponKill().getIndex(2)) + "/" + total.getPercentOfDeaths(total.getWeaponKilled().getIndex(2)) + "%</td>" + "<td>" + total.getPercentOfKills(total.getWeaponKill().getIndex(3)) + "/" + total.getPercentOfDeaths(total.getWeaponKilled().getIndex(3)) + "%</td>");
        if (showKillDistribution) {
            this.os.print("<td>" + total.getDamageGiven() / (total.getKills() == 0 ? 1 : total.getKills()) + "</td>");
            this.os.print("<td>" + total.getDamageReceived() / (total.getDeaths() == 0 ? 1 : total.getDeaths()) + "</td>");
            this.os.print("<td>" + total.getPercentOfTotal(total.getGibs(), total.getKills() == 0 ? 1 : total.getKills()) + "</td>");
            this.os.print("<td>" + total.getKilledBeforeKillMax() + "</td>");
            this.os.print("<td>" + total.getKilledBeforeKill().getIndex(4) + "</td>");
            this.os.print("<td>" + total.getKilledBeforeKill().getIndex(3) + "</td>");
            this.os.print("<td>" + total.getKilledBeforeKill().getIndex(2) + "</td>");
            this.os.print("<td>" + total.getKilledBeforeKill().getIndex(1) + "</td>");
            this.os.print("<td>" + total.getKillBeforeKilled().getIndex(0) + "</td>");
            this.os.print("<td>" + total.getKillBeforeKilled().getIndex(1) + "</td>");
            this.os.print("<td>" + total.getKillBeforeKilled().getIndex(2) + "</td>");
            this.os.print("<td>" + total.getKillBeforeKilled().getIndex(3) + "</td>");
            this.os.print("<td>" + total.getKillBeforeKilled().getIndex(4) + "</td>");
            this.os.print("<td>" + total.getKillBeforeKilledMax() + "</td>");
        }
        if (showEvents) {
            this.os.print("<td></td>");
        }
        this.os.println("</tr>");
        this.os.println("  </tbody>");
    }

    private void resultsTableFooter(String tableId, boolean showEvents, boolean showKillDistribution) {
        this.os.println("</table>");
        this.os.println("  <script type=\"text/javascript\">");
        this.os.println("    //<![CDATA[");
        this.os.print("    var st" + tableId + " = new SortableTable(document.getElementById(\"" + tableId + "\"),[\"None\",\"CaseInsensitiveString\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"None\", \"None\", \"None\", \"None\"");
        if (showKillDistribution) {
            this.os.print(", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\"");
        }
        this.os.println("]);");
        this.os.println("    //]]>");
        this.os.println("  </script>");
    }

    private void resultsTableLineLoop(String bodyId, String side, List team, List events, boolean showEvents, boolean showKillDistribution) {
        this.os.println("  <tbody id=\"" + HtmlOutput.encode(String.valueOf(bodyId) + side) + "\"  title=\"" + side + "\" class=\"" + side + "Data\" >");
        Iterator i = team.iterator();
        while (i.hasNext()) {
            PlayerRoundStats prs = (PlayerRoundStats)i.next();
            this.resultsTableLine(prs, events, showEvents, showKillDistribution);
        }
        this.os.println("  </tbody>");
    }

    private void resultsTableLine(PlayerRoundStats prs, List events, boolean showEvents, boolean showKillDistribution) {
        this.os.print("    <tr>");
        this.os.print("<td></td><td class=\"playername\">" + HtmlOutput.htmlWolfColours(prs.getPlayer().getName()) + "</td>" + "<td>" + prs.getEfficiency() + "</td>" + "<td>" + prs.getScore() + "</td>" + "<td>" + prs.getKills() + "</td>" + "<td>" + prs.getDeaths() + "</td>" + "<td>" + prs.getGibs() + "</td>" + "<td>" + prs.getSuicides() + "</td>" + "<td>" + prs.getTeamkills() + "</td>" + "<td>" + prs.getSlashkills() + "</td>" + "<td>" + prs.getDamageGiven() + "</td>" + "<td>" + prs.getDamageReceived() + "</td>" + "<td>" + prs.getDamageTeam() + "</td>" + "<td>" + prs.getWeaponKill().getIndex(0) + "/" + prs.getWeaponKilled().getIndex(0) + "</td>" + "<td>" + prs.getWeaponKill().getIndex(1) + "/" + prs.getWeaponKilled().getIndex(1) + "</td>" + "<td>" + prs.getWeaponKill().getIndex(2) + "/" + prs.getWeaponKilled().getIndex(2) + "</td>" + "<td>" + prs.getWeaponKill().getIndex(3) + "/" + prs.getWeaponKilled().getIndex(3) + "</td>");
        if (showKillDistribution) {
            this.os.print("<td>" + prs.getDamageGiven() / (prs.getKills() == 0 ? 1 : prs.getKills()) + "</td>");
            this.os.print("<td>" + prs.getDamageReceived() / (prs.getDeaths() == 0 ? 1 : prs.getDeaths()) + "</td>");
            this.os.print("<td>" + prs.getPercentOfTotal(prs.getGibs(), prs.getKills() == 0 ? 1 : prs.getKills()) + "</td>");
            this.os.print("<td>" + prs.getKilledBeforeKillMax() + "</td>");
            this.os.print("<td>" + prs.getKilledBeforeKill().getIndex(4) + "</td>");
            this.os.print("<td>" + prs.getKilledBeforeKill().getIndex(3) + "</td>");
            this.os.print("<td>" + prs.getKilledBeforeKill().getIndex(2) + "</td>");
            this.os.print("<td>" + prs.getKilledBeforeKill().getIndex(1) + "</td>");
            this.os.print("<td>" + prs.getKillBeforeKilled().getIndex(0) + "</td>");
            this.os.print("<td>" + prs.getKillBeforeKilled().getIndex(1) + "</td>");
            this.os.print("<td>" + prs.getKillBeforeKilled().getIndex(2) + "</td>");
            this.os.print("<td>" + prs.getKillBeforeKilled().getIndex(3) + "</td>");
            this.os.print("<td>" + prs.getKillBeforeKilled().getIndex(4) + "</td>");
            this.os.print("<td>" + prs.getKillBeforeKilledMax() + "</td>");
        }
        if (showEvents) {
            this.os.print("<td class=\"graph\">" + this.eventDisplay(events, prs.getPlayer()) + "</td>");
        }
        this.os.println("</tr>");
    }

    private void messageLogDisplay(List messageEvents, List games) {
        boolean game = false;
        boolean round = false;
        long startTime = 0L;
        long endTime = 0L;
        Object gameObj = null;
        Object roundObj = null;
        boolean newHeader = true;
        boolean finished = false;
        String title = "Pre-match";
        Iterator gameIterator = games.iterator();
        this.os.println("<table class=\"mm1\" rules=\"groups\" frame=\"void\" border=\"1\" cellspacing=\"0\">");
        this.os.println("  <caption>Messages</caption>");
        this.os.println("  <colgroup />");
        this.os.println("  <colgroup />");
        this.os.println("  <colgroup />");
        this.os.println("  <thead>");
        this.os.println("    <tr>");
        this.os.println("      <th>Line</th>");
        this.os.println("      <th>Player</th>");
        this.os.println("      <th>Message</th>");
        this.os.println("    </tr>");
        this.os.println("  </thead>");
        this.os.println("  <tbody>");
        int lineCount = 0;
        Iterator i = messageEvents.iterator();
        while (i.hasNext()) {
            MessageEvent message = (MessageEvent)i.next();
            if (lineCount > 0 && lineCount % 10 == 0) {
                this.os.println("  </tbody><tbody>");
            }
            this.os.print("    <tr>");
            this.os.print("<td>" + ++lineCount + "</td>");
            this.os.print("<td class=\"playername\">" + HtmlOutput.htmlWolfColours(message.getPlayer().getName()) + "</td>");
            this.os.print("<td class=\"message\">" + HtmlOutput.encode(message.getMessage()) + "</td>");
            this.os.println("</tr>");
        }
        this.os.println("  </tbody>");
        this.os.println("</table>");
    }

    private void scoreboardDisplay(MatchSummary summary) {
        String time;
        String tag;
        Round round;
        Game game;
        int gameCount = 0;
        this.os.println("<table class=\"scoreboard\" rules=\"groups\" frame=\"void\" border=\"1\" cellspacing=\"0\">");
        this.os.println("  <caption>Scoreboard</caption>");
        this.os.println("  <colgroup />");
        gameCount = 0;
        Iterator i = summary.getGames().iterator();
        while (i.hasNext()) {
            game = (Game)i.next();
            ++gameCount;
            this.os.println("  <colgroup span=\"2\"/>");
        }
        this.os.println("  <thead>");
        this.os.println("    <tr>");
        this.os.println("      <th></th>");
        i = summary.getGames().iterator();
        while (i.hasNext()) {
            game = (Game)i.next();
            this.os.println("      <th colspan=\"2\">Game " + game.getGameNumber() + "</th>");
        }
        this.os.println("    </tr>");
        this.os.println("  </thead>");
        this.os.println("  <tbody>");
        this.os.print("    <tr>");
        this.os.print("<td class=\"time\">Map</td>");
        i = summary.getGames().iterator();
        while (i.hasNext()) {
            game = (Game)i.next();
            this.os.print("<th colspan=\"2\">" + HtmlOutput.encode(game.getMap()) + "</th>");
        }
        this.os.println("</tr>");
        this.os.print("    <tr>");
        this.os.print("<td class=\"time\">Round 1</td>");
        i = summary.getGames().iterator();
        while (i.hasNext()) {
            game = (Game)i.next();
            round = game.getRound1();
            tag = "";
            time = "";
            if (round != null) {
                time = round.getTime();
                tag = round.isPartial() ? "(incomplete)" : (Stats.teamOnOffence(round.getMap()).equals(round.getSideTeamA()) ? summary.getTeamATag() : summary.getTeamBTag());
                if (!round.isSuccess()) {
                    tag = String.valueOf(tag) + " (fullhold)";
                }
            }
            this.os.print("<td>" + HtmlOutput.encode(tag) + "</td>");
            this.os.print("<td class=\"time\">" + time + "</td>");
        }
        this.os.println("</tr>");
        this.os.print("    <tr>");
        this.os.print("<td class=\"time\">Round 2</td>");
        i = summary.getGames().iterator();
        while (i.hasNext()) {
            game = (Game)i.next();
            round = game.getRound2();
            tag = "";
            time = "";
            if (round != null) {
                time = round.getTime();
                tag = round.isPartial() ? "(incomplete)" : (Stats.teamOnOffence(round.getMap()).equals(round.getSideTeamA()) ? summary.getTeamATag() : summary.getTeamBTag());
                if (!round.isSuccess()) {
                    tag = String.valueOf(tag) + " (held)";
                }
            }
            this.os.print("<td>" + HtmlOutput.encode(tag) + "</td>");
            this.os.print("<td class=\"time\">" + time + "</td>");
        }
        this.os.println("</tr>");
        this.os.print("    <tr>");
        this.os.print("<td class=\"time\">Result</td>");
        i = summary.getGames().iterator();
        while (i.hasNext()) {
            game = (Game)i.next();
            String tag2 = "";
            String result = "";
            tag2 = Stats.teamOnOffence(game.getMap()).equals(game.getRound1SideTeamA()) ? summary.getTeamATag() : summary.getTeamBTag();
            result = game.isPartial() ? "(incomplete)" : (game.isDraw() ? "full hold" : (game.isTeamAWin() ? String.valueOf(summary.getTeamATag()) + " win" : String.valueOf(summary.getTeamBTag()) + " win"));
            this.os.print("<td colspan=\"2\">" + HtmlOutput.encode(result) + "</td>");
        }
        this.os.println("</tr>");
        this.os.println("  </tbody>");
        this.os.println("</table>");
    }

    private void weaponDisplay(MatchSummary summary) {
        Weapon weapon;
        Iterator j;
        PlayerRoundStats prs;
        Player player;
        Weapon weapon2;
        String id = "Weapon";
        this.os.println("<table id=\"" + id + "\" class=\"results\" rules=\"groups\" frame=\"void\" border=\"1\" cellspacing=\"0\">");
        this.os.println("  <caption>Player kills by weapon</caption>");
        this.os.println("  <colgroup span=\"2\"/>");
        this.os.println("  <colgroup span=\"1\"/>");
        this.os.println("  <colgroup span=\"4\"/>");
        this.os.println("  <colgroup span=\"4\"/>");
        this.os.println("  <colgroup span=\"2\"/>");
        this.os.println("  <colgroup span=\"2\"/>");
        this.os.println("  <colgroup span=\"2\"/>");
        this.os.println("  <colgroup span=\"3\"/>");
        this.os.println("  <colgroup span=\"3\"/>");
        this.os.println("  <colgroup span=\"2\"/>");
        this.os.println("  <thead>");
        this.os.println("    <tr>");
        this.os.println("      <th class=\"button\"><span id=\"" + id + "minus\" class=\"hidebutton\" title=\"click to hide player details\" onmousedown=\"setTogglePlayers('" + id + "',false)\">-</span>" + "<span  id=\"" + id + "plus\" class=\"showbutton\" title=\"click to show player details\" onmousedown=\"setTogglePlayers('" + id + "',true)\">+</span>" + "</th>");
        this.os.println("      <th class=\"playername\" title=\"click to sort\">Name</th>");
        Iterator i = summary.getWeapons().iterator();
        while (i.hasNext()) {
            weapon2 = (Weapon)i.next();
            if (!weapon2.isWeapon()) continue;
            this.os.println("      <th title=\"" + HtmlOutput.encode(weapon2.getName()) + "\">" + HtmlOutput.encode(weapon2.getShortName()) + "</th>");
        }
        this.os.println("    </tr>");
        this.os.println("  </thead>");
        this.os.println("  <tbody id=\"" + HtmlOutput.encode(String.valueOf(id) + "Allies") + "\" class=\"" + "Allies" + "Data\" >");
        i = summary.getTeamAPlayers().iterator();
        while (i.hasNext()) {
            player = (Player)i.next();
            prs = player.getStatsTotal();
            this.os.print("    <tr>");
            this.os.print("<td></td><td class=\"playername\">" + HtmlOutput.htmlWolfColours(prs.getPlayer().getName()) + "</td>");
            j = summary.getWeapons().iterator();
            while (j.hasNext()) {
                weapon = (Weapon)j.next();
                if (!weapon.isWeapon()) continue;
                this.os.print("<td>" + prs.getWeaponDetail().getIndex(summary.getWeapons().indexOf(weapon)) + "</td>");
            }
            this.os.println("</tr>");
        }
        this.os.println("  </tbody>");
        this.os.println("  <tbody class=\"AlliesTotal\">");
        this.os.print("    <tr>");
        this.os.print("<td></td><td class=\"playername\">" + HtmlOutput.encode(summary.getTeamATag()) + "</td>");
        Iterator j2 = summary.getWeapons().iterator();
        while (j2.hasNext()) {
            weapon2 = (Weapon)j2.next();
            if (!weapon2.isWeapon()) continue;
            this.os.print("<td>" + summary.getTeamATotal().getWeaponDetail().getIndex(summary.getWeapons().indexOf(weapon2)) + "</td>");
        }
        this.os.println("</tr>");
        this.os.println("  </tbody>");
        this.os.println("  <tbody id=\"" + HtmlOutput.encode(String.valueOf(id) + "Axis") + "\" class=\"" + "Allies" + "Data\" >");
        i = summary.getTeamBPlayers().iterator();
        while (i.hasNext()) {
            player = (Player)i.next();
            prs = player.getStatsTotal();
            this.os.print("    <tr>");
            this.os.print("<td></td><td class=\"playername\">" + HtmlOutput.htmlWolfColours(prs.getPlayer().getName()) + "</td>");
            j = summary.getWeapons().iterator();
            while (j.hasNext()) {
                weapon = (Weapon)j.next();
                if (!weapon.isWeapon()) continue;
                this.os.print("<td>" + prs.getWeaponDetail().getIndex(summary.getWeapons().indexOf(weapon)) + "</td>");
            }
            this.os.println("</tr>");
        }
        this.os.println("  </tbody>");
        this.os.println("  <tbody class=\"AlliesTotal\">");
        this.os.print("    <tr>");
        this.os.print("<td></td><td class=\"playername\">" + HtmlOutput.encode(summary.getTeamBTag()) + "</td>");
        j2 = summary.getWeapons().iterator();
        while (j2.hasNext()) {
            weapon2 = (Weapon)j2.next();
            if (!weapon2.isWeapon()) continue;
            this.os.print("<td>" + summary.getTeamBTotal().getWeaponDetail().getIndex(summary.getWeapons().indexOf(weapon2)) + "</td>");
        }
        this.os.println("</tr>");
        this.os.println("  </tbody>");
        this.os.println("</table>");
        this.os.println("  <script type=\"text/javascript\">");
        this.os.println("    //<![CDATA[");
        this.os.print("    var stWeapon = new SortableTable(document.getElementById(\"" + id + "\"),[\"None\",\"CaseInsensitiveString\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\", \"Number\"");
        this.os.println("]);");
        this.os.println("    //]]>");
        this.os.println("  </script>");
    }

    private void awardsDisplay(MatchSummary summary) {
        this.os.println("<table class=\"awards\" rules=\"groups\" frame=\"void\" border=\"1\" cellspacing=\"0\">");
        this.os.println("  <caption>Awards</caption>");
        this.os.println("  <colgroup />");
        this.os.println("  <colgroup />");
        this.os.println("  <colgroup />");
        this.os.println("  <colgroup />");
        this.os.println("  <thead>");
        this.os.println("    <tr>");
        this.os.println("      <th>Award</th>");
        this.os.println("      <th>Awarded to</th>");
        this.os.println("      <th>For</th>");
        this.os.println("      <th>Average</th>");
        this.os.println("    </tr>");
        this.os.println("  </thead>");
        this.os.println("  <tbody>");
        Iterator i = summary.getAwards().iterator();
        while (i.hasNext()) {
            Map map = (Map)i.next();
            this.os.print("    <tr>");
            this.os.print("<td>" + HtmlOutput.encode((String)map.get("name")) + "</td>");
            this.os.print("<td class=\"playername\">");
            List list = (List)map.get("players");
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Player player = (Player)j.next();
                this.os.print(String.valueOf(HtmlOutput.htmlWolfColours(player.getName())) + " ");
            }
            this.os.print("</td>");
            this.os.print("<td>" + HtmlOutput.encode((String)map.get("description")) + "</td>");
            this.os.print("<td class=\"average\">" + HtmlOutput.encode((String)map.get("average")) + "</td>");
            this.os.println("</tr>");
        }
        this.os.println("  </tbody>");
        this.os.println("</table>");
    }

    private String eventDisplay(List events, Player player) {
        StringBuffer buf = new StringBuffer();
        Iterator i = events.iterator();
        while (i.hasNext()) {
            PlayerEvent event = (PlayerEvent)i.next();
            String title = "";
            String className = "";
            String icon = "";
            if (event.getPrimary() == player) {
                if (event.iskill()) {
                    title = "Killed " + HtmlOutput.encode(event.getSecondary().getCleanName()) + " using " + HtmlOutput.encode(event.getWeapon().getName());
                    className = "k";
                    icon = "K";
                }
                if (event.isSlashKill()) {
                    title = "/kill";
                    className = "sk";
                    icon = "/";
                }
                if (event.isSuicide()) {
                    title = "Killed himself by " + HtmlOutput.encode(event.getWeapon().getName());
                    className = "s";
                    icon = "S";
                }
                if (event.isTeamKill()) {
                    title = "Killed teammate " + HtmlOutput.encode(event.getSecondary().getCleanName()) + " using " + HtmlOutput.encode(event.getWeapon().getName());
                    className = "tk";
                    icon = "T";
                }
            }
            if (event.getSecondary() == player) {
                if (event.iskill()) {
                    title = "Killed by " + HtmlOutput.encode(event.getPrimary().getCleanName()) + " using " + HtmlOutput.encode(event.getWeapon().getName());
                    className = "kd";
                    icon = "D";
                }
                if (event.isTeamKill()) {
                    title = "Killed by teammate " + HtmlOutput.encode(event.getPrimary().getCleanName()) + " using " + HtmlOutput.encode(event.getWeapon().getName());
                    className = "tkd";
                    icon = "t";
                }
            }
            if ("".equals(icon)) continue;
            buf.append("<span title=\"" + title + "\" class=\"" + className + "\">" + icon + "</span>");
        }
        return buf.toString();
    }

    public static String htmlNewline() {
        return "<br />";
    }

    public static String htmlWolfColours(String name) {
        String result = "";
        String[] split = name.split("\\^", -1);
        String colour = "";
        int i = 0;
        while (i < split.length) {
            if (i != 0 && "".equals(split[i])) {
                result = String.valueOf(result) + "^";
            } else if (i == 0 || split[i].charAt(0) == '^') {
                result = String.valueOf(result) + HtmlOutput.encode(split[i]);
            } else {
                char c = split[i].charAt(0);
                colour = "";
                switch (c) {
                    case '&': {
                        colour = "cf";
                        break;
                    }
                    case '*': {
                        colour = "cf";
                        break;
                    }
                    case '/': {
                        colour = "cn";
                        break;
                    }
                    case '-': {
                        colour = "cm";
                        break;
                    }
                    case '+': {
                        colour = "cplus";
                        break;
                    }
                    case '?': {
                        colour = "cquestion";
                        break;
                    }
                    case '@': {
                        colour = "cat";
                        break;
                    }
                    case '\'': {
                        colour = "c8";
                        break;
                    }
                    case '(': {
                        colour = "ch";
                        break;
                    }
                    case ')': {
                        colour = "ci";
                        break;
                    }
                    case '.': {
                        colour = "cn";
                        break;
                    }
                    case ']': {
                        colour = "c8";
                        break;
                    }
                    case '!': {
                        colour = "ca";
                        break;
                    }
                    case '#': {
                        colour = "cc";
                        break;
                    }
                    case '$': {
                        colour = "cd";
                        break;
                    }
                    case '%': {
                        colour = "ce";
                        break;
                    }
                    case '\"': {
                        colour = "cb";
                        break;
                    }
                    case ':': 
                    case ';': 
                    case '[': {
                        colour = "clsquare";
                        break;
                    }
                    case '|': {
                        colour = "ch";
                        break;
                    }
                    case ',': {
                        colour = "c8";
                        break;
                    }
                    case '\\': {
                        colour = "ch";
                        break;
                    }
                    case '=': {
                        colour = "c8";
                        break;
                    }
                    case '<': {
                        colour = "clt";
                        break;
                    }
                    case '>': {
                        colour = "cgt";
                        break;
                    }
                    default: {
                        colour = "c" + c;
                        colour = colour.toLowerCase();
                    }
                }
                result = String.valueOf(result) + "</span><span class=\"" + colour + "\">";
                if (split[i].length() > 0) {
                    result = String.valueOf(result) + HtmlOutput.encode(split[i].substring(1));
                }
            }
            ++i;
        }
        return "<span class=\"c7\">" + result + "</span>";
    }

    private String getOutputFilename(MatchSummary summary) {
        String teamB;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String filename = String.valueOf(sdf.format(summary.getGameDate())) + "-";
        String teamA = summary.getTeamATag().replaceAll("['\\?\\*:/\\\\<>\"\\|]", "");
        if ("".equals(teamA)) {
            teamA = "TeamA";
        }
        if ("".equals(teamB = summary.getTeamBTag().replaceAll("['\\?\\*:/\\\\<>\"\\|]", ""))) {
            teamB = "TeamB";
        }
        filename = String.valueOf(filename) + teamA + "_vs_" + teamB;
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = summary.getGames().iterator();
        while (i.hasNext()) {
            Game game = (Game)i.next();
            if (list.contains(game.getMap())) continue;
            list.add(game.getMap());
        }
        i = list.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            filename = String.valueOf(filename) + "-" + key.replaceAll("[\\?\\*:/\\\\<>\"\\|]", "_");
        }
        return String.valueOf(filename) + ".html";
    }
}

