/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class PlayerList
extends ArrayList {
    String side;
    String teamname;
    int globalteam;
    PlayerStats total_stats = new PlayerStats();

    public void calculate_total() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            PlayerStats.syndicate(this.total_stats, p.stats);
        }
        this.total_stats.calculate_efficiencies();
    }

    public PlayerList() {
    }

    public PlayerList(int i) {
        super(i);
    }

    public Player getByName(String name, int nameType) {
        return this.getByName(name, nameType, true);
    }

    public Player getByName(String name, int nameType, boolean updateNames) {
        return this.getPlayer(name, nameType, false, updateNames);
    }

    public Player nameSearchCreate(String name, int nameType) {
        return this.nameSearchCreate(name, nameType, true);
    }

    public Player nameSearchCreate(String name, int nameType, boolean updateNames) {
        return this.getPlayer(name, nameType, true, updateNames);
    }

    public Player getPlayer(String name, int nameType, boolean createIfNotFound) {
        return this.getPlayer(name, nameType, createIfNotFound, true);
    }

    public Player getPlayer(String name, int nameType, boolean createIfNotFound, boolean fillInTheGaps) {
        Player p;
        name = name.trim();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            p = (Player)i.next();
            if (!p.directNameMatch(name, nameType)) continue;
            return p;
        }
        i = this.iterator();
        while (i.hasNext()) {
            p = (Player)i.next();
            if (!p.indirectNameMatch(name, nameType, fillInTheGaps)) continue;
            return p;
        }
        if (createIfNotFound) {
            p = new Player(name, nameType);
            this.add(p);
            return p;
        }
        return null;
    }

    public void lookForTag() {
        Object[] o = this.toArray();
        int numplayers = o.length;
        HashMap<String, Integer> matchedfronts = new HashMap<String, Integer>(20);
        HashMap<String, Integer> matchedbacks = new HashMap<String, Integer>(20);
        String new_teamname = "";
        gravyStats.debug("looking for tag");
        for (int i = 0; i < numplayers; ++i) {
            Player p1 = (Player)o[i];
            String p1name = Player.cleanName(p1.getName());
            for (int j = i + 1; j < numplayers; ++j) {
                String match2;
                Player p2 = (Player)o[j];
                String p2name = Player.cleanName(p2.getName());
                String match1 = gravyStats.matchNames(p1name, p2name);
                if (match1 != null) {
                    if (matchedfronts.containsKey(match1)) {
                        matchedfronts.put(match1, new Integer((Integer)matchedfronts.get(match1) + 1));
                    } else {
                        matchedfronts.put(match1, new Integer(1));
                    }
                }
                if ((match2 = gravyStats.matchNames(p1name = new StringBuffer(p1name).reverse().toString(), p2name = new StringBuffer(p2name).reverse().toString())) != null) {
                    if (matchedbacks.containsKey(match2)) {
                        matchedbacks.put(match2, new Integer((Integer)matchedbacks.get(match2) + 1));
                    } else {
                        matchedbacks.put(match2, new Integer(1));
                    }
                }
                p1name = new StringBuffer(p1name).reverse().toString();
            }
        }
        int half = numplayers / 2;
        int max = 1;
        for (int z = 2; z < half; ++z) {
            max += z;
        }
        int resetmax = max;
        String start = "";
        int samecount = 0;
        Iterator i = matchedfronts.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry match = i.next();
            String key = (String)match.getKey();
            int value = (Integer)match.getValue();
            gravyStats.debug(key + " matched " + value + " times");
            if (value > max) {
                max = value;
                start = key;
                samecount = 0;
                continue;
            }
            if (value != max) continue;
            if (key.length() > start.length()) {
                start = key;
            }
            ++samecount;
        }
        if (start.length() > 0 && samecount < 3) {
            new_teamname = new_teamname + start;
            gravyStats.debug("tag start found: " + start);
        }
        max = resetmax;
        String end = "";
        samecount = 0;
        Iterator i2 = matchedbacks.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry match = i2.next();
            String key = (String)match.getKey();
            int value = (Integer)match.getValue();
            gravyStats.debug(key + " matched " + value + " times");
            if (value > max) {
                max = value;
                end = key;
                samecount = 0;
                continue;
            }
            if (value != max) continue;
            if (key.length() > end.length()) {
                end = key;
            }
            ++samecount;
        }
        if (end.length() > 0 && samecount < 3) {
            end = new StringBuffer(end).reverse().toString();
            new_teamname = new_teamname + end;
            gravyStats.debug("tag end found: " + end);
        }
        if (!new_teamname.equals("")) {
            this.teamname = new_teamname;
        }
    }
}

