/*
 * Decompiled with CFR 0.152.
 */
package de.neelix.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipUtil {
    private static int m_mainFolderLength = 0;
    private static final int BUFFER = 2048;
    private static byte[] m_buffer = new byte[2048];

    public static void addAllFromDirectory(File theFolder, ZipOutputStream outputZipStream) {
        File[] afile = theFolder.listFiles();
        if (afile != null && afile.length > 0) {
            try {
                String folderPath = theFolder.getName();
                String s = String.valueOf(folderPath.substring(m_mainFolderLength).replace(File.separatorChar, '/')) + "/";
                ZipEntry zipentry = new ZipEntry(s);
                zipentry.setTime(theFolder.lastModified());
                outputZipStream.putNextEntry(zipentry);
                int i = 0;
                while (i < afile.length) {
                    if (afile[i].isDirectory()) {
                        ZipUtil.addAllFromDirectory(afile[i], outputZipStream);
                    } else {
                        ZipUtil.addOneFile(afile[i], outputZipStream);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void addOneFile(File file, ZipOutputStream outputZipStream) {
        try {
            if (file != null && file.exists() && !file.isDirectory()) {
                String filePath = file.getPath();
                String fileName = filePath.substring(filePath.lastIndexOf("scripts"), filePath.length());
                System.out.println(fileName);
                String zipEntryName = fileName.replace(File.separatorChar, '/');
                ZipEntry zipentry = new ZipEntry(zipEntryName);
                FileInputStream fileInputStream = new FileInputStream(file);
                ZipUtil.addNextEntry(outputZipStream, file.lastModified(), zipentry, fileInputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addNextEntry(ZipOutputStream outputZipStream, long accessTime, ZipEntry newZipEntry, InputStream inStream) {
        newZipEntry.setTime(accessTime);
        try {
            outputZipStream.putNextEntry(newZipEntry);
            int j = inStream.read(m_buffer, 0, m_buffer.length);
            while (j > 0) {
                outputZipStream.write(m_buffer, 0, j);
                j = inStream.read(m_buffer, 0, m_buffer.length);
            }
            inStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

