/*
 * Decompiled with CFR 0.152.
 */
package de.neelix.generator.io;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class AbstractFileProducer {
    protected String aFileName;
    protected String aFilePath;
    protected String[] aMapNames;
    protected String aDescription;

    public abstract void doCreateContent();

    protected void fileWalk(File aRootDirectory, ZipOutputStream zos) {
        zos.setLevel(-1);
        try {
            if (aRootDirectory.isDirectory()) {
                File[] files = aRootDirectory.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.fileWalk(files[i], zos);
                    ++i;
                }
            } else {
                ZipEntry entry = new ZipEntry(aRootDirectory.getName());
                zos.putNextEntry(entry);
                BufferedInputStream br = new BufferedInputStream(new FileInputStream(aRootDirectory));
                byte[] buffer = new byte[4096];
                while (br.read(buffer) > 0) {
                    zos.write(buffer);
                    zos.flush();
                }
                br.close();
                zos.closeEntry();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected final String doCreateDescriptionText() {
        if (this.aDescription == null || this.aDescription != null && this.aDescription.length() == 0) {
            int counter = 1;
            StringBuffer buffer = new StringBuffer();
            buffer.append("\\n\\nMap Overview\\n**");
            int i = 0;
            while (i < this.aMapNames.length) {
                String aMap = this.aMapNames[i];
                buffer.append(" ").append(counter).append(". ").append(aMap).append("*");
                ++counter;
                ++i;
            }
            buffer.append("\\nCampaign created with*NEELIX Campaign Creator\\n");
            return buffer.toString();
        }
        return this.aDescription;
    }

    protected final void writeCFGFile(String fileContent) {
        try {
            File destinationFile = new File(String.valueOf(this.aFilePath) + File.separator + this.aFileName + ".cfg");
            FileWriter fileWriter = new FileWriter(destinationFile);
            BufferedWriter buffWriter = new BufferedWriter(fileWriter);
            buffWriter.write(fileContent.toString());
            buffWriter.flush();
            buffWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

