/*
 * Decompiled with CFR 0.152.
 */
package de.neelix.generator.gui;

import de.neelix.generator.gui.MainWorkPane;
import de.neelix.generator.swing.ListenerList;
import de.neelix.resources.ResourceBundleUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class MenuItemSettings
extends JMenu
implements PropertyChangeListener {
    private JComboBox skins;
    private JComboBox languages;
    private final Component owner;
    private JMenuItem language;
    private JMenuItem lookAndFeel;
    private Locale currentUsedLocale;
    private static final String SKIN_MOTIF = "Motif";
    private static final String SKIN_MOTIF_CLASS_NAME = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String SKIN_METAL = "Metal";
    private static final String SKIN_METAL_CLASS_NAME = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String SKIN_WINDOWS = "Windows";
    private static final String SKIN_WINDOWS_CLASS_NAME = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String LANGUAGE_GERMAN = Locale.GERMAN.getDisplayLanguage(Locale.GERMAN);
    private static final String LANGUAGE_ENGLISH = Locale.ENGLISH.getDisplayLanguage(Locale.ENGLISH);

    public MenuItemSettings(Component aOwner) {
        this.owner = aOwner;
        ListenerList.addPropertyChangeListener(this);
        this.currentUsedLocale = ((MainWorkPane)this.owner).getLocale();
        this.setText(ResourceBundleUtil.getStringForLocale("menu.settings.label.text", this.currentUsedLocale));
        this.doCreateContent();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.currentUsedLocale = (Locale)evt.getNewValue();
        this.setText(ResourceBundleUtil.getStringForLocale("menu.settings.label.text", this.currentUsedLocale));
        this.language.setText(ResourceBundleUtil.getStringForLocale("menu.language.label.text", (Locale)evt.getNewValue()));
        this.lookAndFeel.setText(ResourceBundleUtil.getStringForLocale("menu.lookAndFeel.label.text", (Locale)evt.getNewValue()));
    }

    private void doCreateContent() {
        this.language = new JMenuItem(ResourceBundleUtil.getStringForLocale("menu.language.label.text", this.currentUsedLocale));
        this.language.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int result = JOptionPane.showConfirmDialog(MenuItemSettings.this.owner, MenuItemSettings.this.doCreateLanguagePanel(), ResourceBundleUtil.getStringForLocale("menu.language.label.text", MenuItemSettings.this.currentUsedLocale), 0);
                if (result == 0) {
                    Locale currentLocale = Locale.ENGLISH;
                    String selectedLanguage = (String)MenuItemSettings.this.languages.getSelectedItem();
                    if (selectedLanguage.equals(LANGUAGE_GERMAN)) {
                        currentLocale = Locale.GERMAN;
                    }
                    ListenerList.firePropertyChanged(currentLocale);
                    SwingUtilities.updateComponentTreeUI(MenuItemSettings.this.owner);
                }
            }
        });
        this.add(this.language);
        this.lookAndFeel = new JMenuItem(ResourceBundleUtil.getStringForLocale("menu.lookAndFeel.label.text", this.currentUsedLocale));
        this.lookAndFeel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int result = JOptionPane.showConfirmDialog(MenuItemSettings.this.owner, MenuItemSettings.this.doCreateLookAndFeelPanel(), ResourceBundleUtil.getStringForLocale("menu.lookAndFeel.label.text", MenuItemSettings.this.currentUsedLocale), 0);
                if (result == 0) {
                    String selectedSkin = (String)MenuItemSettings.this.skins.getSelectedItem();
                    try {
                        if (selectedSkin.equals(MenuItemSettings.SKIN_MOTIF)) {
                            UIManager.setLookAndFeel(MenuItemSettings.SKIN_MOTIF_CLASS_NAME);
                        } else if (selectedSkin.equals(MenuItemSettings.SKIN_METAL)) {
                            UIManager.setLookAndFeel(MenuItemSettings.SKIN_METAL_CLASS_NAME);
                        } else if (selectedSkin.equals(MenuItemSettings.SKIN_WINDOWS)) {
                            UIManager.setLookAndFeel(MenuItemSettings.SKIN_WINDOWS_CLASS_NAME);
                        }
                        SwingUtilities.updateComponentTreeUI(MenuItemSettings.this.owner);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.add(this.lookAndFeel);
    }

    private JPanel doCreateLookAndFeelPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        Box headerLabel = new Box(0);
        headerLabel.add(new JLabel(ResourceBundleUtil.getStringForLocale("dialog.supportedSkins.label.text", this.currentUsedLocale)));
        headerLabel.add(Box.createHorizontalGlue());
        result.add(headerLabel);
        Vector<String> values = new Vector<String>();
        values.add(SKIN_MOTIF);
        values.add(SKIN_METAL);
        if (System.getProperties().getProperty("os.name").indexOf(SKIN_WINDOWS) != -1) {
            values.add(SKIN_WINDOWS);
        }
        this.skins = new JComboBox(values);
        this.skins.setBorder(new EmptyBorder(5, 0, 5, 0));
        if (UIManager.getLookAndFeel().getClass().getName().equals(SKIN_MOTIF_CLASS_NAME)) {
            this.skins.setSelectedItem(SKIN_MOTIF);
        } else if (UIManager.getLookAndFeel().getClass().getName().equals(SKIN_METAL_CLASS_NAME)) {
            this.skins.setSelectedItem(SKIN_METAL);
        } else if (UIManager.getLookAndFeel().getClass().getName().equals(SKIN_WINDOWS_CLASS_NAME)) {
            this.skins.setSelectedItem(SKIN_WINDOWS);
        }
        result.add(this.skins);
        return result;
    }

    private JPanel doCreateLanguagePanel() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        Box headerLabel = new Box(0);
        headerLabel.add(new JLabel(ResourceBundleUtil.getStringForLocale("dialog.supportedLanguage.label.text", this.currentUsedLocale)));
        headerLabel.add(Box.createHorizontalGlue());
        result.add(headerLabel);
        Vector<String> values = new Vector<String>();
        values.add(LANGUAGE_GERMAN);
        values.add(LANGUAGE_ENGLISH);
        this.languages = new JComboBox(values);
        this.languages.setBorder(new EmptyBorder(5, 0, 5, 0));
        Locale currentLocale = ((MainWorkPane)this.owner).getLocale();
        this.languages.setSelectedItem(currentLocale.getDisplayLanguage(currentLocale));
        result.add(this.languages);
        return result;
    }
}

