/*
 * Decompiled with CFR 0.152.
 */
package de.neelix.generator.gui;

import de.neelix.generator.gui.MenuItemAbout;
import de.neelix.generator.gui.MenuItemSettings;
import de.neelix.generator.gui.file.PK3FileFilter;
import de.neelix.generator.io.CampaignFileProducer;
import de.neelix.generator.io.ObjectiveFileProducer;
import de.neelix.generator.io.StopWatchABBAFileProducer;
import de.neelix.generator.io.StopWatchABFileProducer;
import de.neelix.generator.swing.ListenerList;
import de.neelix.resources.ResourceBundleUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class MainWorkPane
extends JFrame
implements PropertyChangeListener {
    private final JComboBox campaignType;
    private final Vector items = new Vector();
    private final JFileChooser src = new JFileChooser();
    private final JTextField path = new JTextField(20);
    private final JTextField campaignName = new JTextField();
    private final JTextArea description = new JTextArea(5, 20);
    private final DefaultListModel listData = new DefaultListModel();
    private final JList fileList = new JList(this.listData);
    private static final String GAME_TYPE_CAMPAIGN = "Campaign";
    private static final String GAME_TYPE_OBJECTIVE = "Objective";
    private static final String GAME_TYPE_STOPWATCH_AB = "Stopwatch Typ AB";
    private static final String GAME_TYPE_STOPWATCH_ABBA = "Stopwatch Typ ABBA";
    private static final String[] standardMaps = new String[]{"battery", "oasis", "goldrush", "radar", "fueldump", "railgun"};
    final JLabel includeStandardMaps = new JLabel();
    final JButton srcChooser = new JButton();
    final JButton del = new JButton();
    final JButton close = new JButton();
    final JButton create = new JButton();
    final JButton up = new JButton();
    final JButton down = new JButton();
    final JButton destPath = new JButton();
    final JLabel descr = new JLabel();
    final JLabel descr1 = new JLabel();
    final JLabel type = new JLabel();
    final JLabel fileName = new JLabel();
    final JLabel filePath = new JLabel();
    final JLabel overview = new JLabel();
    private Locale currentLocale = Locale.ENGLISH;

    public MainWorkPane() {
        this.setResizable(false);
        this.setJMenuBar(this.doCreateMenuBar());
        ListenerList.addPropertyChangeListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.items.add(GAME_TYPE_CAMPAIGN);
        this.items.add(GAME_TYPE_OBJECTIVE);
        this.items.add(GAME_TYPE_STOPWATCH_AB);
        this.items.add(GAME_TYPE_STOPWATCH_ABBA);
        this.campaignType = new JComboBox(this.items);
        this.src.setMultiSelectionEnabled(true);
        this.src.setFileFilter(new PK3FileFilter());
        this.src.setFileSelectionMode(2);
        this.doCreateHeader();
        this.doCreateSource();
        this.doCreateUtilities();
        this.doCreateButtonPart();
        this.internationalizeAll();
        this.pack();
    }

    public void doShow() {
        this.setVisible(true);
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public void setLocale(Locale aLocale) {
        this.currentLocale = aLocale;
    }

    private void internationalizeAll() {
        this.setTitle(ResourceBundleUtil.getStringForLocale("workPane.label.text", this.getLocale()));
        this.srcChooser.setText(ResourceBundleUtil.getStringForLocale("workPane.add.label.text", this.getLocale()));
        this.del.setText(ResourceBundleUtil.getStringForLocale("workPane.delete.label.text", this.getLocale()));
        this.up.setText(ResourceBundleUtil.getStringForLocale("workPane.up.label.text", this.getLocale()));
        this.down.setText(ResourceBundleUtil.getStringForLocale("workPane.down.label.text", this.getLocale()));
        this.descr.setText(ResourceBundleUtil.getStringForLocale("workPane.description.label.text", this.getLocale()));
        this.close.setText(ResourceBundleUtil.getStringForLocale("workPane.close.label.text", this.getLocale()));
        this.create.setText(ResourceBundleUtil.getStringForLocale("workPane.create.label.text", this.getLocale()));
        this.descr1.setText(ResourceBundleUtil.getStringForLocale("workPane.includeStandardMaps.label.text", this.getLocale()));
        this.type.setText(ResourceBundleUtil.getStringForLocale("workPane.type.label.text", this.getLocale()));
        this.fileName.setText(ResourceBundleUtil.getStringForLocale("workPane.fileName.label.text", this.getLocale()));
        this.filePath.setText(ResourceBundleUtil.getStringForLocale("workPane.saveAs.label.text", this.getLocale()));
        this.destPath.setText(ResourceBundleUtil.getStringForLocale("workPane.browse.label.text", this.getLocale()));
        this.overview.setText(ResourceBundleUtil.getStringForLocale("workPane.onlyMapOverview.label.text", this.getLocale()));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setLocale((Locale)evt.getNewValue());
        this.internationalizeAll();
    }

    private void doCreateHeader() {
        try {
            URL imageURL = this.getClass().getResource("/de/neelix/resources/icons/neelix.png");
            ImageIcon icon = new ImageIcon(imageURL);
            JLabel pic = new JLabel(icon);
            pic.setBorder(new EmptyBorder(10, 10, 0, 10));
            Box container = new Box(1);
            Box temp = new Box(0);
            temp.add(Box.createHorizontalGlue());
            temp.add(pic);
            temp.add(Box.createHorizontalGlue());
            container.add(temp);
            container.add(Box.createVerticalStrut(5));
            temp = new Box(0);
            temp.add(Box.createHorizontalGlue());
            JLabel neelix = new JLabel("The better way to your campaign");
            neelix.setBorder(new EmptyBorder(0, 0, 0, 10));
            temp.add(neelix);
            container.add(temp);
            this.getContentPane().add((Component)container, "North");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            String windowTitle = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", this.getLocale());
            String message = ResourceBundleUtil.getStringForLocale("dialog.message.closeWindow.label.text", this.getLocale());
            int returnVal = JOptionPane.showConfirmDialog(this, message, windowTitle, 0);
            if (returnVal == 0) {
                System.exit(0);
            }
        }
    }

    private void doCreateSource() {
        Box headerPart = new Box(0);
        headerPart.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.fileList.setBorder(new CompoundBorder(new LineBorder(Color.BLACK, 1), new EmptyBorder(5, 5, 5, 5)));
        this.fileList.setSelectionMode(1);
        JScrollPane listScroller = new JScrollPane(this.fileList, 20, 31);
        listScroller.setPreferredSize(new Dimension(200, 85));
        final JCheckBox check = new JCheckBox();
        check.setBorder(new EmptyBorder(5, 0, 5, 5));
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (check.isSelected()) {
                    int i = 0;
                    while (i < standardMaps.length) {
                        if (!MainWorkPane.this.listData.contains(standardMaps[i])) {
                            MainWorkPane.this.listData.addElement(standardMaps[i]);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < standardMaps.length) {
                        MainWorkPane.this.listData.removeElement(standardMaps[i]);
                        ++i;
                    }
                }
            }
        });
        Box listCheck = new Box(1);
        listCheck.add(listScroller);
        Box checkOnly = new Box(0);
        checkOnly.add(check);
        checkOnly.add(this.descr1);
        checkOnly.add(Box.createHorizontalGlue());
        listCheck.add(checkOnly);
        headerPart.add(listCheck);
        headerPart.add(Box.createHorizontalStrut(10));
        this.srcChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = MainWorkPane.this.src.showDialog(MainWorkPane.this, ResourceBundleUtil.getStringForLocale("workPane.add.label.text", MainWorkPane.this.currentLocale));
                if (returnVal == 0) {
                    File[] selFiles = MainWorkPane.this.src.getSelectedFiles();
                    int i = 0;
                    while (i < selFiles.length) {
                        String aName = selFiles[i].getName();
                        aName = aName.substring(0, aName.indexOf(".pk3"));
                        MainWorkPane.this.listData.addElement(aName);
                        ++i;
                    }
                }
            }
        });
        JPanel buttonPart = new JPanel(new GridLayout(7, 1));
        buttonPart.add(this.srcChooser);
        this.del.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selIndex = MainWorkPane.this.fileList.getSelectedIndex();
                if (selIndex != -1) {
                    MainWorkPane.this.listData.remove(selIndex);
                }
            }
        });
        buttonPart.add(this.del);
        this.up.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selIndex = MainWorkPane.this.fileList.getSelectedIndex();
                if (selIndex != -1) {
                    Object temp = MainWorkPane.this.listData.elementAt(selIndex);
                    MainWorkPane.this.listData.remove(selIndex);
                    int newIndex = 0;
                    if (selIndex >= 1) {
                        newIndex = selIndex - 1;
                    }
                    MainWorkPane.this.listData.add(newIndex, temp);
                    MainWorkPane.this.fileList.setSelectedIndex(newIndex);
                }
            }
        });
        buttonPart.add(this.up);
        this.down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selIndex = MainWorkPane.this.fileList.getSelectedIndex();
                if (selIndex != -1) {
                    Object temp = MainWorkPane.this.listData.elementAt(selIndex);
                    MainWorkPane.this.listData.remove(selIndex);
                    int newIndex = MainWorkPane.this.listData.size();
                    if (selIndex < MainWorkPane.this.listData.size()) {
                        newIndex = selIndex + 1;
                    }
                    MainWorkPane.this.listData.add(newIndex, temp);
                    MainWorkPane.this.fileList.setSelectedIndex(newIndex);
                }
            }
        });
        buttonPart.add(this.down);
        headerPart.add(buttonPart);
        this.getContentPane().add((Component)headerPart, "West");
    }

    private void doCreateUtilities() {
        Box container = new Box(1);
        container.setBorder(new EmptyBorder(5, 0, 10, 10));
        Box temp = new Box(0);
        temp.add(this.descr);
        temp.add(Box.createHorizontalGlue());
        container.add(temp);
        container.add(Box.createVerticalStrut(5));
        container.add(new JScrollPane(this.description));
        final JCheckBox enableDescription = new JCheckBox();
        enableDescription.setBorder(new EmptyBorder(5, 0, 5, 5));
        enableDescription.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (enableDescription.isSelected()) {
                    MainWorkPane.this.description.setEnabled(false);
                    MainWorkPane.this.description.setEditable(false);
                } else if (!MainWorkPane.this.description.isEnabled()) {
                    MainWorkPane.this.description.setEnabled(true);
                    MainWorkPane.this.description.setEditable(true);
                }
            }
        });
        temp = new Box(0);
        temp.add(enableDescription);
        temp.add(this.overview);
        temp.add(Box.createHorizontalGlue());
        container.add(temp);
        container.add(Box.createVerticalStrut(10));
        temp = new Box(0);
        temp.add(this.type);
        temp.add(Box.createHorizontalGlue());
        container.add(temp);
        container.add(Box.createVerticalStrut(5));
        this.campaignType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (!MainWorkPane.this.campaignType.getSelectedItem().equals(MainWorkPane.GAME_TYPE_CAMPAIGN)) {
                    MainWorkPane.this.description.setEnabled(false);
                    MainWorkPane.this.description.setEditable(false);
                    enableDescription.setEnabled(false);
                } else {
                    MainWorkPane.this.description.setEnabled(true);
                    MainWorkPane.this.description.setEditable(true);
                    enableDescription.setEnabled(true);
                }
            }
        });
        container.add(this.campaignType);
        container.add(Box.createVerticalStrut(10));
        temp = new Box(0);
        temp.add(this.fileName);
        temp.add(Box.createHorizontalGlue());
        container.add(temp);
        container.add(Box.createVerticalStrut(5));
        container.add(this.campaignName);
        container.add(Box.createVerticalStrut(10));
        temp = new Box(0);
        temp.add(this.filePath);
        temp.add(Box.createHorizontalGlue());
        container.add(temp);
        container.add(Box.createVerticalStrut(5));
        Box outputPath = new Box(0);
        outputPath.add(this.path);
        outputPath.add(Box.createHorizontalStrut(5));
        this.destPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser src = new JFileChooser();
                src.setMultiSelectionEnabled(false);
                src.setFileSelectionMode(1);
                int returnVal = src.showDialog(MainWorkPane.this, null);
                if (returnVal == 0) {
                    MainWorkPane.this.path.setText(src.getSelectedFile().getAbsolutePath());
                }
            }
        });
        outputPath.add(this.destPath);
        container.add(outputPath);
        container.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)container, "Center");
    }

    private void doCreateButtonPart() {
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        this.create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWorkPane.this.handleConfigCreation();
            }
        });
        this.close.addActionListener(this.getClosingAction());
        buttons.add(this.create);
        buttons.add(this.close);
        this.getContentPane().add((Component)buttons, "South");
    }

    private void handleConfigCreation() {
        int result;
        String message;
        String windowTitle;
        String campaign;
        int index;
        File testDir;
        if (this.listData.size() == 0) {
            String windowTitle2 = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", this.getLocale());
            String message2 = ResourceBundleUtil.getStringForLocale("dialog.errorMessage1.label.text", this.getLocale());
            JOptionPane.showMessageDialog(this, message2, windowTitle2, 0);
            return;
        }
        if (this.listData.size() > 10) {
            String windowTitle3 = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", this.getLocale());
            String message3 = ResourceBundleUtil.getStringForLocale("dialog.errorMessage2.label.text", this.getLocale());
            JOptionPane.showMessageDialog(this, message3, windowTitle3, 0);
            return;
        }
        if (this.campaignName.getText().length() == 0) {
            String windowTitle4 = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", this.getLocale());
            String message4 = ResourceBundleUtil.getStringForLocale("dialog.errorMessage3.label.text", this.getLocale());
            JOptionPane.showMessageDialog(this, message4, windowTitle4, 0);
            return;
        }
        if (this.campaignName.getText().length() > 10) {
            String windowTitle5 = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", this.getLocale());
            String message5 = ResourceBundleUtil.getStringForLocale("dialog.errorMessage4.label.text", this.getLocale());
            JOptionPane.showMessageDialog(this, message5, windowTitle5, 0);
            return;
        }
        if (this.path.getText().length() == 0) {
            String windowTitle6 = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", this.getLocale());
            String message6 = ResourceBundleUtil.getStringForLocale("dialog.errorMessage5.label.text", this.getLocale());
            JOptionPane.showMessageDialog(this, message6, windowTitle6, 0);
            return;
        }
        if (this.path.getText().length() > 0 && (testDir = new File(this.path.getText())) != null && !testDir.isDirectory()) {
            String windowTitle7 = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", this.getLocale());
            String message7 = ResourceBundleUtil.getStringForLocale("dialog.message.destinationFolder.label.text", this.getLocale());
            int result2 = JOptionPane.showConfirmDialog(this, message7, windowTitle7, 0);
            if (result2 == 0) {
                testDir.mkdir();
            } else {
                return;
            }
        }
        if ((index = (campaign = this.campaignName.getText()).indexOf(".")) != -1) {
            campaign = campaign.substring(0, index - 1);
        }
        String destinationPK3File = String.valueOf(this.path.getText()) + File.separator + campaign + ".pk3";
        String destinationCFGFile = String.valueOf(this.path.getText()) + File.separator + campaign + ".cfg";
        File destinationPK3 = new File(destinationPK3File);
        File destinationCFG = new File(destinationCFGFile);
        boolean destinationPK3FileExists = destinationPK3.exists();
        boolean destinationCFGFileExists = destinationCFG.exists();
        if (destinationPK3FileExists) {
            windowTitle = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", this.getLocale());
            message = ResourceBundleUtil.getStringForLocale("dialog.message.destinationFile.label.text", this.getLocale());
            result = JOptionPane.showConfirmDialog(this, message, windowTitle, 0);
            if (result == 0) {
                destinationPK3.delete();
            } else {
                return;
            }
        }
        if (destinationCFGFileExists) {
            windowTitle = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", this.getLocale());
            message = ResourceBundleUtil.getStringForLocale("dialog.message.destinationFile.label.text", this.getLocale());
            result = JOptionPane.showConfirmDialog(this, message, windowTitle, 0);
            if (result == 0) {
                destinationCFG.delete();
            } else {
                return;
            }
        }
        String camgaignName = campaign;
        String camgaignPath = this.path.getText();
        String[] camgaignMaps = new String[this.listData.getSize()];
        int counter = 0;
        Enumeration elements = this.listData.elements();
        while (elements.hasMoreElements()) {
            camgaignMaps[counter] = (String)elements.nextElement();
            ++counter;
        }
        String camgaignDescription = this.description.isEnabled() ? this.description.getText() : null;
        String selectedType = (String)this.campaignType.getSelectedItem();
        if (selectedType.equals(GAME_TYPE_CAMPAIGN)) {
            new CampaignFileProducer(camgaignName, camgaignPath, camgaignMaps, camgaignDescription).doCreateContent();
        } else if (selectedType.equals(GAME_TYPE_OBJECTIVE)) {
            new ObjectiveFileProducer(camgaignName, camgaignPath, camgaignMaps, camgaignDescription).doCreateContent();
        } else if (selectedType.equals(GAME_TYPE_STOPWATCH_AB)) {
            new StopWatchABFileProducer(camgaignName, camgaignPath, camgaignMaps, camgaignDescription).doCreateContent();
        } else if (selectedType.equals(GAME_TYPE_STOPWATCH_ABBA)) {
            new StopWatchABBAFileProducer(camgaignName, camgaignPath, camgaignMaps, camgaignDescription).doCreateContent();
        }
        String date = new SimpleDateFormat(MainWorkPane.getDatePatternAsString(this.getLocale())).format(new Date());
        StringBuffer buffer = new StringBuffer();
        buffer.append(ResourceBundleUtil.getStringForLocale("dialog.message.success.global1.label.text", this.getLocale())).append("\n").append("\n").append("\n").append(ResourceBundleUtil.getStringForLocale("dialog.message.success.global3.label.text", this.getLocale())).append(": " + campaign).append("\n").append(ResourceBundleUtil.getStringForLocale("dialog.message.success.global4.label.text", this.getLocale())).append(": " + this.path.getText()).append("\n").append(ResourceBundleUtil.getStringForLocale("dialog.message.success.global5.label.text", this.getLocale())).append(": " + date).append("\n");
        JOptionPane.showMessageDialog(this, buffer.toString(), ResourceBundleUtil.getStringForLocale("dialog.message.success.global6.label.text", this.getLocale()), -1);
    }

    public static String getDatePatternAsString(Locale aLocale) {
        DateFormat dateFormat = DateFormat.getDateInstance(3, aLocale);
        return ((SimpleDateFormat)dateFormat).toPattern();
    }

    private JMenuBar doCreateMenuBar() {
        JMenuBar result = new JMenuBar();
        result.add(new MenuItemSettings(this));
        result.add(new MenuItemAbout(this));
        return result;
    }

    private ActionListener getClosingAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String windowTitle = ResourceBundleUtil.getStringForLocale("dialog.message.label.text", MainWorkPane.this.getLocale());
                String message = ResourceBundleUtil.getStringForLocale("dialog.message.closeWindow.label.text", MainWorkPane.this.getLocale());
                int returnVal = JOptionPane.showConfirmDialog(MainWorkPane.this, message, windowTitle, 0);
                if (returnVal == 0) {
                    System.exit(0);
                }
            }
        };
    }
}

